/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.project.DBProject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LatentProbabilityPanel
extends JPanel {
    private static Logger _LOG = Logger.getLogger(LatentProbabilityPanel.class.getPackage().getName());
    DBProject _dbProject;
    boolean _isAdmin;
    JComboBox _ctrlPrType;

    public LatentProbabilityPanel() {
        this.build();
    }

    public void init(DBProject dbProject, boolean isAdmin) {
        String property;
        DBObjProperty dbObjProp;
        DBObject dbObj;
        this._dbProject = dbProject;
        this._isAdmin = isAdmin;
        this._ctrlPrType.setEnabled(this._isAdmin);
        if (this._dbProject == null) {
            return;
        }
        TypeProbability type = null;
        if (this._dbProject.getDBFolder() != null && (dbObj = this._dbProject.getDBFolder().getObject()) != null && (dbObjProp = dbObj.getProperty("project.latentprobability.defaultvalue")) != null && !(property = dbObjProp.getValue()).isEmpty() && (type = TypeProbability.valueOf(property.toUpperCase())) == null) {
            _LOG.warning("Extended property for 'project.latentprobability.defaultvalue' with unknow value : " + property);
        }
        if (type != null) {
            this._ctrlPrType.setSelectedItem((Object)type);
        }
    }

    public void save() {
        if (!this._isAdmin) {
            return;
        }
        if (this._dbProject == null) {
            return;
        }
        if (this._dbProject.getDBFolder() == null) {
            return;
        }
        DBObject dbObj = this._dbProject.getDBFolder().getObject();
        if (dbObj == null) {
            return;
        }
        TypeProbability probability = (TypeProbability)((Object)this._ctrlPrType.getSelectedItem());
        if (probability == null) {
            return;
        }
        DBObjProperty dbObjProp = dbObj.getProperty("project.latentprobability.defaultvalue");
        if (dbObjProp == null) {
            dbObjProp = new DBObjProperty();
            dbObjProp.setName("project.latentprobability.defaultvalue");
            dbObjProp.setType("String");
            dbObjProp.setValue(probability.name().toLowerCase());
            dbObj.addProperty(dbObjProp);
        } else {
            dbObjProp.setValue(probability.name().toLowerCase());
        }
    }

    private void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgObj.getString("DLG_LATENTPROBABILITY_LABEL"))));
        JLabel lbl = new JLabel(ResMsgObj.getString("DLG_LATENTPROBABILITY_TYPE"));
        this.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlPrType = new JComboBox();
        this.add((Component)this._ctrlPrType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlPrType.addItem(TypeProbability.BDD);
        this._ctrlPrType.addItem(TypeProbability.MCS);
        this._ctrlPrType.addItem(TypeProbability.ARP1);
        this._ctrlPrType.addItem(TypeProbability.ARP2);
        this._ctrlPrType.setRenderer(TypeProbability.createListCellRenderer());
        this._ctrlPrType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LatentProbabilityPanel.this._dbProject.setModified(true);
            }
        });
    }
}

