/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.compareConflict.Test;

import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareDiffText;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CompareDiffTextTU {
    @Test
    public void testCompareSimpleText() {
        String empty = "";
        String textA = "AaBbCc";
        String textB = "CcBbAa";
        this.startTest(textA, empty, new CompareDiffText.Diff(CompareDiffText.DiffType.REMOVED, textA));
        this.startTest(empty, textA, new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, textA));
        this.startTest(textA, textA, new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, textA));
        this.startTest(textA, textB, new CompareDiffText.Diff(CompareDiffText.DiffType.REMOVED, textA), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, textB));
    }

    @Test
    public void testComparePreffixSuffixText() {
        String preffix = "Preffix";
        String textA = "a015b035-b4fe-47d7-9d2e-378e2f4d8e49";
        String suffix = "Suffix";
        this.startTest(preffix + textA, textA, new CompareDiffText.Diff(CompareDiffText.DiffType.REMOVED, preffix), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, textA));
        this.startTest(textA, textA + suffix, new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, textA), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, suffix));
        String textB = "30dfe80b-2a01-4588-acf5-8a97a19188a8";
        this.startTest(preffix + textA + suffix, preffix + textB + suffix, new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, preffix), new CompareDiffText.Diff(CompareDiffText.DiffType.REMOVED, textA), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, textB), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, suffix));
    }

    @Test
    public void testCompareFFT2042() {
        String textA = "assert\n\ntoto=true;";
        String textB = "assert\n\n\ntoto=true;";
        this.startTest(textA, textB, new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, "assert\n\n"), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, "\n"), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, "toto=true;"));
    }

    @Test
    public void testCompareComplexText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n").append("Maecenas et magna mattis, rutrum augue in, euismod orci.\n").append("Mauris semper ex nec mi dignissim, et gravida tellus ullamcorper.\n").append("Praesent sit amet erat non quam porttitor posuere in at arcu.\n").append("Curabitur et ex sed elit tempor imperdiet.\n").append("Sed rhoncus egestas orci, ut finibus ex pellentesque sit amet.");
        String textA = sb.toString();
        sb = new StringBuilder();
        sb.append("Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n").append("Maecenas et magna mattis, Changement de texte ici. rutrum augue in, euismod orci.\n").append("OMauris semper ex nec mi dignossim, et gravida tellus ullamcorperO.\n").append("Passe sit amet erat non quamcamole porttitor posuere in at arbalettu.\n").append("Curabitur et ex sed elit  imperdiet.\n").append("\n").append("Sed rhoncus egestas orci, ut finibus ex pellentesque sit amet.");
        String textB = sb.toString();
        this.startTest(textA, textB, new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, "Lorem ipsum dolor sit amet, consectetur adipiscing elit.\nMaecenas et magna mattis, "), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, "Changement de texte ici. "), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, "rutrum augue in, euismod orci.\n"), new CompareDiffText.Diff(CompareDiffText.DiffType.REMOVED, "Mauris semper ex nec mi dignissim, et gravida tellus ullamcorper"), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, "OMauris semper ex nec mi dignossim, et gravida tellus ullamcorperO"), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, ".\nP"), new CompareDiffText.Diff(CompareDiffText.DiffType.REMOVED, "raesent sit amet erat non quam porttitor posuere in at arc"), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, "asse sit amet erat non quamcamole porttitor posuere in at arbalett"), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, "u.\nCurabitur et ex sed elit "), new CompareDiffText.Diff(CompareDiffText.DiffType.REMOVED, "tempor"), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, " imperdiet."), new CompareDiffText.Diff(CompareDiffText.DiffType.ADDED, "\n"), new CompareDiffText.Diff(CompareDiffText.DiffType.EQUALS, "\nSed rhoncus egestas orci, ut finibus ex pellentesque sit amet."));
    }

    private void startTest(String txtA, String txtB, CompareDiffText.Diff ... diffs) {
        List<CompareDiffText.Diff> list = CompareDiffText.startDiff(txtA, txtB);
        if (list.size() != diffs.length) {
            System.out.println(list);
            Assert.fail((String)"Difference entre les tailles des diffs.");
        }
        for (int i = 0; i < list.size(); ++i) {
            CompareDiffText.Diff diffRef = diffs[i];
            CompareDiffText.Diff diffRes = list.get(i);
            Assert.assertEquals((Object)diffRes, (Object)diffRef);
        }
    }
}

