/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelectFilter;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class DBWrapSaveAsDlg
extends JDialogCecilia {
    protected DBFolder.Family _dbFamily;
    protected PlugableAppl _application;
    private boolean _withVersion;
    DBFolderPanelSelect _ctrlSelect;
    DBFolderPropertiesPanel _ctrlVersion;
    JTextField _ctrlName;
    String _name;
    JRadioButton _versRB;
    JRadioButton _modelRB;

    public DBWrapSaveAsDlg(Window owner, PlugableAppl appl, DBFolder.Family dbFamily, boolean withVersion) {
        super(owner);
        this._application = appl;
        this._dbFamily = dbFamily;
        this._withVersion = withVersion;
        this._ctrlSelect = this.createPanelSelect();
        if (this._withVersion) {
            this._ctrlVersion = this.createVersionPanel();
            this._ctrlVersion.setWithAccess(false);
            this._ctrlVersion.setWithComment(false);
        }
    }

    protected DBFolder.Family getDBFamily() {
        return this._dbFamily;
    }

    protected DBFolderPanelSelect createPanelSelect() {
        return new DBFolderPanelSelectFilter(this._application, this._dbFamily){

            @Override
            protected boolean selectThisFolder(DBFolder dbFolder) {
                return true;
            }
        };
    }

    public DBFolderPanelSelect getPanelSelect() {
        return this._ctrlSelect;
    }

    public void make(Window owner) {
        JPanel mainPanel;
        this._ctrlSelect.getCtrlTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBFolder dbFolder = DBWrapSaveAsDlg.this._ctrlSelect.getSelectFolder(false);
                if (dbFolder == null) {
                    return;
                }
                if (dbFolder.isVersion()) {
                    return;
                }
                if (dbFolder.isModel()) {
                    return;
                }
                DBWrapSaveAsDlg.this.validDialog();
            }
        });
        this._ctrlSelect.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this._withVersion) {
            this._ctrlVersion.doCreate();
            mainPanel = this.createCardLayout();
        } else {
            mainPanel = new JPanel(new BorderLayout());
            mainPanel.add(this.createNamePanel(), "North");
            mainPanel.add((Component)this._ctrlSelect, "Center");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
        this.setSize(375, 450);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
        this.setModal(true);
    }

    protected DBFolderPropertiesPanel createVersionPanel() {
        return new DBFolderPropertiesPanel(){

            @Override
            protected boolean verifyTargetVersion() {
                return true;
            }
        };
    }

    public DBFolderPropertiesPanel getVersionPanel() {
        return this._ctrlVersion;
    }

    private Component createNamePanel() {
        this._ctrlName = new JTextField(20);
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_NAME")), new GridBagConstraints(0, 0, 1, 1, 0.33, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 0.66, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlName.setText(this._name);
        return result;
    }

    @Override
    protected boolean verifyParameters() {
        if (this._withVersion && this._versRB.isSelected()) {
            return this.getVersionPanel().verifyParameters();
        }
        String txt = this._ctrlName.getText().trim();
        if (txt.isEmpty()) {
            this._ctrlName.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgCore.getString("MSG_ERR_TEXT_EMPTY"), this.getTitle(), 0);
            return false;
        }
        if (DBFactory.verifyName(txt) != 0) {
            this._ctrlName.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgObj.getString("MSG_ERR_VERIFY_NAME"), this.getTitle(), 0);
            return false;
        }
        DBFolder dbFolder = this.getSelectFolder();
        if (dbFolder == null) {
            this._ctrlSelect.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlSelect), ResMsgObj.getString("MSG_FOLDER_SELECT_SYSTEM"), this.getTitle(), 0);
            return false;
        }
        if (this._application.getDAOFactory().createFolderDAO().getAccessRight(dbFolder, this._application.getDBUser()) != DBAccess.Right.WRITE) {
            this._ctrlSelect.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlSelect), ResMsgObj.msgFormat("MSG_OBJ_ERR_ACCESS_WRITE", dbFolder.getRefPath()), this.getTitle(), 0);
            return false;
        }
        if (dbFolder.findChild(txt) != null) {
            this._ctrlSelect.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlSelect), ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD", txt), this.getTitle(), 0);
            return false;
        }
        return true;
    }

    public void setNewName(String value) {
        this._name = value;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this._withVersion) {
            this._ctrlVersion.setTitle(title);
        }
    }

    public String getNewName() {
        if (this.isVersionCreation()) {
            return this._ctrlVersion.getDBFolder().getName();
        }
        return this._ctrlName.getText().trim();
    }

    public void setSelectFolder(DBFolder dbFolder) {
        this._ctrlSelect.setSelectFolder(dbFolder);
        if (this._application.getDAOFactory().createFolderDAO().getAccessRight(dbFolder, this._application.getDBUser()) != DBAccess.Right.WRITE) {
            this._withVersion = false;
        } else if (this._withVersion) {
            DBFolder folder = new DBFolder(dbFolder, this._application.getDBUser());
            this._ctrlVersion.setFolder(folder);
        }
    }

    public DBFolder getSelectFolder() {
        if (this.isVersionCreation()) {
            return this._ctrlVersion.getDBFolder();
        }
        TreePath path = this._ctrlSelect.getCtrlTree().getSelectionPath();
        if (path == null) {
            return null;
        }
        DBFolderTreeNode selectNode = (DBFolderTreeNode)path.getLastPathComponent();
        if (selectNode == null) {
            return null;
        }
        DBFolder select = selectNode.getDBFolder();
        if (select == null) {
            return null;
        }
        if (select.isModel()) {
            return select.getParent();
        }
        if (select.getDepthUntilRoot() != 3) {
            return null;
        }
        return select;
    }

    @Override
    public void dispose() {
        this._ctrlSelect.dispose();
        super.dispose();
    }

    private JPanel createCardLayout() {
        JPanel btnPanel = new JPanel(new GridBagLayout());
        this._versRB = new JRadioButton(ResMsgObj.getString("TITLE_GEN_CREATE_VERSION"));
        this._modelRB = new JRadioButton(ResMsgObj.getString("TITLE_GEN_CREATE_MODEL"));
        ButtonGroup grp = new ButtonGroup();
        grp.add(this._versRB);
        grp.add(this._modelRB);
        btnPanel.add((Component)this._versRB, new GridBagConstraints(0, 0, 1, 1, 100.0, 20.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        btnPanel.add((Component)this._modelRB, new GridBagConstraints(1, 0, 1, 1, 100.0, 20.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        CardLayout cardLayout = new CardLayout();
        JPanel cardPanel = new JPanel(cardLayout);
        JPanel modelPanel = new JPanel(new GridBagLayout());
        modelPanel.add(this.createNamePanel(), new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        modelPanel.add((Component)this._ctrlSelect, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        String vers = "vers";
        String model = "model";
        cardPanel.add((Component)this._ctrlVersion, vers);
        cardPanel.add((Component)modelPanel, model);
        this._versRB.addActionListener(e -> cardLayout.show(cardPanel, vers));
        this._modelRB.addActionListener(e -> cardLayout.show(cardPanel, model));
        cardPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)btnPanel, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)cardPanel, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this._versRB.setSelected(true);
        return mainPanel;
    }

    public final boolean isVersionCreation() {
        return this._versRB != null && this._versRB.isSelected();
    }
}

