/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderList;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListDropTargetListener;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListTransferable;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderTransferable;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.io.xml6.CmdExportXML6;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ExportChooseDialog
extends JDialogCecilia {
    private final CeciliaAppl _appl;
    private final JRadioButton _buttonExportAll;
    private final JRadioButton _buttonExportItems;
    private final CeciliaAction _ctrlDel;
    private final JLabel _labelNbr;
    private final ExportTableModel _modelTable;
    private final ExportTable _ctrlTable;

    public ExportChooseDialog(CeciliaAppl appl) {
        super((Window)appl.getTopWindow(), false);
        this._appl = appl;
        JPanel panel = new JPanel(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        this._buttonExportAll = new JRadioButton(ResMsgObj.getString("MSG_EXPORT_DLG_EXPORT_ALL"));
        this._buttonExportAll.setSelected(true);
        this._buttonExportItems = new JRadioButton(ResMsgObj.getString("MSG_EXPORT_DLG_EXPORT_ITEMS"));
        group.add(this._buttonExportItems);
        group.add(this._buttonExportAll);
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_REMOVE"), ResMsgCore.getString("ACTION_DEL_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportChooseDialog.this._ctrlTable.deleteSelectedRows();
            }
        };
        this._labelNbr = new JLabel(ResMsgObj.msgFormat("MSG_EXPORT_DLG_NUMBER", 0));
        this._modelTable = new ExportTableModel();
        this._ctrlTable = new ExportTable(this._modelTable);
        this._ctrlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExportChooseDialog.this.actionBtns();
            }
        });
        ExportElementsPanel drop = new ExportElementsPanel(this._ctrlTable);
        assert (drop != null);
        this._buttonExportItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportChooseDialog.this.actionBtns();
            }
        });
        this._buttonExportAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportChooseDialog.this.actionBtns();
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        panel.add((Component)this._buttonExportAll, new GridBagConstraints(0, 0, 3, 1, 100.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panel.add((Component)this._buttonExportItems, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panel.add((Component)this._labelNbr, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 13, 0, new Insets(2, 4, 2, 4), 0, 0));
        panel.add((Component)this._ctrlDel.createButton(CeciliaAction.BorderStyle.NONE), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 4), 0, 0));
        panel.add((Component)new JScrollPane(this._ctrlTable), new GridBagConstraints(0, 2, 3, 1, 100.0, 100.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.createButPanel(false), "South");
        this._ctrlTable.setEnabled(false);
        this._ctrlDel.setEnabled(false);
        this._labelNbr.setEnabled(false);
        this.init();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(appl.getTopWindow()));
    }

    @Override
    public String getTitle() {
        return ResMsgVoc.getString("VOC_EXPORT");
    }

    public boolean isExportAll() {
        return this._buttonExportAll.isSelected();
    }

    public Set<DBFolder> getSelectedFolders() {
        assert (!this.isExportAll());
        LinkedHashSet<DBFolder> setFolder = new LinkedHashSet<DBFolder>();
        for (int i = 0; i < this._modelTable.getRowCount(); ++i) {
            setFolder.add((DBFolder)this._modelTable.getValueAt(i, 0));
        }
        return setFolder;
    }

    void actionBtns() {
        this._ctrlTable.setEnabled(this._buttonExportItems.isSelected());
        this._ctrlDel.setEnabled(this._buttonExportItems.isSelected() && this._ctrlTable.getSelectedRowCount() > 0);
        this._labelNbr.setEnabled(this._buttonExportItems.isSelected());
    }

    void changeNbrItems() {
        this._labelNbr.setText(ResMsgObj.msgFormat("MSG_EXPORT_DLG_NUMBER", this._ctrlTable.getRowCount()));
    }

    @Override
    protected boolean verifyParameters() {
        if (this.isExportAll()) {
            int result = JOptionPane.showConfirmDialog(this, ResMsgObj.getString("MSG_EXPORT_DLG_CONFIRM_ALL"), this.getTitle(), 2, 3);
            return result == 0;
        }
        if (this._modelTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, ResMsgObj.getString("MSG_EXPORT_DLG_NO_ITEMS"), this.getTitle(), 0);
            return false;
        }
        return true;
    }

    public int addToModel(DBFolder node, short filterFamilyFlag, Set<DBFolder> nodesTreated) {
        if (nodesTreated.contains(node)) {
            return 0;
        }
        nodesTreated.add(node);
        int res = 0;
        if (node.isVersion()) {
            if (filterFamilyFlag == 0 || filterFamilyFlag == node.getFamilyFlag()) {
                this.addToModel(node);
                ++res;
            }
        } else {
            boolean treatChildren = false;
            if (node.isFolder() || node.isModel() || node.isSystem()) {
                treatChildren = true;
            }
            if (treatChildren) {
                List<DBFolder> children = node.getChildren();
                if (children == null) {
                    children = this._appl.getDAOFactory().createFolderDAO().findChildren(node);
                }
                for (DBFolder dbChild : children) {
                    res += this.addToModel(dbChild, filterFamilyFlag, nodesTreated);
                }
            }
        }
        return res;
    }

    private void addToModel(DBFolder node) {
        this._modelTable.insertRow(this._modelTable.getRowCount(), new Object[]{node});
        this._modelTable.fireTableDataChanged();
    }

    @Override
    protected void validDialog() {
        if (this.verifyParameters()) {
            this._result = true;
            this.setVisible(false);
            LinkedHashSet<DBFolder> foldersToExport = new LinkedHashSet<DBFolder>();
            if (this.isExportAll()) {
                foldersToExport.add(this._appl.getDAOFactory().createFolderDAO().getRootID("ROOT"));
            } else {
                foldersToExport = this.getSelectedFolders();
            }
            CmdExportXML6 cmd = new CmdExportXML6(this._appl, this._appl.getTopWindow(), foldersToExport, this._appl.getDBUser());
            cmd.realiseDo();
        }
    }

    public class ExportTableModel
    extends DefaultTableModel {
        public static final int IDX_COL_DBFOLDER = 0;

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return ResMsgObj.getString("MSG_EXPORT_DLG_FOLDER_COLUMN_NAME");
                }
            }
            assert (false) : "ERR OUT OF INDEX TABLE MODEL";
            return ResMsgVoc.getString("VOC_ERROR");
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return DBFolder.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    public class ExportTable
    extends JTable
    implements JTableTransfertHandler.HelperConvert {
        public ExportTable(TableModel tm) {
            super(tm);
            this.setSelectionMode(2);
            this.setDefaultRenderer(DBFolder.class, new ExportTableRenderer());
            this.setPreferredScrollableViewportSize(new Dimension(350, 200));
            this.setFillsViewportHeight(true);
            this.setCellSelectionEnabled(true);
            this.setTransferHandler(new JTableTransfertHandler());
            this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
            this.getActionMap().put("delete", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportTable.this.deleteSelectedRows();
                }
            });
        }

        public final void deleteSelectedRows() {
            int[] rowsSelected = this.getSelectedRows();
            if (rowsSelected.length == 0) {
                return;
            }
            int[] rowsSelectedInv = new int[rowsSelected.length];
            for (int i = 0; i < rowsSelected.length; ++i) {
                rowsSelectedInv[i] = rowsSelected[rowsSelected.length - 1 - i];
            }
            for (int idxRow : rowsSelectedInv) {
                ((DefaultTableModel)this.getModel()).removeRow(idxRow);
            }
            ExportChooseDialog.this.changeNbrItems();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj == null) {
                return "";
            }
            switch (col) {
                case 0: {
                    DBFolder folder = (DBFolder)obj;
                    return folder.getRefPath();
                }
            }
            assert (false);
            return "";
        }
    }

    public class ExportElementsPanel
    extends DropTarget {
        public ExportElementsPanel(JComponent component) {
            super(component, 2, new ExportChooseDropTargetListener(component));
        }
    }

    public class ExportTableRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            assert (value instanceof DBFolder);
            DBFolder folder = (DBFolder)value;
            JLabel label = (JLabel)comp;
            label.setText(folder.getRefPath());
            ImageIcon icon = DBFolderResources.getIcon(folder, true, true, false, false);
            if (icon != null) {
                label.setIcon(icon);
            }
            return label;
        }
    }

    class ExportChooseDropTargetListener
    extends DBFolderListDropTargetListener {
        public ExportChooseDropTargetListener(JComponent c) {
            super(c);
        }

        @Override
        protected boolean isDragAcceptable(DropTargetDragEvent event) {
            boolean superResult = super.isDragAcceptable(event);
            if (superResult) {
                return true;
            }
            if (event.isDataFlavorSupported(DBFolderTransferable.DB_FLAVOR)) {
                return this.isDropAcceptable(event.getDropAction(), event.getTransferable());
            }
            return false;
        }

        @Override
        protected boolean isDropAcceptable(DropTargetDropEvent event) {
            boolean superResult = super.isDropAcceptable(event);
            if (superResult) {
                return true;
            }
            if (event.isDataFlavorSupported(DBFolderTransferable.DB_FLAVOR)) {
                return this.isDropAcceptable(event.getDropAction(), event.getTransferable());
            }
            return false;
        }

        @Override
        protected boolean isDropAcceptable(int dropAction, Transferable transferable) {
            boolean superResult = super.isDropAcceptable(dropAction, transferable);
            if (superResult) {
                return true;
            }
            if ((dropAction & 2) == 0) {
                return false;
            }
            try {
                DBFolder dataDnD = (DBFolder)transferable.getTransferData(DBFolderTransferable.DB_FLAVOR);
                return this.isDnDAcceptable(new DBFolderList(false, dataDnD));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        @Override
        protected boolean isDnDAcceptable(DBFolderList dataDnD) {
            return true;
        }

        @Override
        protected void dropDnD(DBFolderList dataDnD, Point point) {
            if (!ExportChooseDialog.this._ctrlTable.isEnabled()) {
                return;
            }
            Set<DBFolder> nodesTreated = ExportChooseDialog.this.getSelectedFolders();
            Collection<DBFolder> selectedFolders = dataDnD.getFolders();
            int nbrFolder = 0;
            for (DBFolder node : selectedFolders) {
                short familyFlag = node.getFamilyFlag();
                if (familyFlag == 8) {
                    familyFlag = 0;
                }
                nbrFolder += ExportChooseDialog.this.addToModel(node, familyFlag, nodesTreated);
            }
            if (nbrFolder == 0) {
                return;
            }
            ExportChooseDialog.this._ctrlTable.clearSelection();
            int sizeTable = ExportChooseDialog.this._ctrlTable.getRowCount();
            ExportChooseDialog.this._ctrlTable.setRowSelectionInterval(sizeTable - nbrFolder, sizeTable - 1);
            ExportChooseDialog.this._ctrlTable.setColumnSelectionInterval(0, 0);
            ExportChooseDialog.this.changeNbrItems();
            ExportChooseDialog.this.toFront();
            ExportChooseDialog.this._ctrlTable.requestFocus();
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            ExportChooseDialog.this._buttonExportItems.setSelected(true);
            ExportChooseDialog.this.actionBtns();
            event.acceptDrop(2);
            Transferable transferable = event.getTransferable();
            try {
                DBFolderList dataDnD = (DBFolderList)transferable.getTransferData(DBFolderListTransferable.DB_FLAVOR);
                this.dropDnD(dataDnD, event.getLocation());
                event.dropComplete(true);
            }
            catch (IOException e) {
                ExportChooseDialog.this._buttonExportAll.setSelected(true);
                ExportChooseDialog.this.actionBtns();
            }
            catch (UnsupportedFlavorException e) {
                try {
                    DBFolder dataDnD = (DBFolder)transferable.getTransferData(DBFolderTransferable.DB_FLAVOR);
                    DBFolderList list = new DBFolderList(false, dataDnD);
                    this.dropDnD(list, event.getLocation());
                    event.dropComplete(true);
                }
                catch (UnsupportedFlavorException e1) {
                    ExportChooseDialog.this._buttonExportAll.setSelected(true);
                    ExportChooseDialog.this.actionBtns();
                }
                catch (IOException e1) {
                    ExportChooseDialog.this._buttonExportAll.setSelected(true);
                    ExportChooseDialog.this.actionBtns();
                }
            }
        }
    }
}

