/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51AttrHandler;
import com.dassault.cecilia.io.arbor51.SA51BTPHandler;
import com.dassault.cecilia.io.arbor51.SA51CCFHandler;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51DSFHandler;
import com.dassault.cecilia.io.arbor51.SA51FMEAHandler;
import com.dassault.cecilia.io.arbor51.SA51Linker;
import com.dassault.cecilia.io.arbor51.SA51NamedParamHandler;
import com.dassault.cecilia.io.arbor51.SA51ProjectHandler;
import com.dassault.cecilia.io.arbor51.SA51SystemHandler;
import com.dassault.cecilia.io.arbor51.SA51TreeHandler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51Handler
extends SAXExtendedHandler
implements SA51Constant {
    private static String PACKAGE_PATH = SA51Handler.class.getPackage().getName().replace('.', File.separatorChar);
    private final CECFactory _cecFactory;
    private final File _file;
    private SA51Linker _linker;
    private String _login;
    private long _cpt;
    private DBFolder _root;
    private Date _currentDate = new Date(Boolean.getBoolean("cecilia.junit.arbor51") ? 1472594500000L : System.currentTimeMillis());
    List<FTVariable> _allLeaves = new ArrayList<FTVariable>();
    List<FTDefinition> _allGates = new ArrayList<FTDefinition>();
    AbstractSA51Handler _currentHandler;
    Map<FTVariable, String> _varWithLink = new HashMap<FTVariable, String>();

    public SA51Handler(File f) {
        this._cecFactory = ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO ? new DemoLimitedFactory(null, new DAOImportXmlFactory()) : new CeciliaFactory(null, new DAOImportXmlFactory());
        this._file = f;
        this._cpt = 1L;
        this._login = "admin";
        this._linker = new SA51Linker(this.getFilePathForLog(), this._cecFactory, this._currentDate, this._login);
    }

    public SA51Handler(File f, String login) {
        this(f);
        this._login = login;
        this._linker = new SA51Linker(this.getFilePathForLog(), this._cecFactory, this._currentDate, this._login);
    }

    public final CECFactory getCECFactory() {
        return this._cecFactory;
    }

    public long getCounter() {
        return this._cpt;
    }

    public long incrementCounter() {
        return this._cpt++;
    }

    public SA51Linker getLinker() {
        return this._linker;
    }

    public File getFileXML() {
        return this._file;
    }

    public String getFilePathForLog() {
        String filePath = this._file.getAbsolutePath();
        if (Boolean.getBoolean("cecilia.junit.arbor51")) {
            int pos = filePath.indexOf(PACKAGE_PATH);
            if (pos >= 0) {
                filePath = filePath.substring(pos);
            }
            filePath = filePath.replace('\\', '/');
        }
        return filePath;
    }

    public String getLogin() {
        return this._login;
    }

    public Date getCurrentDate() {
        return this._currentDate;
    }

    public void setRoot(DBFolder root) {
        if (root.getParent() != null) {
            DBFolder projectFolder = root.getParent();
            SA51Utils.linkDBFolder(this._cecFactory.createFolderDAO().getRootID("PROJECTS"), projectFolder);
            projectFolder.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)8, projectFolder.getUserFlag()));
            projectFolder.setDateCreate(AbstractSA51Handler.getLastUpdateDate());
            projectFolder.setDateModify(AbstractSA51Handler.getLastUpdateDate());
            root.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)0, root.getUserFlag()));
        } else {
            SA51Utils.linkDBFolder(this._cecFactory.createFolderDAO().getRootID("PROJECTS"), root);
            root.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)8, root.getUserFlag()));
        }
        root.setDateCreate(AbstractSA51Handler.getLastUpdateDate());
        root.setDateModify(AbstractSA51Handler.getLastUpdateDate());
        this._root = root;
        this._cpt = root.getID() + 1L;
        this._linker.setRoot(root);
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._currentHandler != null) {
            this._currentHandler.startAction(name, attrs, true);
        } else if (EXPORT_TAG_LIST.contains(name)) {
            this._currentHandler = this.getHandler(name);
            this._currentHandler.startAction(name, attrs, true);
        } else if (name.equals("cec.export")) {
            throw new SAXParseException(ResMsgSA51.getString("MSG_ERR_CECILIAV6"), this.getLocator());
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._currentHandler != null && this._currentHandler.endAction(name, attrs, txt)) {
            this._cpt = this._currentHandler.getCounter();
            this._currentHandler = null;
        } else if ("EXPORT".equals(name)) {
            this.getLinker().setIncrement(this._cpt);
            this.getLinker().linkElements(TypeObject.BTP, TypeObject.ATTRIBUTE, TypeObject.CCF, TypeObject.SUBTREE);
            this.getLinker().linkElements(TypeObject.DSF);
            this.getLinker().generateEmptyLinksDSF();
            return true;
        }
        return false;
    }

    private final AbstractSA51Handler getHandler(String name) {
        AbstractSA51Handler handler = null;
        if ("BTP".equals(name)) {
            handler = new SA51BTPHandler(this);
        } else if ("PARAMETER".equals(name)) {
            handler = new SA51NamedParamHandler(this);
        } else if ("CCF_LIST".equals(name)) {
            handler = new SA51CCFHandler(this);
        } else if ("ATTRIBUTE_LIST".equals(name)) {
            handler = new SA51AttrHandler(this);
        } else if ("PROJECT".equals(name)) {
            handler = new SA51ProjectHandler(this);
        } else if ("SYSTEM".equals(name)) {
            handler = new SA51SystemHandler(this._root, this);
        } else if ("TREE".equals(name)) {
            handler = new SA51TreeHandler(this._root, this);
        } else if ("DSF".equals(name)) {
            handler = new SA51DSFHandler(this._root, this);
        } else if ("FMEA_MODEL".equals(name)) {
            handler = new SA51FMEAHandler(this);
        } else if ("FMEA".equals(name)) {
            handler = new SA51FMEAHandler(this, this._root);
        }
        return handler;
    }

    static enum TypeObject {
        BTP,
        ATTRIBUTE,
        CCF,
        DSF,
        SUBTREE;

    }

    public static class IdentifiantObject {
        private final TypeObject _type;
        private final String _name;
        private String _value;
        private FTEvent _event;
        private FTVariableAbstract _var;
        private FTEquationAbstract _treeEquation;
        private FTConfig _config;
        private String _generic;
        private DBFolder _folder;
        private boolean _isDSF;
        private String _eventName;

        private IdentifiantObject(TypeObject type, String name) {
            this._type = type;
            this._name = name;
        }

        public IdentifiantObject(TypeObject type, String name, FTEvent event) {
            this(type, name);
            this._event = event;
        }

        public IdentifiantObject(TypeObject type, String name, FTVariableAbstract var) {
            this(type, name);
            this._var = var;
        }

        public IdentifiantObject(TypeObject type, String name, FTEvent event, String value) {
            this(type, name, event);
            this._value = value;
        }

        public IdentifiantObject(TypeObject type, String name, DBFolder folder) {
            this(type, name);
            this._folder = folder;
        }

        public IdentifiantObject(TypeObject type, String name, FTConfig config) {
            this(type, name);
            this._config = config;
        }

        public final TypeObject getType() {
            return this._type;
        }

        public final String getName() {
            return this._name;
        }

        public final String getValue() {
            return this._value;
        }

        public final FTEvent getEvent() {
            return this._event;
        }

        public final FTEquationAbstract getTree() {
            return this._treeEquation;
        }

        public final FTVariableAbstract getVariable() {
            return this._var;
        }

        public final void setTree(FTEquationAbstract eq) {
            this._treeEquation = eq;
        }

        public final DBFolder getFolder() {
            return this._folder;
        }

        public final FTConfig getConfig() {
            return this._config;
        }

        public final void setGeneric(String generic) {
            this._generic = generic;
        }

        public final String getGeneric() {
            return this._generic;
        }

        public final void setIsDSF(boolean isDSF) {
            this._isDSF = isDSF;
        }

        public final boolean isDSF() {
            return this._isDSF;
        }

        public final void setEventName(String name) {
            this._eventName = name;
        }

        public final String getEventName() {
            return this._eventName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Nom : ").append(this.getName()).append(" Type : ").append((Object)this.getType()).append("->").append(this._folder == null ? "Is in need" : "Is an Object");
            return sb.toString();
        }
    }
}

