/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXActionHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51NamedParamHandler
extends AbstractSA51Handler
implements SAXActionHandler,
SA51Constant {
    private DBFolder _paramFolder;
    private TypeParam _paramType;
    private Param _parameter;
    private List<DBParam> _allParams = new ArrayList<DBParam>();
    private DAOObject _daoObj;
    private SA51Utils.Pair _p;
    private String _comments;
    List<DBFolder> _children = new ArrayList<DBFolder>();
    public static Map<String, TypeParam> PARAMS_TYPES = new LinkedHashMap<String, TypeParam>();

    public List<DBParam> getParams() {
        return this._allParams;
    }

    public SA51NamedParamHandler(SA51Handler handler) {
        super(handler);
        this._paramFolder = this.getCeciFactory().createFolderDAO().getRootID("LAW_PARAMETERS").findChild("Default");
        if (this._paramFolder == null) {
            this._paramFolder = this.createNewFolder("Default", DBFolder.createFlagsFolder(DBFolder.Family.PARAMETER, (short)0, (short)0), new Date(0L), new Date(0L), null, this.getCeciFactory().createFolderDAO().getRootID("LAW_PARAMETERS"));
        }
        this._daoObj = this.getCeciFactory().createObjectDAO();
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if ("NPARAM".equals(name)) {
            String attrName = this.getAttribute(attrs, "NAME");
            this._p = SA51Utils.createVarWithVer(attrName);
            if (this._p == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", name, "NAME", attrName), this.getLocator()));
            }
            this._comments = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
        } else if (PARAMS_TYPES.containsKey(name)) {
            this._paramType = PARAMS_TYPES.get(name);
        } else if ("VALUE_PARAMETER".equals(name)) {
            double d = this.getNumericalAttribute(attrs, "VALUE", 1).doubleValue();
            this._parameter = new ParamValue(this._paramType, d);
        } else if ("LOGNORMAL".equals(name)) {
            double mean = this.getNumericalAttribute(attrs, "MEAN", 1).doubleValue();
            double err = this.getNumericalAttribute(attrs, "ERROR", 1).doubleValue();
            Law law = new Law(0, this.getCeciFactory().getLawManager().getParameterManager());
            law.setParamAt(0, new ParamValue(this._paramType, mean));
            law.setParamAt(1, new ParamValue(this._paramType, err));
            this._parameter = new ParamLaw(this._paramType, law);
        } else if ("UNIFORM".equals(name)) {
            double min = this.getNumericalAttribute(attrs, "MIN", 1).doubleValue();
            double max = this.getNumericalAttribute(attrs, "MAX", 1).doubleValue();
            Law law = new Law(1, this.getCeciFactory().getLawManager().getParameterManager());
            law.setParamAt(0, new ParamValue(this._paramType, min));
            law.setParamAt(1, new ParamValue(this._paramType, max));
            this._parameter = new ParamLaw(this._paramType, law);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if ("NPARAM".equals(name)) {
            DBFolder folderVers;
            this._parameter.setType(this._paramType);
            String nameParam = this.getValidName(this._p.getName(), DBFolder.Family.PARAMETER, name, "NAME");
            DBFolder paramFolder = this._paramFolder.findChild(this._p.getName());
            if (paramFolder == null) {
                paramFolder = this.createNewFolder(nameParam, DBFolder.createFlagsModel(DBFolder.Family.PARAMETER, (short)0, (short)0), new Date(0L), new Date(0L), null, this._paramFolder);
            }
            if ((folderVers = paramFolder.findChild(this._p.getVersion())) != null) {
                this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_ERR_FOLDER_EXIST", this._p, this._paramFolder.getFamily().toString().toLowerCase()), this.getLocator()));
            } else {
                folderVers = this.createNewFolder(this._p.getVersion(), DBFolder.createFlagsVersion(DBFolder.Family.PARAMETER, (short)0, (short)0), new Date(0L), new Date(0L), this._comments == null || this._comments.isEmpty() ? null : this._comments, paramFolder);
                DBParam dbParam = new DBParam(folderVers);
                dbParam.setType(this._paramType);
                dbParam.setValue(this._parameter);
                DBObject obj = new DBObject(folderVers.getID()).setFolder(folderVers);
                folderVers.setObject(obj);
                for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
                    dbParam.getLogs().addLog(log);
                }
                this.addDefaultLog(dbParam);
                DBObjModel dbObjModel = dbParam.writeDBObjModel(false);
                obj.addModel(new DBObjModelBytes(dbObjModel));
                DBObjModel dbObjLogs = dbParam.writeDBObjLogs(false);
                obj.addModel(new DBObjModelBytes(dbObjLogs));
                this._daoObj.putWrap(obj, dbParam);
            }
            return false;
        }
        return "PARAMETER".equals(name);
    }

    static {
        PARAMS_TYPES.put("DELAY", TypeParam.DELAY);
        PARAMS_TYPES.put("PROBABILITY", TypeParam.PROBABILITY);
        PARAMS_TYPES.put("FACTOR", TypeParam.FACTOR);
        PARAMS_TYPES.put("RATE", TypeParam.RATE);
        PARAMS_TYPES.put("BOOLEAN", TypeParam.BOOLEAN);
    }
}

