/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.project.AverageAttributeCriterion;
import com.dassault.cecilia.dbobj.project.AverageAttributeDriver;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51SystemHandler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXActionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51ProjectHandler
extends AbstractSA51Handler
implements SAXActionHandler,
SA51Constant {
    private DBProject _project;
    private DBFolder _projectFolder;
    private DAOFolder _daoFolder;
    private SA51SystemHandler _systemHandler;
    private DBAttrib _attribute;
    private AverageAttributeDriver _attrDriver;
    private List<CriticityCriterion> _criticities = new ArrayList<CriticityCriterion>();
    private List<AverageAttributeCriterion> _collecCrit = new ArrayList<AverageAttributeCriterion>();
    private List<AverageAttributeDriver> _collecDriv = new ArrayList<AverageAttributeDriver>();

    public SA51ProjectHandler(SA51Handler handler) {
        super(handler);
        this._daoFolder = this.getCeciFactory().createFolderDAO();
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._systemHandler != null) {
            this._systemHandler.startAction(name, attrs, false);
        } else if ("IDENTIFICATION".equals(name)) {
            String nameFolder = this.getValidName(this.getAttribute(attrs, "NAME"), DBFolder.Family.PROJECT, name, "NAME");
            String dateCreation = this.getAttribute(attrs, "CREATION_DATE");
            String dateUpdate = this.getAttribute(attrs, "UPDATE_DATE");
            String comment = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
            this._projectFolder = this._daoFolder.getRootID("PROJECTS").findChild(nameFolder);
            if (this._projectFolder == null) {
                this._projectFolder = this.createNewFolder(nameFolder, DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)8, (short)0), SA51Utils.convertDate(dateCreation), SA51Utils.convertDate(dateUpdate), comment == null || comment.isEmpty() ? null : comment, this._daoFolder.getRootID("PROJECTS"));
                this._project = new DBProject(this._projectFolder);
            } else if (this._projectFolder.getUserFlag() == 1) {
                this._projectFolder.setUserFlag((short)0);
                this._projectFolder.setDateCreate(SA51Utils.convertDate(dateCreation));
                this._projectFolder.setDateModify(SA51Utils.convertDate(dateUpdate));
                if (comment != null && !comment.isEmpty()) {
                    this._projectFolder.setDescription(comment);
                }
                this._project = new DBProject(this._projectFolder);
            } else {
                this._project = (DBProject)this.getCeciFactory().createObjectDAO().getWrap(this._projectFolder.getObject());
                this._projectFolder.setDateCreate(SA51Utils.convertDate(dateCreation));
                this._projectFolder.setDateModify(SA51Utils.convertDate(dateUpdate));
            }
        } else if ("COMPUTE_OPTIONS".equals(name)) {
            String defaultProba = this.getAttribute(attrs, "DEFAULT_PROPABILITIES");
            String averageFlightDuration = this.getAttribute(attrs, "AVERAGE_FLIGHT_DURATION");
            if (averageFlightDuration != null) {
                this._project.setFlightDuration(Double.parseDouble(averageFlightDuration));
            }
            if (defaultProba != null) {
                this._project.setTypeCompute(SA51ProjectHandler.getTypeProbability(defaultProba));
            }
        } else if ("ATTRIBUTE_DRIVE_SELECT".equals(name)) {
            DBFolder attrVers;
            String attrPath = this.getAttribute(attrs, "ATTRIBUTE_PATH");
            SA51Utils.Pair p = SA51Utils.createVarWithVer(attrPath);
            if (p == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", name, "ATTRIBUTE_PATH", attrPath), this.getLocator()));
            }
            if ((attrVers = SA51Utils.goToChild(this._daoFolder.getRootID("ATTRIBUTES"), "Default", p.getName(), p.getVersion())) == null) {
                this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_ERR_FOLDER_UNKNOW", p.toString(), "ATTRIBUTES".toLowerCase()), this.getLocator()));
            } else {
                DBObject obj = attrVers.getObject();
                this._attribute = (DBAttrib)this.getCeciFactory().createObjectDAO().getWrap(obj);
                this._attrDriver = new AverageAttributeDriver(this._attribute);
            }
        } else if ("ATTRIBUTE_DRIVE_DEFINE".equals(name)) {
            AttrCriterion.Operator op = SA51ProjectHandler.getOperator(this.getAttribute(attrs, "OP"));
            AttrCriterion attrCrit = new AttrCriterion(this._attribute, op, this.getAttribute(attrs, "DATA"));
            AverageAttributeCriterion.ProbabilityChoice proba = SA51ProjectHandler.getProbabilityChoice(this.getAttribute(attrs, "CHOICE"));
            Param p = this.getParameter(this.getCeciFactory(), this.getAttribute(attrs, "PARAMETER_PATH"), name, "PARAMETER_PATH");
            AverageAttributeCriterion avgAttrCrit = new AverageAttributeCriterion(attrCrit, proba, p);
            this._collecCrit.add(avgAttrCrit);
        } else if ("CRITICITY".equals(name)) {
            CriticityCriterion cc = new CriticityCriterion();
            String nameCC = this.getAttribute(attrs, "NAME");
            double probability = this.getNumericalAttribute(attrs, "PROBABILITY", 1).doubleValue();
            int order = this.getNumericalAttribute(attrs, "ORDER", 0).intValue();
            String lsrLatent = this.getAttribute(attrs, "LSR_LATENT");
            String lsrEvident = this.getAttribute(attrs, "LSR_EVIDENT");
            if (lsrEvident != null) {
                cc.setLSREvident(Double.parseDouble(lsrEvident));
            }
            if (lsrLatent != null) {
                cc.setLSRLatent(Double.parseDouble(lsrLatent));
            }
            cc.setName(nameCC);
            cc.setOrder(order);
            cc.setProbability(probability);
            boolean equal = false;
            for (CriticityCriterion tmp : this._criticities) {
                String tmpName = tmp.getName();
                if (!tmpName.equals(cc.getName())) continue;
                equal = true;
                break;
            }
            if (!equal) {
                this._criticities.add(cc);
            }
        } else if ("SYSTEM".equals(name)) {
            this._systemHandler = new SA51SystemHandler(this._projectFolder, this.getHandler());
            this._systemHandler.startAction(name, attrs, true);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._systemHandler != null && this._systemHandler.endAction(name, attrs, txt)) {
            this._systemHandler = null;
        } else if ("ATTRIBUTE_DRIVE_SELECT".equals(name)) {
            if (this._attrDriver != null) {
                this._attrDriver.setCriterions(new ArrayList<AverageAttributeCriterion>(this._collecCrit));
                this._collecCrit.clear();
                this._collecDriv.add(this._attrDriver.getCopy());
            }
        } else if ("COMPUTE_OPTIONS".equals(name)) {
            this._project.setAttributeDrivers(new ArrayList<AverageAttributeDriver>(this._collecDriv));
            this._collecDriv.clear();
        } else if ("CRITICITY_LIST".equals(name)) {
            ArrayList<CriticityCriterion> l = new ArrayList<CriticityCriterion>();
            l.addAll(this._criticities);
            this._project.setCriticityCriterium(l);
            this._criticities.clear();
        } else if ("PROJECT".equals(name)) {
            DBObject object = new DBObject(this._projectFolder.getID());
            object.setFolder(this._projectFolder);
            this._projectFolder.setObject(object);
            DBObjModel dbObjModel = this._project.writeDBObjModel(false);
            object.addModel(new DBObjModelBytes(dbObjModel));
            this.getCeciFactory().createObjectDAO().putWrap(object, this._project);
            return true;
        }
        return false;
    }

    public static AverageAttributeCriterion.ProbabilityChoice getProbabilityChoice(String s) {
        if ("DEF".equals(s)) {
            return AverageAttributeCriterion.ProbabilityChoice.DEF;
        }
        if ("MAX".equals(s)) {
            return AverageAttributeCriterion.ProbabilityChoice.MAX;
        }
        if ("AVG".equals(s)) {
            return AverageAttributeCriterion.ProbabilityChoice.AVG;
        }
        return null;
    }

    public static TypeProbability getTypeProbability(String s) {
        if (s.equals("MCS")) {
            return TypeProbability.MCS;
        }
        if (s.equals("NONE")) {
            return TypeProbability.NONE;
        }
        if (s.equals("BDD")) {
            return TypeProbability.BDD;
        }
        if (s.equals("ARP")) {
            return TypeProbability.ARP1;
        }
        if (s.equals("ARP2")) {
            return TypeProbability.ARP2;
        }
        if (s.equals("ARP3")) {
            return TypeProbability.ARP3;
        }
        return null;
    }

    public static AttrCriterion.Operator getOperator(String s) {
        if ("EQ".equals(s)) {
            return AttrCriterion.Operator.EQ;
        }
        if ("NEQ".equals(s)) {
            return AttrCriterion.Operator.NEQ;
        }
        if ("LEQ".equals(s)) {
            return AttrCriterion.Operator.LEQ;
        }
        if ("LT".equals(s)) {
            return AttrCriterion.Operator.LT;
        }
        if ("GEQ".equals(s)) {
            return AttrCriterion.Operator.GEQ;
        }
        if ("GT".equals(s)) {
            return AttrCriterion.Operator.GT;
        }
        if ("MATCH".equals(s)) {
            return AttrCriterion.Operator.MATCH;
        }
        return null;
    }
}

