/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.ftp10.FtpAbsTableReader;
import com.dassault.cecilia.io.ftp10.FtpHandler;
import com.dassault.cecilia.io.ftp10.ResMsgFtp;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Row;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class FtpEventTableReader
extends FtpAbsTableReader {
    private final Map<String, FTVariable> _mapNameToEvents = new LinkedHashMap<String, FTVariable>();
    private final Map<FTVariable, DBLogs> _mapVarToLogs = new LinkedHashMap<FTVariable, DBLogs>();

    public FtpEventTableReader(FtpHandler handler, Database base) throws IOException {
        super(handler, base);
    }

    @Override
    protected void readLine(Row row) {
        DBModelLaw modelLaw;
        String ccfModelName;
        String name = row.getString("Name");
        if (name == null) {
            return;
        }
        String desc = this.getValidDesc(row.getString("Description"), name);
        FTVariable var = new FTVariable();
        FTEvent event = new FTEvent();
        event.setVariable(var);
        var.setEvent(event);
        var.setName(name).setLabel(desc == null ? "" : desc);
        String symbolType = row.getString("Symbol Type");
        event.setStyle(this.getSymbolType(event, symbolType));
        if (symbolType.equals("House")) {
            event.setState(FTEvent.State.TRUE);
        }
        if ((ccfModelName = row.getString("CCF Model Name")) != null && !ccfModelName.isEmpty()) {
            event.setCCF(this.getCCF(ccfModelName));
        }
        if ((modelLaw = this.getModelLaw(row)) != null) {
            event.setModelLaw(modelLaw);
        } else {
            Law law = this.createLaw(name, row);
            event.setOccurrence(law);
        }
        this._mapNameToEvents.put(name, var);
        this._mapVarToLogs.put(var, this.getLogs().getCopy());
    }

    @Override
    public String getIDTable() {
        return "Events";
    }

    public final Map<String, FTVariable> getMapNameToFTVar() {
        return this._mapNameToEvents;
    }

    public final Map<FTVariable, DBLogs> getMapVarToLogs() {
        return this._mapVarToLogs;
    }

    private FTEvent.Style getSymbolType(FTEvent event, String symbolType) {
        switch (symbolType) {
            case "Undeveloped": {
                return FTEvent.Style.UNDEVELOPED;
            }
            case "Conditional": {
                return FTEvent.Style.CONDITIONNING;
            }
            case "Dormant": 
            case "House": 
            case "Basic": {
                return FTEvent.Style.BASIC;
            }
        }
        this.displayMessage(Level.WARNING, "Symbol Type unknown : '" + symbolType + "'");
        return FTEvent.Style.BASIC;
    }

    private CCF getCCF(String ccfName) {
        DBFolder ccfRootFolder = this.getFactory().createFolderDAO().getRootID("CCF_MODELS");
        DBFolder tmp = null;
        tmp = ccfRootFolder.findChild(ccfName);
        DBFolder dBFolder = tmp = tmp != null ? tmp.findChild("1") : null;
        if (tmp == null) {
            String warnMess = ResMsgFtp.msgFormat("FTP_WARN_NO_FOLDER_FOUND", ccfName);
            this.addLog(DBLogs.DBLevel.WARNING, warnMess);
            this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
            return null;
        }
        IWrap wrap = this.getFactory().createObjectDAO().getWrap(tmp.getObject());
        if (wrap == null) {
            String warnMess = ResMsgFtp.msgFormat("FTP_WARN_NO_ATTACHED_OBJECT", ccfName);
            this.addLog(DBLogs.DBLevel.WARNING, warnMess);
            this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
            return null;
        }
        assert (wrap != null && wrap instanceof CCF);
        return (CCF)wrap;
    }
}

