/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10.util;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;

class TraceJackessDirectory {
    TraceJackessDirectory() {
    }

    private static void traceJackcess(File file) throws Exception {
        Database base = DatabaseBuilder.open((File)file);
        System.out.println("File: " + file.getAbsolutePath());
        Table table = base.getSystemTable("MSysObjects");
        List columns = table.getColumns();
        Row row = table.getNextRow();
        while (row != null) {
            Object name = row.get((Object)"Name");
            if ("Common Cause Failures".equals(name) || "Events".equals(name) || "Gates".equals(name) || "Generic Models".equals(name)) {
                System.out.print("{");
                for (Integer i : Arrays.asList(2, 4, 5)) {
                    Object obj;
                    if (i > 2) {
                        System.out.print(";");
                    }
                    if ((obj = row.get((Object)((Column)columns.get(i)).getName())) == null) continue;
                    Object field = obj.toString();
                    if (((String)field).length() > 40) {
                        field = ((String)field).substring(0, 36) + "...";
                    }
                    System.out.print((String)field);
                }
                System.out.println("}");
            }
            row = table.getNextRow();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1) {
                TraceJackessDirectory.traceJackcess(new File(args[0]));
            } else {
                JFileChooser dlg = new JFileChooser();
                dlg.setCurrentDirectory(new File("."));
                dlg.setFileSelectionMode(1);
                if (dlg.showOpenDialog(null) == 1) {
                    return;
                }
                File file = dlg.getSelectedFile();
                if (file == null) {
                    return;
                }
                if (file.isDirectory()) {
                    for (File child : file.listFiles()) {
                        if (!child.getAbsolutePath().toLowerCase().endsWith(".mdb")) continue;
                        TraceJackessDirectory.traceJackcess(child);
                    }
                } else {
                    TraceJackessDirectory.traceJackcess(file);
                }
            }
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
    }
}

