/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.io.imports.AbstractCmdImportPrepare;
import com.dassault.cecilia.io.imports.ParserTypeProject;
import com.dassault.cecilia.io.imports.gui.DlgChooseRootImport;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class CmdImportPrepareARBOR51
extends AbstractCmdImportPrepare {
    private static Logger _LOG = Logger.getLogger(CmdImportPrepareARBOR51.class.getPackage().getName());
    private DBFolder _root;

    public CmdImportPrepareARBOR51(CeciliaAppl appl, JFrame owner) {
        super(appl, owner);
    }

    @Override
    protected String getTitle() {
        return ResMsgCecilia.getString("MENU_IMPORT_ARBOR51");
    }

    @Override
    protected boolean prepareDo() {
        boolean superValue = super.prepareDo();
        if (!superValue) {
            return false;
        }
        DBFolder rootProjects = this.getAppl().getDAOFactory().createFolderDAO().getRootID("PROJECTS");
        File fileXML = this._importFiles[0];
        assert (fileXML != null);
        ParserTypeProject minimalisticParser = new ParserTypeProject();
        try {
            this.readXml(fileXML, minimalisticParser);
        }
        catch (IOException err) {
            _LOG.log(Level.FINER, "Error while the parsing of the XML file", err);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlOwner), err.getMessage());
            return false;
        }
        ParserTypeProject.TypeOfImport type = minimalisticParser.getType();
        if (type == ParserTypeProject.TypeOfImport.PROJECT) {
            return true;
        }
        long cpt = 1L;
        if (rootProjects.getChildren().size() > 0) {
            boolean canAddATree = false;
            if (type == ParserTypeProject.TypeOfImport.TREE) {
                for (DBFolder child : rootProjects.getChildren()) {
                    if (child.getChildren() == null) {
                        this.getAppl().getDAOFactory().createFolderDAO().findChildren(child);
                    }
                    if (child.getChildren() == null || child.getChildren().size() == 0) continue;
                    canAddATree = true;
                    break;
                }
            }
            if (type == ParserTypeProject.TypeOfImport.SYSTEM || canAddATree) {
                DlgChooseRootImport dlg = new DlgChooseRootImport(this.getAppl(), type);
                dlg.openWindow(this.getAppl().getTopWindow());
                if (!dlg.getResult()) {
                    return false;
                }
                DBFolder root = new DBFolder(dlg.getSelectedDBFolder());
                DBFolder folderParent = new DBFolder(root.getParent());
                root.setChildren(null).setParent(null).setUserFlag((short)1);
                if (folderParent != null && !folderParent.getName().equals("PROJECTS")) {
                    folderParent.setChildren(null).setParent(null).setUserFlag((short)1);
                    SA51Utils.linkDBFolder(folderParent, root);
                }
                this._root = root;
                return this._root != null;
            }
        }
        DBFolder projectImport = new DBFolder(cpt++).setName("ImportProject");
        if (type == ParserTypeProject.TypeOfImport.SYSTEM) {
            this._root = projectImport;
        } else {
            DBFolder systemImport = new DBFolder(cpt++).setParent(projectImport).setName("ImportSystem");
            SA51Utils.linkDBFolder(projectImport, systemImport);
            this._root = systemImport;
        }
        return true;
    }

    @Override
    protected DAOFactory readFile(File file) {
        SA51Handler sa51Handler = new SA51Handler(file, this.getAppl().getDBUser().getLogin());
        if (this._root != null) {
            sa51Handler.setRoot(this._root);
        }
        try {
            this.readXml(file, sa51Handler);
        }
        catch (IOException e) {
            _LOG.log(Level.FINER, "Error while the parsing of the XML file", e);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlOwner), e.getMessage());
            return null;
        }
        return sa51Handler.getCECFactory();
    }

    private void readXml(File file, SAXExtendedHandler sa51Handler) throws IOException {
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse((InputStream)new FileInputStream(file), (DefaultHandler)sa51Handler);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC")).append("\n");
            Locator loc = sa51Handler.getLocator();
            if (loc != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
    }
}

