/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.cecilia.dbgui.DAOTools;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsSimpleDlg;
import com.dassault.cecilia.io.imports.AbstractCmdImportPrepare;
import com.dassault.cecilia.io.imports.DAOToolsWithDependencies;
import com.dassault.cecilia.io.imports.MapImport;
import com.dassault.cecilia.io.imports.gui.DlgImportTree;
import com.dassault.cecilia.io.xml6.ImportUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CmdImportPrepareXML6
extends AbstractCmdImportPrepare {
    private static Logger _LOG = Logger.getLogger(CmdImportPrepareXML6.class.getPackage().getName());

    public CmdImportPrepareXML6(CeciliaAppl appl, JFrame owner) {
        super(appl, owner);
    }

    @Override
    protected String getTitle() {
        return ResMsgCecilia.getString("MENU_IMPORT_XML6");
    }

    @Override
    protected DAOFactory readFile(File file) {
        DAOImportXmlFactory daoFactory = new DAOImportXmlFactory();
        ImportUtility importUtility = new ImportUtility(daoFactory);
        try {
            importUtility.readXml(new FileInputStream(file), false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlOwner), e.getMessage());
            _LOG.log(Level.FINER, "Exception lors de la lecture du fichier d'import XML", e);
            return null;
        }
        List<DBLogs.Log> logs = importUtility.getLogs().getLogs(DBLogs.DBLevel.WARNING);
        if (!logs.isEmpty()) {
            DBLogsSimpleDlg dlg = new DBLogsSimpleDlg((Window)this.getAppl().getTopWindow());
            dlg.setDBLogs(importUtility.getLogs());
            dlg.setVisible(true);
            return null;
        }
        return daoFactory;
    }

    @Override
    protected DAOTools createDAOTools(DAOFactory daoFactory) {
        return new DAOToolsWithDependencies(daoFactory);
    }

    @Override
    protected JDialogCecilia createDlgImport(Window owner, MapImport mapImport) {
        DlbImportTreeWithPrefs dlg = new DlbImportTreeWithPrefs((Window)this._ctrlOwner, mapImport);
        if (!mapImport.withImportPrefs()) {
            dlg._chkBoxPrefs.setSelected(false);
            dlg._chkBoxPrefs.setEnabled(false);
        }
        return dlg;
    }

    static class DlbImportTreeWithPrefs
    extends DlgImportTree {
        JCheckBox _chkBoxPrefs;

        public DlbImportTreeWithPrefs(Window owner, MapImport mapImport) {
            super(owner, mapImport);
        }

        @Override
        protected Component createFooter() {
            this._chkBoxPrefs = new JCheckBox(ResMsgObj.getString("LBL_IMPORT_LOCAL_PREFERENCES"));
            this._chkBoxPrefs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _mapImport.setChoiceImportPrefs(_chkBoxPrefs.isSelected());
                }
            });
            this._chkBoxPrefs.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
            return this._chkBoxPrefs;
        }
    }
}

