/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.DAOTools;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.io.imports.UtilityConvertID;
import java.util.LinkedHashMap;

public class DAOToolsWithDependencies
extends DAOTools {
    public DAOToolsWithDependencies(DAOFactory daoFactory) {
        super(daoFactory);
    }

    @Override
    protected boolean verifyFolder(DBFolder dbFolder) {
        if (dbFolder.isSystem()) {
            return true;
        }
        if (!super.verifyFolder(dbFolder)) {
            return false;
        }
        DBObject importObj = dbFolder.getObject();
        if (importObj != null) {
            boolean result = true;
            for (DBObjModel importObjMod : importObj.getModels()) {
                String dbFormat = importObjMod.getFormat();
                if (!dbFormat.equals("XML") && !dbFormat.equals("ZML")) continue;
                LinkedHashMap<Long, String> relations = new LinkedHashMap<Long, String>();
                if (!UtilityConvertID.findRefIDs(this.getDAOFactory().createObjModelDAO(), importObjMod, relations)) {
                    this.appendWarning(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_OBJ_MODEL_READ", importObjMod.getNature()));
                    continue;
                }
                if (relations.isEmpty()) continue;
                DAOFolder daoFolder = this.getDAOFactory().createFolderDAO();
                for (Long refID : relations.keySet()) {
                    DBFolder dbRefFolder = (DBFolder)daoFolder.find(refID);
                    if (dbRefFolder != null) continue;
                    String line = (String)relations.get(refID);
                    if (line.contains("<ft.cfg.dsf ")) {
                        this.appendWarning(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_DEPENDENTY", refID));
                        continue;
                    }
                    result &= this.appendError(dbFolder, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_DEPENDENTY", refID));
                }
            }
            return result;
        }
        return true;
    }
}

