/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.io.imports.ParserTypeProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;

public class DlgChooseRootImport
extends JDialogCecilia {
    DBFolderPanelSelectRoot _panelSelectFolder;
    ParserTypeProject.TypeOfImport _typeOfSelection;

    public DlgChooseRootImport(CAppl appl, ParserTypeProject.TypeOfImport typeOfSelection) {
        super(appl.getTopWindow(), true);
        this._typeOfSelection = typeOfSelection;
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel infoLabel = new JLabel(ResMsgObj.msgFormat("MSG_IMPORT_DLG_SA51_LABEL_CHOOSE", this.getTextFromType(typeOfSelection)));
        this._panelSelectFolder = new DBFolderPanelSelectRoot(appl, DBFolder.Family.PROJECT);
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)infoLabel, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        panel.add((Component)this._panelSelectFolder, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.createButPanel(false), "South");
    }

    public void openWindow(Component c) {
        this.init();
        this.pack();
        this.setLocationRelativeTo(c);
        this.setVisible(true);
    }

    @Override
    protected boolean verifyParameters() {
        DBFolder selectedFolder = this._panelSelectFolder.getSelectFolder(false);
        if (selectedFolder == null) {
            JOptionPane.showMessageDialog(this._panelSelectFolder, ResMsgObj.getString("MSG_IMPORT_DLG_SA51_BAD_SELECTION"), ResMsgObj.getString("MSG_IMPORT_DLG_SA51_BAD_TITLE"), 0);
            return false;
        }
        if (!this.isGoodTypeOfFolder(selectedFolder)) {
            JOptionPane.showMessageDialog(this._panelSelectFolder, ResMsgObj.msgFormat("MSG_IMPORT_DLG_SA51_BAD_CHOOSE", ResMsgVoc.getString("VOC_SYSTEM")), ResMsgObj.getString("MSG_IMPORT_DLG_SA51_BAD_TITLE"), 0);
        }
        return this.isGoodTypeOfFolder(selectedFolder);
    }

    public DBFolder getSelectedDBFolder() {
        return this._panelSelectFolder.getSelectFolder(false);
    }

    public void setSelectedDBFolder(DBFolder dbFolder) {
        this._panelSelectFolder.setSelectFolder(dbFolder);
    }

    public boolean isGoodTypeOfFolder(DBFolder folder) {
        switch (this._typeOfSelection) {
            case TREE: {
                return folder.getParent() != null && folder.getParent().getParent() != null && folder.getParent().getParent().getName().equals("PROJECTS");
            }
            case SYSTEM: {
                return folder.getParent() != null && folder.getParent().getName().equals("PROJECTS");
            }
        }
        assert (false);
        return false;
    }

    private final String getTextFromType(ParserTypeProject.TypeOfImport type) {
        switch (type) {
            case SYSTEM: {
                return ResMsgVoc.getString("VOC_PROJECT");
            }
            case TREE: {
                return ResMsgVoc.getString("VOC_SYSTEM");
            }
        }
        assert (false);
        return null;
    }

    @Override
    public String getTitle() {
        return ResMsgObj.getString("MSG_IMPORT_DLG_SA51_TITLE");
    }

    public class DBFolderPanelSelectRoot
    extends DBFolderPanelSelect
    implements MouseListener {
        protected DBFolderPanelSelectRoot(PlugableAppl appl, DBFolder.Family dbFamily) {
            super(appl, dbFamily);
            this.getCtrlTree().addMouseListener(this);
        }

        @Override
        public boolean selectFolder(DBFolder dbFolder) {
            boolean result = false;
            switch (DlgChooseRootImport.this._typeOfSelection) {
                case TREE: {
                    result |= dbFolder.getParent() != null && dbFolder.getParent().getParent() != null && dbFolder.getParent().getParent().getName().equals("PROJECTS");
                }
                case SYSTEM: {
                    result |= dbFolder.getParent() != null && dbFolder.getParent().getName().equals("PROJECTS");
                }
            }
            return result;
        }

        @Override
        public DBFolder getSelectFolder(boolean expand) {
            TreePath path = this.getCtrlTree().getSelectionPath();
            if (path == null) {
                return null;
            }
            DBFolderTreeNode selectNode = (DBFolderTreeNode)path.getLastPathComponent();
            if (selectNode == null) {
                return null;
            }
            return selectNode.getDBFolder();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (((DBFolderTree)e.getSource()).getSelectionPath() == null) {
                return;
            }
            DBFolder selectedFolder = ((DBFolderTreeNode)((DBFolderTree)e.getSource()).getSelectionPath().getLastPathComponent()).getDBFolder();
            if (DlgChooseRootImport.this.isGoodTypeOfFolder(selectedFolder)) {
                DlgChooseRootImport.this.validDialog();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

