/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.DBIconRenderer;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.ocas51.AbstractOcas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Linker;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51ComponentHandler
extends AbstractOcas51Handler {
    private final DAOFolder _folderDAO;
    protected DBFolder _familyFolder;
    protected DBFolder _subFamilyFolder;
    protected boolean _isInSubFamilyFolder;
    protected boolean _isInObject;
    private List<DBAttrib.Value> _listAttributes;
    AltaComponent _currentComponent;

    public OCas51ComponentHandler(OCas51Handler handler, CECFactory factory) {
        super(handler, factory);
        this._folderDAO = factory.createFolderDAO();
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        switch (name) {
            case "COMPONENT_SUB_FAMILY": {
                this._isInSubFamilyFolder = true;
                break;
            }
            case "COMPONENT_MODEL": {
                this._isInObject = true;
                this.initializeObject();
                this.createGraphicalAttributes(attrs);
                break;
            }
            case "IO": {
                this.readIO(attrs);
                break;
            }
            case "STATE": {
                if (!this.isInInstanciationMode()) {
                    return;
                }
                this.readState(attrs);
                break;
            }
            case "EVENT": {
                if (!this.isInInstanciationMode()) {
                    return;
                }
                this.readEvent(attrs);
                break;
            }
            case "ICON": {
                if (!this.isInInstanciationMode()) {
                    return;
                }
                this.readIcon(attrs);
                break;
            }
            case "SYNCHRO": {
                break;
            }
            case "ATTRIBUTE": {
                if (!this.isInInstanciationMode()) {
                    return;
                }
                this.readAttribute(attrs);
                break;
            }
            case "IDENTIFICATION": {
                this.readIdentification(name, attrs);
                break;
            }
            case "OPERATOR_ID": {
                if (!this.isInInstanciationMode()) {
                    return;
                }
                this.readOperator(attrs);
            }
        }
    }

    protected void readIO(Map<String, String> attrs) throws SAXException {
        String nameFlow = this.getStrFromAttributes(attrs, "NAME", true);
        String typeStr = this.getStrFromAttributes(attrs, "TYPE", true);
        AltaType type = this.getTypeFromStr(typeStr, this.getCECFactory(), !this._isInSubFamilyFolder);
        if (type == null) {
            if (this.isInInstanciationMode()) {
                String warnMess = ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_TYPE_REPLACED", typeStr, this.getHandler().getLocator().getLineNumber());
                this.displayLogs(warnMess);
                this.addWarningToLogs(warnMess);
            }
            type = AltaTypeBool.getInstance();
        }
        AltaFlow flow = new AltaFlow(nameFlow, type);
        AltaFlow.Orientation ori = this.getDirectionFromStrVal(this.getStrFromAttributes(attrs, "DIRECTION", true));
        flow.setOrientation(ori);
        flow.setX(this.getIntValFromAttributes(attrs, "X", true));
        flow.setY(this.getIntValFromAttributes(attrs, "Y", true));
        flow.setID(this.getCurrentComponent().getNextFlowID());
        this.getCurrentComponent().getFlows().add(flow);
    }

    protected void readState(Map<String, String> attrs) throws SAXException {
        String nameState = this.getStrFromAttributes(attrs, "NAME", true);
        String typeStr = this.getStrFromAttributes(attrs, "TYPE", true);
        AltaType type = this.getTypeFromStr(typeStr, this.getCECFactory(), !this._isInSubFamilyFolder);
        if (type == null) {
            String warnMess = ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_TYPE_REPLACED", typeStr, this.getHandler().getLocator().getLineNumber());
            if (this.isInInstanciationMode()) {
                this.displayLogs(warnMess);
                this.addWarningToLogs(warnMess);
            }
            type = AltaTypeBool.getInstance();
        }
        String value = this.getStrFromAttributes(attrs, "DEFAULT", true);
        AltaState state = new AltaState(nameState, type, value);
        this.getCurrentComponent().getStates().add(state);
    }

    protected void readEvent(Map<String, String> attrs) throws SAXException {
        String nameEvent = this.getStrFromAttributes(attrs, "NAME", true);
        String comment = this.getStrFromAttributes(attrs, "COMMENT", true);
        String lawStr = this.getStrFromAttributes(attrs, "LAW", true);
        String isInspected = this.getStrFromAttributes(attrs, "INSPECTED", false);
        String isInFlightTest = this.getStrFromAttributes(attrs, "INFLIGHTTESTED", false);
        AltaEvent event = new AltaEvent(nameEvent);
        event.setLabel(comment);
        if (lawStr != null && !lawStr.isEmpty()) {
            Law law = this.getlawFromStrValue(this.getCECFactory(), lawStr);
            if (law == null && lawStr.contains("/")) {
                lawStr = OCas51Utils.revisePathFromBTP(lawStr);
                DBModelLaw modelLaw = OCas51Utils.getModelLawFromStrValue(this.getCECFactory(), lawStr);
                if (modelLaw == null) {
                    DBFolder rootBtpFolder = this.getCECFactory().createFolderDAO().getRootID("LAW_MODELS");
                    DBFolder folder = this.createFolderFromPath(DBFolder.Family.BTP_MODEL, rootBtpFolder, lawStr);
                    modelLaw = this.getDefaultModelLaw(folder);
                    this.displayLogs(ResMsgOcas51.msgFormat("MSG_WARNING_BTP_CREATED", lawStr));
                }
                event.setModelLaw(modelLaw);
            } else {
                if (law == null) {
                    String warnMess = ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_LAW", lawStr);
                    if (this.isInInstanciationMode()) {
                        this.displayLogs(warnMess);
                        this.addWarningToLogs(warnMess);
                    }
                    law = this.getCECFactory().getLawManager().createLaw(-1);
                }
                event.setOccurrence(law);
            }
        }
        event.setInspected(this.getParamFromStrValue(this.getCECFactory(), isInspected));
        event.setInflightTested(this.getParamFromStrValue(this.getCECFactory(), isInFlightTest));
        this._listAttributes = new ArrayList<DBAttrib.Value>();
        this.getCurrentComponent().getEvents().add(event);
    }

    protected void readIcon(Map<String, String> attrs) throws SAXException {
        DBFolder rootIconFolder = this.getCECFactory().createFolderDAO().getRootID("IMAGE_FAMILIES");
        String nameIcon = this.getStrFromAttributes(attrs, "NAME", true);
        String[] paths = nameIcon.split("/");
        DBFolder tmpFolder = rootIconFolder;
        for (String path : paths) {
            tmpFolder = tmpFolder.findChild(DBFactory.convertName(path, DBFolder.Family.IMAG));
            assert (tmpFolder != null) : "Grave error : Les icones sont instanci\u00e9s AVANT l'ouverture du XML, il n'y a pas de raison de ne pas les trouver";
        }
        tmpFolder = tmpFolder.findChild("1");
        DBObject obj = tmpFolder.getObject();
        assert (obj != null);
        DBIcon icon = (DBIcon)this.getCECFactory().createObjectDAO().getWrap(obj);
        this.getCurrentComponent().getSimuls().add(new DBIconRenderer(icon));
    }

    protected void readAttribute(Map<String, String> attrs) throws SAXException {
        DBAttrib dbAttrib;
        String nameAttribute = this.getStrFromAttributes(attrs, "NAME", true);
        String value = null;
        String path = nameAttribute;
        int pos = path.indexOf("=");
        if (pos != -1) {
            path = nameAttribute.substring(0, pos);
            if (pos != nameAttribute.length()) {
                value = nameAttribute.substring(pos + 1);
            }
        }
        if ((dbAttrib = this.getAttributeFromPath(this.getCECFactory(), path)) != null) {
            DBAttrib.Value valueAttr = dbAttrib.createInstance(value);
            if (valueAttr == null) {
                String warnMess = ResMsgOcas51.msgFormat("MSG_WARNING_WRONG_VALUE_ATTRIBUTE", dbAttrib.getName(), value);
                this.addWarningToLogs(warnMess);
                this.displayLogs(warnMess);
            } else {
                this._listAttributes.add(valueAttr);
            }
        } else if (this.isInInstanciationMode()) {
            String warnMess = ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_ATTRIBUTE", nameAttribute);
            this.addWarningToLogs(warnMess);
            this.displayLogs(warnMess);
        }
    }

    protected void readIdentification(String name, Map<String, String> attrs) throws SAXException {
        String nameComp = this.getValidName(this.getStrFromAttributes(attrs, "NAME", true), this.getFamily(), name, "NAME");
        String vers = this.checkValidVers(this.getStrFromAttributes(attrs, "VERSION", false), name, "VERSION");
        String comment = this.getValidDesc(this.getStrFromAttributes(attrs, "COMMENT", false), true);
        String idExternLaeticia = this.getStrFromAttributes(attrs, "IDEXTERN_LAETITIA", false);
        Boolean isFrozen = this.getBooleanFromAttributes(attrs, "FREEZE", true);
        String ownerStr = this.getStrFromAttributes(attrs, "OWNER", true);
        String releaseStr = this.getStrFromAttributes(attrs, "RELEASE", false);
        if (this._isInObject) {
            assert (this._familyFolder != null);
            if (!this._isInSubFamilyFolder) {
                assert (this._subFamilyFolder == null || this._subFamilyFolder.getName().equals(this._familyFolder.getName()));
                this._subFamilyFolder = this._familyFolder.findChild(this._familyFolder.getName());
                if (this._subFamilyFolder == null) {
                    this._subFamilyFolder = this.createNewFolder(this._familyFolder.getName(), DBFolder.createFlagsFolder(this.getFamily(), (short)0, (short)0), true, this.getValidDesc(comment, false), this._familyFolder);
                }
            }
            Date creationDate = this.getDateFromAttributes(attrs, "CREATION_DATE", true);
            Date modifyDate = this.getDateFromAttributes(attrs, "UPDATE_DATE", true);
            comment = this.getValidDesc(comment, true);
            DBFolder componentModelFolder = this._subFamilyFolder.findChild(nameComp);
            if (componentModelFolder == null) {
                componentModelFolder = this.createNewFolder(nameComp, DBFolder.createFlagsModel(this.getFamily(), this.getSubFamily(), (short)0), true, this._subFamilyFolder);
            }
            assert (componentModelFolder != null);
            DBFolder componentVersFolder = componentModelFolder.findChild(vers);
            if (componentVersFolder == null) {
                componentVersFolder = this.createNewFolder(vers, DBFolder.createFlagsVersion(this.getFamily(), this.getSubFamily(), (short)0), creationDate != null ? creationDate : this.getLastUpdateDate(), modifyDate != null ? modifyDate : this.getLastUpdateDate(), comment, componentModelFolder);
                if (this.getCurrentComponent().getCode() != null && !this.getCurrentComponent().getCode().isEmpty()) {
                    OCas51Linker.linkOperator(this.getCECFactory(), this.getCurrentComponent());
                }
                this.addObjectFromFolder(componentVersFolder, this.getCurrentComponent(), releaseStr, ownerStr, idExternLaeticia, isFrozen);
            } else {
                this.addContentToObject(componentVersFolder);
                this.updateModel(componentVersFolder);
            }
        } else if (this._isInSubFamilyFolder) {
            this._subFamilyFolder = this._familyFolder.findChild(nameComp);
            if (this._subFamilyFolder == null) {
                this._subFamilyFolder = this.createNewFolder(nameComp, DBFolder.createFlagsFolder(this.getFamily(), (short)0, (short)0), true, this.getValidDesc(comment, false), this._familyFolder);
            }
        } else {
            DBFolder root = this._folderDAO.getRootID(this.getFamily().getRootName());
            this._familyFolder = root.findChild(nameComp);
            if (this._familyFolder == null) {
                this._familyFolder = this.createRootFolder(nameComp, comment, releaseStr, ownerStr, idExternLaeticia, isFrozen);
            }
        }
    }

    protected void readOperator(Map<String, String> attrs) throws SAXException {
        AltaOperator operator;
        String operatorName = this.getStrFromAttributes(attrs, "NAME", true);
        String familyName = this.getStrFromAttributes(attrs, "FAMILY", true);
        String subFamilyName = this.getStrFromAttributes(attrs, "SUB_FAMILY", this._isInSubFamilyFolder);
        String versName = this.getStrFromAttributes(attrs, "VERSION", true);
        if (subFamilyName == null) {
            subFamilyName = familyName;
        }
        if ((operator = (AltaOperator)OCas51Utils.getWrapFromStrFolder(this.getCECFactory(), "OPERATOR_FAMILIES", this.getHandler().getLocator(), familyName, subFamilyName, operatorName, versName)) == null) {
            String messWarn = ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_OPERATOR", OCas51Utils.createPath(familyName, subFamilyName, operatorName, versName), this.getHandler().getLocator().getLineNumber());
            this.addWarningToLogs(messWarn);
            this.displayLogs(messWarn);
        } else {
            AltaOperatorRef ref = new AltaOperatorRef(operatorName, operator.getDBFolder());
            this.getCurrentComponent().getUsedOperator().add(ref);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        switch (name) {
            case "COMPONENT_FAMILY": {
                return true;
            }
            case "COMPONENT_SUB_FAMILY": {
                this._isInSubFamilyFolder = false;
                break;
            }
            case "EVENT": {
                if (!this.isInInstanciationMode() || this._listAttributes.isEmpty()) break;
                AltaEvent event = this.getCurrentComponent().getEvents().get(this.getCurrentComponent().getEvents().size() - 1);
                event.setAttributes(this._listAttributes);
                break;
            }
            case "COMPONENT_MODEL": {
                this.destroyObject();
                this._isInObject = false;
            }
        }
        return false;
    }

    protected final AltaComponent getCurrentComponent() {
        return this._currentComponent;
    }

    protected void initializeObject() {
        this._currentComponent = new AltaComponent(null);
    }

    protected void destroyObject() {
        this._currentComponent = null;
    }

    protected void createGraphicalAttributes(Map<String, String> attrs) throws SAXException {
        String law;
        String iconName;
        Boolean bool = this.getBooleanFromAttributes(attrs, "BORDER", true);
        assert (bool != null);
        if (bool != null) {
            this.getCurrentComponent().getIconRenderer().setColorDraw(bool != false ? Color.black : null);
        }
        int height = this.getIntValFromAttributes(attrs, "HEIGHT", true) - 6;
        int width = this.getIntValFromAttributes(attrs, "WIDTH", true) - 6;
        this.getCurrentComponent().setHeight(height > 0 ? height : 1);
        this.getCurrentComponent().setWidth(width > 0 ? width : 1);
        bool = this.getBooleanFromAttributes(attrs, "AUTOMOVEPORT", this._isInSubFamilyFolder);
        assert (bool != null);
        if (bool != null) {
            this.getCurrentComponent().setAutoMovePort(bool);
        }
        if ((iconName = this.getStrFromAttributes(attrs, "ICON", true)) != null && !iconName.isEmpty()) {
            this.getCurrentComponent().getIconRenderer().setDBIcon(this.getIcon(iconName));
        }
        if ((law = this.getStrFromAttributes(attrs, "LAW", true)) != null && !law.isEmpty()) {
            this.getCurrentComponent().setCode(law);
        }
    }

    protected String getDBFolderName() {
        return "COMPONENT_FAMILIES";
    }

    protected DBFolder.Family getFamily() {
        return DBFolder.Family.COMPONENT;
    }

    protected String getNature() {
        return "component";
    }

    protected short getSubFamily() {
        return 0;
    }

    private final AltaFlow.Orientation getDirectionFromStrVal(String value) {
        switch (value) {
            case "in": {
                return AltaFlow.Orientation.IN;
            }
            case "out": {
                return AltaFlow.Orientation.OUT;
            }
            case "local": {
                return AltaFlow.Orientation.LOCAL;
            }
        }
        assert (false);
        return null;
    }

    protected DBFolder createRootFolder(String name, String comment, String releaseStr, String ownerStr, String idExternLaeticia, boolean isFrozen) {
        DBFolder folder = this.createNewFolder(name, DBFolder.createFlagsFolder(this.getFamily(), (short)0, (short)0), true, this.getValidDesc(comment, false), this.getCECFactory().createFolderDAO().getRootID(this.getDBFolderName()));
        return folder;
    }

    protected void addContentToObject(DBFolder componentVersFolder) {
        AltaComponent component = (AltaComponent)this.getCECFactory().createObjectDAO().getWrap(componentVersFolder.getObject());
        component.setFlows(this._currentComponent.getFlows());
        component.setStates(this._currentComponent.getStates());
    }

    protected void updateModel(DBFolder componentVersFolder) {
        DBObject obj = componentVersFolder.getObject();
        AltaComponent component = (AltaComponent)this.getCECFactory().createObjectDAO().getWrap(componentVersFolder.getObject());
        DBObjModel dbObjModel = component.writeDBObjModel(false);
        obj.delModel(obj.getModel(this.getNature()));
        obj.addModel(new DBObjModelBytes(dbObjModel));
        for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
            component.getLogs().addLog(log);
        }
        DBObjModel dbObjLogs = component.writeDBObjLogs(false);
        obj.delModel(obj.getModel("logs"));
        obj.addModel(new DBObjModelBytes(dbObjLogs));
        this.clearLogs();
    }
}

