/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.ocas51.OCas51ComponentHandler;
import com.dassault.cecilia.io.ocas51.OCas51ContentHandler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51EquipmentHandler
extends OCas51ComponentHandler {
    protected OCas51ContentHandler _currentHandler;

    public OCas51EquipmentHandler(OCas51Handler handler, CECFactory factory) {
        super(handler, factory);
    }

    @Override
    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._currentHandler != null) {
            this._currentHandler.startAction(name, attrs, startAction);
            return;
        }
        super.startAction(name, attrs, startAction);
        switch (name) {
            case "CONTENT": {
                if (this.isInInstanciationMode()) break;
                this._currentHandler = new OCas51ContentHandler(this.getHandler(), this.getCECFactory(), this);
                this._currentHandler.startAction(name, attrs, startAction);
                break;
            }
            case "SYNCHRO": {
                if (!this.isInInstanciationMode()) break;
                String nameSynchro = this.getStrFromAttributes(attrs, "NAME", true);
                String lawSynchro = this.getStrFromAttributes(attrs, "LAW", true);
                int idSynchro = this.getIntValFromAttributes(attrs, "TYPE", true);
                AltaSynchro synchro = new AltaSynchro(nameSynchro);
                if (lawSynchro != null) {
                    Law law = this.getlawFromStrValue(this.getCECFactory(), lawSynchro);
                    if (law == null && lawSynchro.contains("/")) {
                        lawSynchro = OCas51Utils.revisePathFromBTP(lawSynchro);
                        DBModelLaw modelLaw = OCas51Utils.getModelLawFromStrValue(this.getCECFactory(), lawSynchro);
                        if (modelLaw == null) {
                            DBFolder rootBtpFolder = this.getCECFactory().createFolderDAO().getRootID("LAW_MODELS");
                            DBFolder folder = this.createFolderFromPath(DBFolder.Family.BTP_MODEL, rootBtpFolder, lawSynchro);
                            modelLaw = this.getDefaultModelLaw(folder);
                            this.displayLogs(ResMsgOcas51.msgFormat("MSG_WARNING_BTP_CREATED", lawSynchro));
                        }
                        synchro.setModelLaw(modelLaw);
                    } else {
                        synchro.setOccurrence(law);
                    }
                }
                synchro.setType(OCas51Utils.getTypeSynchFromID(idSynchro));
                this.getCurrentEquipment().getSynchros().add(synchro);
                break;
            }
            case "TRANSITION": {
                if (!this.isInInstanciationMode()) break;
                String nameTransition = this.getStrFromAttributes(attrs, "NAME", true);
                this.getCurrentEquipment().getSynchros().get(this.getCurrentEquipment().getSynchros().size() - 1).addTransition(nameTransition);
                break;
            }
            case "SHEET": {
                if (this.isInInstanciationMode() && this.getFamily() != DBFolder.Family.PROJECT) {
                    return;
                }
                String sheetName = this.getStrFromAttributes(attrs, "NAME", true);
                int sheetNumber = this.getIntValFromAttributes(attrs, "NUMBER", true);
                boolean sheetSelected = this.getBooleanFromAttributes(attrs, "SELECTED", true);
                int sheetOrder = this.getIntValFromAttributes(attrs, "ORDER", true);
                boolean sheetVisible = this.getBooleanFromAttributes(attrs, "VISIBLE", true);
                AlgaSheet sheet = new AlgaSheet(sheetNumber, sheetName, sheetOrder, sheetSelected, sheetVisible);
                this.getCurrentEquipment().getContent().getSheets().add(sheet);
                if (!sheet.isSelected()) break;
                this.getCurrentEquipment().getContent().setCurrentSheet(sheet);
                break;
            }
            case "EQUIPMENT_SUB_FAMILY": {
                this._isInSubFamilyFolder = true;
                break;
            }
            case "EQUIPMENT_MODEL": {
                this._isInObject = true;
                this.initializeObject();
                this.createGraphicalAttributes(attrs);
                this.getCurrentEquipment().getContent().getSheets().clear();
            }
        }
    }

    @Override
    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._currentHandler != null && this._currentHandler.endAction(name, attrs, txt)) {
            this._currentHandler = null;
            return false;
        }
        super.endAction(name, attrs, txt);
        switch (name) {
            case "EQUIPMENT_FAMILY": {
                return true;
            }
            case "EQUIPMENT_SUB_FAMILY": {
                this._isInSubFamilyFolder = false;
                break;
            }
            case "EQUIPMENT_MODEL": {
                assert (this._isInObject);
                this.destroyObject();
                this._isInObject = false;
            }
        }
        return false;
    }

    @Override
    protected void addObjectFromFolder(DBFolder folder, DBWrap wrap, String releaseStr, String ownerStr, String idExternLaeticia, boolean isFrozen) {
        super.addObjectFromFolder(folder, wrap, releaseStr, ownerStr, idExternLaeticia, isFrozen);
    }

    public AltaEquipment getCurrentEquipment() {
        return (AltaEquipment)this.getCurrentComponent();
    }

    public final boolean isVersion4() {
        return !this._isInSubFamilyFolder;
    }

    @Override
    protected void initializeObject() {
        this._currentComponent = new AltaEquipment(null);
    }

    @Override
    protected String getDBFolderName() {
        return "EQUIPMENT_FAMILIES";
    }

    @Override
    protected DBFolder.Family getFamily() {
        return DBFolder.Family.EQUIPMENT;
    }

    @Override
    protected String getNature() {
        return "equipment";
    }

    @Override
    protected void addContentToObject(DBFolder componentVersFolder) {
        super.addContentToObject(componentVersFolder);
        AltaEquipment equipment = (AltaEquipment)this.getCECFactory().createObjectDAO().getWrap(componentVersFolder.getObject());
        for (AltaSub sub : this.getCurrentEquipment().getSubs()) {
            equipment.addSub(sub);
        }
        for (AltaLink link : this.getCurrentEquipment().getLinks()) {
            equipment.addLink(link);
        }
        List<AlgaSheet> sheets = this.getCurrentEquipment().getContent().getSheets();
        if (sheets == null || sheets.isEmpty()) {
            AlgaSheet sheet = new AlgaSheet(1, "DefaultCalque", 1, true, true);
            equipment.getContent().setSheets(Arrays.asList(sheet));
        } else {
            equipment.getContent().setSheets(sheets);
        }
        String code = this.getCurrentEquipment().getCode();
        if (code != null && !code.isEmpty()) {
            equipment.setCode(code);
        }
    }
}

