/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.io.ocas51.AbstractOcas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OCas51ParameterHandler
extends AbstractOcas51Handler {
    private DBFolder _parameterDefaultFolder;
    private TypeParam _type;
    private String _name;
    private String _vers;
    private Date _creationDate;
    private Date _modifyDate;
    private double _value;
    private String _comment;
    private String _ownerStr;
    private String _releaseStr;
    private String _idExternLaeticia;
    private boolean _isFrozen;
    private Law _law;
    private int _cptLaw;
    private static final Map<String, TypeParam> mapStrToType = new LinkedHashMap<String, TypeParam>();

    public OCas51ParameterHandler(OCas51Handler handler, CECFactory factory) {
        super(handler, factory);
        DBFolder dbParent = this.getCECFactory().createFolderDAO().getRootID("LAW_PARAMETERS");
        DBFolder dbDefault = dbParent.findChild("Default");
        if (dbDefault == null) {
            dbDefault = this.createNewFolder("Default", DBFolder.createFlagsFolder(DBFolder.Family.PARAMETER, (short)0, (short)0), true, dbParent);
        }
        this._parameterDefaultFolder = dbDefault;
        if (this._parameterDefaultFolder == null) {
            throw new NullPointerException();
        }
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        switch (name) {
            case "DEFINE_PARAMETER": {
                this._type = mapStrToType.get(this.getStrFromAttributes(attrs, "TYPE", true));
                break;
            }
            case "IDENTIFICATION": {
                String nameParam = this.getStrFromAttributes(attrs, "NAME", true);
                if (!nameParam.contains("/")) {
                    this.error(new SAXParseException(ResMsgOcas51.msgFormat("MSG_ERROR_FORMAT_ATTRPARAM", ResMsgOcas51.getString("MSG_PARAMETER"), nameParam), this.getHandler().getLocator()));
                }
                this._name = this.getValidName(nameParam.substring(0, nameParam.lastIndexOf(47)), DBFolder.Family.PARAMETER, name, "NAME");
                this._vers = this.checkValidVers(nameParam.substring(nameParam.lastIndexOf(47) + 1, nameParam.length()), name, "VERSION");
                this._creationDate = this.getDateFromAttributes(attrs, "CREATION_DATE", true);
                this._modifyDate = this.getDateFromAttributes(attrs, "UPDATE_DATE", true);
                this._comment = this.getValidDesc(this.getStrFromAttributes(attrs, "COMMENT", false), true);
                this._idExternLaeticia = this.getStrFromAttributes(attrs, "IDEXTERN_LAETITIA", false);
                this._isFrozen = this.getBooleanFromAttributes(attrs, "FREEZE", true);
                break;
            }
            case "PARAMETER_VALUE": {
                double value = this.getDoubleValFromAttributes(attrs, "VALUE", true);
                if (this._law != null) {
                    this._law.setParamAt(this._cptLaw++, new ParamValue(null, value));
                    break;
                }
                this._value = value;
                break;
            }
            case "PARAMETER_LAW": {
                String lawName = this.getStrFromAttributes(attrs, "NAME", true);
                int idLaw = lawName.equals("lognormal") ? 0 : (lawName.equals("uniform") ? 1 : -1);
                this._law = this.getCECFactory().getLawManager().getParameterManager().createLaw(idLaw);
                this._cptLaw = 0;
                break;
            }
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        switch (name) {
            case "DEFINE_PARAMETER": {
                DBFolder folderModelParam = this._parameterDefaultFolder.findChild(this._name);
                if (folderModelParam == null) {
                    folderModelParam = this.createNewFolder(this._name, DBFolder.createFlagsModel(DBFolder.Family.PARAMETER, (short)0, (short)0), true, this._parameterDefaultFolder);
                }
                assert (folderModelParam != null && folderModelParam.findChild(this._vers) == null);
                DBFolder folderVersParam = this.createNewFolder(this._vers, DBFolder.createFlagsVersion(DBFolder.Family.PARAMETER, (short)0, (short)0), this._creationDate != null ? this._creationDate : this.getLastUpdateDate(), this._modifyDate != null ? this._modifyDate : this.getLastUpdateDate(), this._comment, folderModelParam);
                DBParam param = new DBParam(folderVersParam);
                assert (this._type != null);
                param.setType(this._type);
                if (this._law == null) {
                    param.setValue(new ParamValue(this._type, this._value));
                } else {
                    param.setValue(new ParamLaw(this._type, this._law));
                }
                this.addObjectFromFolder(folderVersParam, param, this._releaseStr, this._ownerStr, this._idExternLaeticia, this._isFrozen);
                return true;
            }
        }
        return false;
    }

    static {
        mapStrToType.put("rate", TypeParam.RATE);
        mapStrToType.put("probability", TypeParam.PROBABILITY);
        mapStrToType.put("delay", TypeParam.DELAY);
        mapStrToType.put("factor", TypeParam.FACTOR);
        mapStrToType.put("boolean", TypeParam.BOOLEAN);
    }
}

