/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.io.ocas51.AbstractOcas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Linker;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import java.util.Date;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51TypeHandler
extends AbstractOcas51Handler {
    private String _releaseStr;
    private String _ownerStr;
    private String _idExternLaeticia;
    private boolean _isFrozen;
    private DBFolder _typeFamilyFolder;
    private DBFolder _typeSubFamilyFolder;
    private boolean _isInSubFamilyFolder;
    private boolean _isInType;
    private int _linkValue;
    private int _cptFields;
    private DBType _type;

    public OCas51TypeHandler(OCas51Handler handler, CECFactory factory) {
        super(handler, factory);
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        switch (name) {
            case "TYPE_SUB_FAMILY": {
                this._isInSubFamilyFolder = true;
                break;
            }
            case "TYPE": {
                this._isInType = true;
                this._linkValue = this.getIntValFromAttributes(attrs, "LINK", false);
                break;
            }
            case "FIELD": {
                String nameField = this.getStrFromAttributes(attrs, "NAME", true);
                if (this._linkValue == -1) {
                    ((DBEnum)this._type).addValue(nameField, this._cptFields);
                } else if (this._linkValue == 0 || this._linkValue == 1 || this._linkValue == 2) {
                    String typeField = this.getStrFromAttributes(attrs, "TYPE", false);
                    String directionStr = this.getStrFromAttributes(attrs, "DIRECTION", false);
                    String cross = this.getStrFromAttributes(attrs, "CROSS", false);
                    AltaType type = OCas51Utils.getTypeFromStr(typeField, this.getCECFactory().createFolderDAO().getRootID("TYPE_FAMILIES"), this.getCECFactory(), !this._isInSubFamilyFolder);
                    DBRecordField.Direction direction = this.getDirectionFromStr(directionStr);
                    if (type == null) {
                        OCas51Linker.IdentifiantType obj = new OCas51Linker.IdentifiantType(typeField, OCas51Linker.TypeObject.DBENUM, this._type);
                        obj.setIdxField(this._cptFields);
                        obj.setDirection(direction);
                        obj.setCrossedField(cross);
                        this.getHandler().getLinker().addNewLinkToDo(obj);
                        type = AltaTypeBool.getInstance();
                    }
                    DBRecordField field = new DBRecordField(nameField, type);
                    field.setDirection(direction);
                    if (this._linkValue == 2) {
                        field.setCrossField(cross);
                    }
                    field.setID(((DBRecord)this._type).getNextFieldID());
                    ((DBRecord)this._type).addField(field, this._cptFields);
                }
                ++this._cptFields;
                break;
            }
            case "IDENTIFICATION": {
                String nameFolder = this.getValidName(this.getStrFromAttributes(attrs, "NAME", true), DBFolder.Family.TYPE, name, "NAME");
                if (this._isInType) {
                    assert (this._typeFamilyFolder != null);
                    if (!this._isInSubFamilyFolder) {
                        assert (this._typeSubFamilyFolder == null || this._typeSubFamilyFolder.getName().equals(this._typeFamilyFolder.getName()));
                        this._typeSubFamilyFolder = this._typeFamilyFolder.findChild(this._typeFamilyFolder.getName());
                        if (this._typeSubFamilyFolder == null) {
                            this._typeSubFamilyFolder = this.createNewFolder(this._typeFamilyFolder.getName(), DBFolder.createFlagsFolder(DBFolder.Family.TYPE, (short)0, (short)0), true, this._typeFamilyFolder);
                        }
                    }
                    assert (this._typeSubFamilyFolder != null);
                    String versType = this.checkValidVers(this.getStrFromAttributes(attrs, "VERSION", false), name, "VERSION");
                    this._releaseStr = this.getStrFromAttributes(attrs, "RELEASE", false);
                    this._ownerStr = this.getStrFromAttributes(attrs, "OWNER", true);
                    this._idExternLaeticia = this.getStrFromAttributes(attrs, "IDEXTERN_LAETITIA", false);
                    this._isFrozen = this.getBooleanFromAttributes(attrs, "FREEZE", true);
                    String comment = this.getValidDesc(this.getStrFromAttributes(attrs, "COMMENT", false), true);
                    Date creationDateType = this.getDateFromAttributes(attrs, "CREATION_DATE", true);
                    Date updateDateType = this.getDateFromAttributes(attrs, "UPDATE_DATE", true);
                    DBFolder folderModelType = this._typeSubFamilyFolder.findChild(nameFolder);
                    if (folderModelType == null) {
                        folderModelType = this.createNewFolder(nameFolder, DBFolder.createFlagsModel(DBFolder.Family.TYPE, this._linkValue == -1 ? (short)1 : 2, (short)0), creationDateType == null ? this.getLastUpdateDate() : creationDateType, updateDateType == null ? this.getLastUpdateDate() : updateDateType, "", this._typeSubFamilyFolder);
                    }
                    assert (folderModelType != null);
                    DBFolder folderVersType = folderModelType.findChild(versType);
                    if (folderVersType == null) {
                        folderVersType = this.createNewFolder(versType, DBFolder.createFlagsVersion(DBFolder.Family.TYPE, this._linkValue == -1 ? (short)1 : 2, (short)0), creationDateType == null ? this.getLastUpdateDate() : creationDateType, updateDateType == null ? this.getLastUpdateDate() : updateDateType, comment, folderModelType);
                    }
                    if (this._linkValue == -1) {
                        this._type = new DBEnum(folderVersType);
                        break;
                    }
                    this._type = new DBRecord(folderVersType);
                    if (this._linkValue == 1) {
                        ((DBRecord)this._type).setTypeLink(DBRecord.LinkType.UNIDIRECT);
                        break;
                    }
                    if (this._linkValue == 2) {
                        ((DBRecord)this._type).setTypeLink(DBRecord.LinkType.BIDIRECT);
                        break;
                    }
                    ((DBRecord)this._type).setTypeLink(DBRecord.LinkType.UNDEFINE);
                    break;
                }
                if (this._isInSubFamilyFolder) {
                    assert (this._typeFamilyFolder != null);
                    this._typeSubFamilyFolder = this._typeFamilyFolder.findChild(nameFolder);
                    if (this._typeSubFamilyFolder != null) break;
                    this._typeSubFamilyFolder = this.createNewFolder(nameFolder, DBFolder.createFlagsFolder(DBFolder.Family.TYPE, (short)0, (short)0), true, this._typeFamilyFolder);
                    break;
                }
                DBFolder root = this.getCECFactory().createFolderDAO().getRootID("TYPE_FAMILIES");
                this._typeFamilyFolder = root.findChild(nameFolder);
                if (this._typeFamilyFolder != null) break;
                this._typeFamilyFolder = this.createNewFolder(nameFolder, DBFolder.createFlagsFolder(DBFolder.Family.TYPE, (short)0, (short)0), true, this.getCECFactory().createFolderDAO().getRootID("TYPE_FAMILIES"));
                break;
            }
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        switch (name) {
            case "TYPE_FAMILY": {
                this.getLinker().linkElements(OCas51Linker.TypeObject.DBENUM);
                return true;
            }
            case "TYPE_SUB_FAMILY": {
                this._isInSubFamilyFolder = false;
                break;
            }
            case "TYPE": {
                if (this.isInInstanciationMode()) {
                    DBFolder folderType = this._type.getDBFolder();
                    this.addObjectFromFolder(folderType, this._type, this._releaseStr, this._ownerStr, this._idExternLaeticia, this._isFrozen);
                    if (this._type instanceof DBEnum) {
                        String path = this.getPath(folderType, this.getCECFactory().createFolderDAO().getRootID("TYPE_FAMILIES"));
                        if (!this._isInSubFamilyFolder) {
                            path = path.replace("/Default", "");
                        }
                        this.getLinker().addNewObject(path, OCas51Linker.TypeObject.DBENUM, folderType);
                    }
                } else {
                    this.addContentToObject(this._type.getDBFolder());
                }
                this._linkValue = 0;
                this._cptFields = 0;
                this._type = null;
                this._isInType = false;
            }
        }
        return false;
    }

    private final DBRecordField.Direction getDirectionFromStr(String value) {
        if (value.equals("normal")) {
            return DBRecordField.Direction.NORMAL;
        }
        if (value.equals("inverse")) {
            return DBRecordField.Direction.INVERSE;
        }
        assert (false);
        return null;
    }

    private final String getPath(DBFolder folder, DBFolder limitFolder) {
        assert (folder != null);
        String[] paths = new String[4];
        int i = 0;
        while (folder != null) {
            paths[i++] = folder.getName();
            if ((folder = folder.getParent()) == null) {
                return null;
            }
            if (folder != limitFolder) continue;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 3; i >= 1; --i) {
            sb.append(paths[i]);
            sb.append('/');
        }
        sb.setLength(sb.length() - 1);
        sb.append(';');
        sb.append(paths[0]);
        return sb.toString();
    }

    protected void addContentToObject(DBFolder componentVersFolder) {
        DBObject obj = componentVersFolder.getObject();
        DBType type = (DBType)this.getCECFactory().createObjectDAO().getWrap(obj);
        String nature = null;
        if (type instanceof DBEnum) {
            DBEnum enumerate = (DBEnum)type;
            ref = (DBEnum)this._type;
            for (i = 0; i < this._type.getValueCount(); ++i) {
                enumerate.addValue(((DBEnum)ref).getValueAt(i), i);
            }
            nature = "type.enumerated";
        } else if (type instanceof DBRecord) {
            DBRecord record = (DBRecord)type;
            ref = (DBRecord)this._type;
            for (i = 0; i < this._type.getValueCount(); ++i) {
                record.addField(((DBRecord)ref).getFieldAt(i), i);
            }
            nature = "type.structured";
        }
        assert (nature != null);
        DBObjModel dbObjModel = type.writeDBObjModel(false);
        obj.delModel(obj.getModel(nature));
        obj.addModel(new DBObjModelBytes(dbObjModel));
        for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
            type.getLogs().addLog(log);
        }
        DBObjModel dbObjLogs = type.writeDBObjLogs(false);
        obj.delModel(obj.getModel("logs"));
        obj.addModel(new DBObjModelBytes(dbObjLogs));
        this.clearLogs();
    }
}

