/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees;

import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.DAGImportChoice;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.io.GeneralIOPreferencies;
import com.dassault.cecilia.io.trees.CmdImportTreeAbstract;
import com.dassault.cecilia.io.trees.UtilityImportTreeDag;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.io.File;
import java.util.ArrayList;

public class CmdImportTreeDag
extends CmdImportTreeAbstract {
    public CmdImportTreeDag(CeciliaAppl appl, DBFolderTreeEditable owner, DBFolder dbFolder) {
        super(appl, owner, dbFolder);
    }

    @Override
    protected String getTitle() {
        return ResMsgCecilia.getString("MENU_IMPORT_DAG");
    }

    @Override
    protected FileFilterExtention createFileFilter() {
        return new FileFilterExtention(ResMsgObj.getString("FILE_TYPE_DAG"), ".dag").addExtention(".ara");
    }

    @Override
    protected String getImportName(File importFile) {
        String name = importFile.getName();
        int defLen = name.length();
        if (defLen > 4 && (name.substring(defLen - 4).equalsIgnoreCase(".DAG") || name.substring(defLen - 4).equalsIgnoreCase(".ARA"))) {
            name = name.substring(0, defLen - 4);
        }
        return DBFactory.convertName(name);
    }

    @Override
    protected void firstDo() {
        DAGImportChoice dagChoice = DAGImportChoice.FT_OR_BF;
        PluginWithOptions opts = this.getAppl().getPreferencies().getOptions(GeneralIOPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralIOPreferencies) {
            GeneralIOPreferencies gpref = (GeneralIOPreferencies)opts;
            dagChoice = gpref.getImportDagChoice();
        }
        UtilityImportTreeDag utility = new UtilityImportTreeDag(this.getAppl().getPlugable(), dagChoice){

            @Override
            protected void addError(File folder, MsgType msgType, String msg) {
                CmdImportTreeDag.this.addError(folder, msgType, msg);
            }
        };
        ArrayList<DBFolder> dbVersions = new ArrayList<DBFolder>(this._importFiles.length);
        for (CmdImportTreeAbstract.FileInfos fInfos : this._filesAll) {
            DBFolder dbVersion = utility.doImportFile((File)fInfos.getItem(), this._dstFolder, fInfos.getName(), fInfos.getConfict());
            if (dbVersion == null) continue;
            dbVersions.add(dbVersion);
        }
        this.finishDo(dbVersions);
    }
}

