/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta;

import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.DAGImportChoice;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.io.trees.UtilityImportTreeAbstract;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CaftaImportUtility
extends UtilityImportTreeAbstract {
    private final DBFolder _systemFolder;
    private final FTEquation _equation;
    private final Date _dateImport;
    private final File _originFile;
    private final String _nameTree;
    private DBConflict _conflict;
    private List<GeneralError<File>> _listMsg;
    boolean _bError = false;

    public CaftaImportUtility(DAOFactory daoFactory, DBUser dbUser, DBFolder systemFolder, String nameTree, File originFile, FTEquation equation, Date dateImport, DBConflict conflict) {
        super(daoFactory, dbUser);
        this._systemFolder = systemFolder;
        this._nameTree = nameTree;
        this._originFile = originFile;
        this._equation = equation;
        this._dateImport = dateImport;
        this._conflict = conflict;
    }

    public CaftaImportUtility setErrorMsgs(List<GeneralError<File>> listMsg) {
        this._listMsg = listMsg;
        return this;
    }

    @Override
    protected void addError(File folder, MsgType type, String msg) {
        if (type == MsgType.FATAL || type == MsgType.ERROR) {
            this._bError = true;
        }
        this._listMsg.add(new GeneralError<File>(folder, msg, type));
    }

    private boolean withError() {
        return this._bError;
    }

    public DBFolder doImportFile() {
        DBFolder folderModel = null;
        DBFolder folderVers = null;
        if (this._conflict == null) {
            folderModel = new DBFolder(this._systemFolder, this.getDBUser());
            folderModel.setName(this._nameTree);
            folderModel.setDateCreate(this._dateImport);
            folderModel.setDateModify(this._dateImport);
            if (this._systemFolder.getChildren() == null) {
                this.getDAOFactory().createFolderDAO().findChildren(this._systemFolder);
            }
            folderModel.setFlags(DBFolder.createFlagsModel(DBFolder.Family.PROJECT, (short)2, (short)0));
            folderVers = new DBFolder(folderModel, this.getDBUser());
            folderVers.setName("1.0");
            folderVers.setDateCreate(this._dateImport);
            folderVers.setDateModify(this._dateImport);
            folderVers.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, (short)2, (short)0));
        } else if (this._conflict == DBConflict.UPDATE || this._conflict == DBConflict.NEWVERSION) {
            folderModel = this._systemFolder.findChild(this._nameTree);
            folderVers = this.verifyVersionTargetWhenConflict(this._originFile, folderModel, this._conflict, DAGImportChoice.FAULT_TREE);
            if (this.withError()) {
                return null;
            }
            folderVers = this.createWithConflict(this._conflict, folderModel, folderVers, false);
        }
        this.addDefaultLog(this._equation);
        this._equation.setFolder(folderVers);
        if (this._conflict != DBConflict.UPDATE) {
            DBObject obj = new DBObject(folderVers.getID()).setFolder(folderVers);
            obj.addModel(this._equation.writeDBObjModel(false));
            obj.addModel(this._equation.writeDBObjLogs(false));
            folderVers.setRelations(this._equation.getUseRelations());
            folderVers.setObject(obj);
            obj.addProperty(new DBObjProperty().setName("object.release").setType("Long").setValue("1"));
            obj.addProperty(new DBObjProperty().setName("object.creator").setType("String").setValue(this.getDBUser().getLogin()));
            if (this._conflict == null) {
                this.createFolders(this._originFile, folderModel, folderVers);
                if (this.withError()) {
                    return null;
                }
            } else {
                this.getDAOFactory().createFolderDAO().create(folderVers);
            }
        } else if (this._conflict == DBConflict.UPDATE) {
            DBObjProperty releaseProperty;
            folderVers.setParent(folderModel);
            DBObject dbObject = folderVers.getObject();
            DBObjModel dbObjModel = this._equation.writeDBObjLogs(true);
            if (dbObjModel.getID() < 0L) {
                dbObject.addModel(dbObjModel);
            }
            if ((dbObjModel = this._equation.writeDBObjModel(true)).getID() < 0L) {
                dbObject.addModel(dbObjModel);
            }
            if ((releaseProperty = dbObject.getProperty("object.release")) == null) {
                dbObject.addProperty(new DBObjProperty().setName("object.release").setType("Long").setValue("1"));
            } else {
                long oldRelease = DBObjProperty.getObjectRelease(releaseProperty);
                if (oldRelease >= 0L) {
                    releaseProperty.setValue(Long.toString(oldRelease + 1L));
                }
            }
            folderVers.setRelations(this._equation.getUseRelations());
            this.getDAOFactory().createFolderDAO().update(folderVers);
        }
        if (folderVers != null) {
            folderVers.setMustBeUpdated(true);
            if (!Boolean.getBoolean("cecilia.ft.import.NoUpdateEGL")) {
                Collection<DBGlobEvent> events = this._equation.createGlobalEvents(folderVers);
                if (!this.getDAOFactory().createGlobEventDAO().insertAll(folderVers, events)) {
                    this.addError(this._originFile, MsgType.WARNING, ResMsgObj.getString("EGL_MSG_GENERATE_GENERAL"));
                }
            }
        }
        return folderVers;
    }

    protected void addDefaultLog(DBLogsWrap dbWrap) {
        DBLogs logs = new DBLogs();
        DBLogs.Log log = logs.addLog(this._dateImport, this.getDBUser().getLogin(), DBLogs.DBLevel.FINE, ResMsgCafta.msgFormat("CAFTA_IMPORT_LOGS_INFORMATION", this._originFile.getAbsolutePath()));
        dbWrap.getLogs().addLog(log);
    }
}

