/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnonymizeExportDlg
extends JDialogCecilia {
    JTextField _ctrlPath;
    JCheckBox _ctrlTrace;
    JCheckBox _ctrlLawParameters;
    JTextField _ctrlTracePath;
    File _defPath;
    static boolean _bSelectLawParameters = true;
    static boolean _bSelectTrace = false;
    static String _strSelectTrace = "";
    static JFileChooser _fileChooserResult;

    JFileChooser createFileChooser() {
        if (_fileChooserResult == null) {
            _fileChooserResult = new JFileChooser();
            FileFilterExtention xmlFilter = new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_XML"), ".xml").verifyWrite(true);
            _fileChooserResult.addChoosableFileFilter(xmlFilter);
            _fileChooserResult.setFileFilter(xmlFilter);
            _fileChooserResult.setCurrentDirectory(this._defPath);
        }
        return _fileChooserResult;
    }

    public AnonymizeExportDlg(Window win, File defPath) {
        super(win);
        this._defPath = defPath;
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel rPanel = new JPanel(new GridBagLayout());
        rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._result = false;
        int line = 0;
        rPanel.add((Component)new JLabel(ResMsgObj.getString("MSG_ANONYMISE_DLG_PATH")), new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this._ctrlPath = new JTextField(30);
        rPanel.add((Component)this._ctrlPath, new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        JButton bPath = new JButton("...");
        rPanel.add((Component)bPath, new GridBagConstraints(1, line++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        bPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = AnonymizeExportDlg.this.createFileChooser();
                if (fc.showSaveDialog(AnonymizeExportDlg.this._ctrlPath) == 0) {
                    AnonymizeExportDlg.this._defPath = fc.getSelectedFile().getParentFile();
                    AnonymizeExportDlg.this._ctrlPath.setText(FileFilterExtention.addDefaultExtention(fc).getPath());
                }
            }
        });
        JPanel oPanel = new JPanel(new GridBagLayout());
        oPanel.setBorder(BorderFactory.createTitledBorder(ResMsgObj.getString("MSG_ANONYMISE_DLG_OPTIONS")));
        int oLine = 0;
        this._ctrlLawParameters = new JCheckBox(ResMsgObj.getString("MSG_ANONYMISE_DLG_LAW"));
        oPanel.add((Component)this._ctrlLawParameters, new GridBagConstraints(0, oLine++, 2, 1, 100.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this._ctrlTracePath = new JTextField(30);
        final JButton bPath2 = new JButton("...");
        this._ctrlTracePath.setEnabled(false);
        this._ctrlTracePath.setToolTipText(ResMsgObj.getString("MSG_ANONYMISE_DLG_TRACE_PATH"));
        bPath2.setEnabled(false);
        this._ctrlTrace = new JCheckBox(ResMsgObj.getString("MSG_ANONYMISE_DLG_TRACE"));
        this._ctrlTrace.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enable = AnonymizeExportDlg.this._ctrlTrace.isSelected();
                AnonymizeExportDlg.this._ctrlTracePath.setEnabled(enable);
                bPath2.setEnabled(enable);
            }
        });
        oPanel.add((Component)this._ctrlTrace, new GridBagConstraints(0, oLine++, 2, 1, 100.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        oPanel.add((Component)this._ctrlTracePath, new GridBagConstraints(0, oLine, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 15, 5, 0), 0, 0));
        oPanel.add((Component)bPath2, new GridBagConstraints(1, oLine++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        bPath2.addActionListener(new ActionListener(){
            JFileChooser _fileChooserTrace = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this._fileChooserTrace == null) {
                    this._fileChooserTrace = new JFileChooser();
                    FileFilterExtention txtFilter = new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_CSV"), ".csv").verifyWrite(true);
                    this._fileChooserTrace.addChoosableFileFilter(txtFilter);
                    this._fileChooserTrace.setFileFilter(txtFilter);
                }
                this._fileChooserTrace.setCurrentDirectory(AnonymizeExportDlg.this._defPath);
                if (this._fileChooserTrace.showSaveDialog(AnonymizeExportDlg.this._ctrlTracePath) == 0) {
                    AnonymizeExportDlg.this._defPath = this._fileChooserTrace.getSelectedFile().getParentFile();
                    AnonymizeExportDlg.this._ctrlTracePath.setText(FileFilterExtention.addDefaultExtention(this._fileChooserTrace).getPath());
                }
            }
        });
        rPanel.add((Component)oPanel, new GridBagConstraints(0, line++, 2, 1, 100.0, 100.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, line++, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JFileChooser fc = this.createFileChooser();
        File file = fc.getSelectedFile();
        if (file != null) {
            this._ctrlPath.setText(FileFilterExtention.addDefaultExtention(fc).getPath());
        }
        this._ctrlLawParameters.setSelected(_bSelectLawParameters);
        this._ctrlTrace.setSelected(_bSelectTrace);
        this._ctrlTracePath.setText(_strSelectTrace);
        this.getContentPane().add((Component)rPanel, "Center");
        this.pack();
        Dimension tSize = this.getSize();
        Dimension pSize = this.getOwner().getSize();
        Point pLoc = this.getOwner().getLocation();
        this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
        this.setResizable(true);
        this.setTitle(ResMsgVoc.getString("VOC_ANONYMIZE"));
    }

    public boolean DoModal() {
        this._result = false;
        this.setModal(true);
        this.setVisible(true);
        if (this._result) {
            _bSelectLawParameters = this._ctrlLawParameters.isSelected();
            _bSelectTrace = this._ctrlTrace.isSelected();
            _strSelectTrace = this._ctrlTracePath.getText();
        }
        return this._result;
    }

    @Override
    protected boolean verifyParameters() {
        String title = ResMsgVoc.getString("VOC_ANONYMIZE");
        String path = this._ctrlPath.getText();
        if (this._ctrlTrace.isSelected()) {
            String trace = this._ctrlTracePath.getText();
            if (!FileUtility.verifyPaths((boolean)true, (Component)this._ctrlPath, (String)title, (String[])new String[]{path, trace})) {
                return false;
            }
        }
        return FileUtility.verifyPath((String)path, (boolean)true, (Component)this._ctrlPath, (String)title);
    }

    public String getExportPath() {
        return this._ctrlPath.getText();
    }

    public String getTracePath() {
        if (this._ctrlTrace.isSelected()) {
            return this._ctrlTracePath.getText();
        }
        return null;
    }

    public boolean isAnonymizeLawParameters() {
        return this._ctrlLawParameters.isSelected();
    }
}

