/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.actions.search.SearchPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public abstract class SearchJListPanel
extends SearchPanel {
    protected JList _listElements;

    public SearchJListPanel(SearchDlg dlg, SearchDlg.SearchType type) {
        super(dlg, type);
    }

    @Override
    protected JComponent createComponentForResult() {
        this._listElements = new JList();
        this._listElements.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<? extends Object> list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, object, index, isSelected, cellHasFocus);
                if (object instanceof DBFolder) {
                    DBFolder folder = (DBFolder)object;
                    label.setIcon(DBFolderResources.getIcon(folder, true, true, false, false));
                    label.setText(FolderRenderer.convertFolderToText(folder, FolderRenderer.DBFolderName.REFPATH));
                } else if (object instanceof FTVariableAbstract) {
                    FTVariableAbstract ftVarAbs = (FTVariableAbstract)object;
                    label.setText(ftVarAbs.getName());
                    if (ftVarAbs.isLeaf()) {
                        label.setIcon(ResIcoCore.getImageIcon("FOLDER_EVENT_"));
                    } else {
                        label.setIcon(ResIcoArbor.getImageIcon("PAND"));
                    }
                }
                return label;
            }
        });
        this._listElements.setModel(new DefaultListModel());
        this._listElements.setSelectionMode(0);
        JScrollPane scrollPaneList = new JScrollPane(this._listElements);
        scrollPaneList.setPreferredSize(new Dimension(400, 300));
        return scrollPaneList;
    }

    @Override
    protected JComponent getComponentForResult() {
        return this._listElements;
    }

    protected final void clearElements() {
        assert (this._listElements != null);
        ListModel model = this._listElements.getModel();
        assert (model instanceof DefaultListModel);
        ((DefaultListModel)model).clear();
    }

    @Override
    protected void doUpdateData(SearchAction.SearchContext context) {
        DefaultListModel model = (DefaultListModel)context.getData();
        this._listElements.clearSelection();
        this._listElements.setModel(model);
        this._listElements.setSelectedIndex((Integer)context.getSelectedData());
        this._listElements.ensureIndexIsVisible((Integer)context.getSelectedData());
        this._listElements.revalidate();
        this._listElements.repaint();
    }

    @Override
    public SearchAction.SearchContext getContext() {
        return new SearchAction.SearchContext(this._filtreJTF.getText(), this._listElements.getModel(), this._listElements.getSelectedIndex());
    }

    @Override
    public void resetContext() {
        this._listElements.setModel(new DefaultListModel());
        this._listElements.revalidate();
        this._listElements.repaint();
    }

    @Override
    public void exit() {
        super.exit();
        this.resetContext();
    }

    @Override
    public void updateEnabled(boolean selectable) {
        super.updateEnabled(selectable);
        this._listElements.setBackground(selectable ? Color.WHITE : new Color(230, 230, 230));
    }
}

