/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class SearchPanel
extends JPanel {
    protected final SearchDlg _dlg;
    protected final SearchDlg.SearchType _type;
    protected JTextField _filtreJTF;
    protected boolean _isCaseSensitive = false;
    protected JLabel _modelLbl;
    private JLabel _filtreLbl;
    private JButton _searchButton;
    private JCheckBox _caseSensitiveBox;

    protected SearchPanel(SearchDlg dlg, SearchDlg.SearchType type) {
        super(new BorderLayout());
        this._dlg = dlg;
        this._type = type;
        JPanel panel = this.createPrincipalPanel();
        this.add((Component)panel, "Center");
    }

    protected CInternalFrame getFrame() {
        return this._dlg.getFrame();
    }

    protected JPanel createPrincipalPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._modelLbl = new JLabel(" ");
        int y = 0;
        this._filtreLbl = new JLabel(ResMsgCecilia.getString("DLG_ACTION_SEARCH_FILTER"));
        this._filtreJTF = new JTextField();
        this._filtreJTF.setToolTipText(ResMsgCore.getString("FT_SEARCH_TABLE_REGEX_TOOLTIP"));
        this._searchButton = new JButton(ResIcoCore.getImageIcon("BUT_SEARCH"));
        this._searchButton.addActionListener(e -> this.doFillWithData());
        this._caseSensitiveBox = new JCheckBox(ResMsgCecilia.getString("DLG_ACTION_SEARCH_CASE_SENSITIVE"));
        this._caseSensitiveBox.addActionListener(e -> {
            this._isCaseSensitive = this._caseSensitiveBox.isSelected();
        });
        this._filtreJTF.addActionListener(e -> {
            if (!this._filtreJTF.getText().isEmpty()) {
                this.doFillWithData();
                this.getComponentForResult().requestFocus();
            }
        });
        if (this._type != SearchDlg.SearchType.BIBLIO) {
            panel.add((Component)this._modelLbl, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        panel.add((Component)this._filtreLbl, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._filtreJTF, new GridBagConstraints(1, y, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._searchButton, new GridBagConstraints(2, y++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._caseSensitiveBox, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JComponent scrollPane = this.createComponentForResult();
        panel.add((Component)scrollPane, new GridBagConstraints(0, y, 3, 1, 100.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.createActions();
        return panel;
    }

    protected abstract JComponent createComponentForResult();

    protected abstract JComponent getComponentForResult();

    protected abstract void doFillWithData();

    public abstract void doLocateAction();

    public abstract void doOpenAction();

    protected abstract void doUpdateData(SearchAction.SearchContext var1);

    public abstract SearchAction.SearchContext getContext();

    public abstract void resetContext();

    public void exit() {
        this._modelLbl.setText(" ");
    }

    public void setModelName(String name) {
        this._modelLbl.setText(ResMsgCecilia.msgFormat("DLG_ACTION_SEARCH_CURRENT_MODELE", name));
    }

    public void update(SearchAction.SearchContext context) {
        this._filtreJTF.setText(context.getSearchText());
        this.doUpdateData(context);
        this.revalidate();
        this.repaint();
    }

    protected void createActions() {
        this.getComponentForResult().getInputMap().put(KeyStroke.getKeyStroke(10, 0), "locateAction");
        this.getComponentForResult().getActionMap().put("locateAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.doLocateAction();
            }
        });
        this.getComponentForResult().getInputMap().put(KeyStroke.getKeyStroke(10, 512), "openAction");
        this.getComponentForResult().getActionMap().put("openAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.doOpenAction();
            }
        });
        this.getComponentForResult().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    if (e.isAltDown()) {
                        SearchPanel.this.doOpenAction();
                    } else {
                        SearchPanel.this.doLocateAction();
                    }
                }
            }
        });
    }

    protected static void recupAllFolderObject(CAppl cAppl, Collection<DBFolder> folders, Set<DBFolder> recups, Set<DBFolder> treats, SearchDlg.SearchType type) {
        for (DBFolder dbFolder : folders) {
            if (type == SearchDlg.SearchType.IMAGE && dbFolder.getFamily() != DBFolder.Family.IMAG || type == SearchDlg.SearchType.BIBLIO && dbFolder.getFamily() == DBFolder.Family.IMAG || treats.contains(dbFolder)) continue;
            treats.add(dbFolder);
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = cAppl.getDAOFactory().createFolderDAO().findChildren(dbFolder);
            }
            SearchPanel.recupAllFolderObject(cAppl, children, recups, treats, type);
            if (dbFolder.getObject() != null) {
                if (!dbFolder.isVersion()) continue;
                recups.add(dbFolder);
                continue;
            }
            if (!dbFolder.isVersion()) continue;
            switch (dbFolder.getFamily()) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    recups.add(dbFolder);
                }
            }
        }
    }

    public void updateEnabled(boolean selectable) {
        this._filtreLbl.setEnabled(selectable);
        this._filtreJTF.setEnabled(selectable);
        this._modelLbl.setEnabled(selectable);
        this._searchButton.setEnabled(selectable);
        this._caseSensitiveBox.setEnabled(selectable);
    }

    protected Pattern createPattern() {
        String filterStr = this._filtreJTF.getText();
        try {
            return Pattern.compile(filterStr, !this._isCaseSensitive ? 2 : 0);
        }
        catch (PatternSyntaxException e) {
            JOptionPane.showMessageDialog(this._filtreJTF, ResMsgCecilia.msgFormat("DLG_ACTION_SEARCH_ERR_REGEX", e.getMessage()), JOptionCecilia.getTopTitleOf(this), 0);
            this._filtreJTF.requestFocus();
            return null;
        }
    }
}

