/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.actions.search.SearchJListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SearchSubstitutionPanel
extends SearchJListPanel {
    private JTextField _replaceJtf;
    private JTextField _byJtf;
    private SubstitutionTable _table;

    public SearchSubstitutionPanel(SearchDlg dlg, SearchDlg.SearchType type) {
        super(dlg, type);
    }

    @Override
    protected JPanel createPrincipalPanel() {
        JPanel searchPanel = super.createPrincipalPanel();
        JPanel substitutionPanel = this.createSubstitutionPanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)searchPanel, "North");
        mainPanel.add((Component)substitutionPanel, "South");
        return mainPanel;
    }

    @Override
    protected void doFillWithData() {
        DefaultListModel defListModel = (DefaultListModel)this._listElements.getModel();
        this.clearElements();
        Pattern pattern = this.createPattern();
        if (pattern == null) {
            return;
        }
        FTEquation equation = ((FTEquationFrame)this._dlg.getFrame()).getDBWrap();
        List<FTVariableAbstract> varAbst = equation.getAllVariables();
        for (FTVariableAbstract ftVar : varAbst) {
            String varName = ftVar.getName();
            if (!pattern.matcher(varName).find()) continue;
            defListModel.add(this._listElements.getModel().getSize(), ftVar);
        }
    }

    @Override
    public void doLocateAction() {
    }

    @Override
    public void doOpenAction() {
    }

    private final JPanel createSubstitutionPanel() {
        JLabel replaceLbl = new JLabel("Replace :");
        this._replaceJtf = new JTextField();
        JLabel byLbl = new JLabel("By :");
        this._byJtf = new JTextField();
        JButton button = new JButton(ResIcoCore.getImageIcon("BUT_SEARCH"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchSubstitutionPanel.this.fillTableWithDate();
            }
        });
        this._table = new SubstitutionTable(new SubstitutionTableModel());
        JScrollPane scrollPaneList = new JScrollPane(this._table);
        scrollPaneList.setPreferredSize(new Dimension(400, 300));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)replaceLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)this._replaceJtf, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)byLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)this._byJtf, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)button, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)scrollPaneList, new GridBagConstraints(0, 2, 1, 3, 100.0, 100.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        return mainPanel;
    }

    private final void fillTableWithDate() {
        ((DefaultTableModel)this._table.getModel()).setRowCount(0);
        String replaceTxt = this._replaceJtf.getText();
        String byTxt = this._byJtf.getText();
        if (replaceTxt.isEmpty() || byTxt.isEmpty()) {
            return;
        }
        for (int i = 0; i < this._listElements.getModel().getSize(); ++i) {
            FTVariableAbstract ftVar = (FTVariableAbstract)this._listElements.getModel().getElementAt(i);
            String nameVar = ftVar.getName();
            if (!nameVar.contains(replaceTxt)) continue;
            String newString = nameVar.replaceAll(replaceTxt, byTxt);
            ((DefaultTableModel)this._table.getModel()).addRow(new Object[]{ftVar, newString});
        }
    }

    private final class SubstitutionTable
    extends JTable {
        public SubstitutionTable(TableModel tm) {
            super(tm);
            this.setSelectionMode(0);
        }

        @Override
        public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof FTVariableAbstract) {
                        FTVariableAbstract ftVarAbs = (FTVariableAbstract)value;
                        label.setText(ftVarAbs.getName());
                        if (ftVarAbs.isLeaf()) {
                            label.setIcon(ResIcoCore.getImageIcon("FOLDER_EVENT_"));
                        } else {
                            label.setIcon(ResIcoArbor.getImageIcon("PAND"));
                        }
                    } else {
                        FTVariableAbstract ftVarAbs = (FTVariableAbstract)table.getValueAt(row, 0);
                        if (ftVarAbs.isLeaf()) {
                            label.setIcon(ResIcoCore.getImageIcon("FOLDER_EVENT_"));
                        } else {
                            label.setIcon(ResIcoCore.getImageIcon("FOLDER_GATE_"));
                        }
                    }
                    return label;
                }
            };
        }
    }

    private final class SubstitutionTableModel
    extends DefaultTableModel {
        public static final int IDX_EVENT_BEFORE_SUBSTITUTION = 0;
        public static final int IDX_EVENT_AFTER_SUBSTITUTION = 1;

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return FTVariableAbstract.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            assert (false) : "Column out of bounds.";
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Original name";
            }
            if (columnIndex == 1) {
                return "Substitued name";
            }
            assert (false) : "Column out of bounds.";
            return null;
        }
    }
}

