/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.lib.util.collection.IdentityHashSet;
import com.dassault.cecilia.main.cecilia.ResIcoCecilia;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.gui.CDesktopPane;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import com.dassault.cecilia.main.cecilia.gui.CPlugPanel;
import com.dassault.cecilia.main.cecilia.gui.DesktopPreferencies;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AltaDesktopPane
extends JDesktopPane
implements Preferencies.PreferenciesListener {
    private static Logger _LOG = Logger.getLogger(AltaDesktopPane.class.getPackage().getName());
    private ImageIcon _logo = null;
    private boolean _isPattern = false;
    private final CDesktopPane _parent;
    ArrayList<ChangeSelectedFrameListener> _listeners = new ArrayList();
    IdentityHashSet<JInternalFrame> _forgetLogFrames = new IdentityHashSet();
    long _prefsCode = -1L;

    public AltaDesktopPane(CDesktopPane pane, boolean isPattern) {
        this._parent = pane;
        this.setDesktopManager(new AltaDesktopManager(this));
        this._isPattern = isPattern;
        this._logo = new ImageIcon(ResIcoCecilia.getInstance().getImage("BACKGROUND_CREPI", -1, -1));
        this.putClientProperty("JDesktopPane.dragMode", "outline");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AltaDesktopPane.this.getDesktopManager().updateFramesPosition();
            }
        });
    }

    @Override
    public AltaDesktopManager getDesktopManager() {
        return (AltaDesktopManager)super.getDesktopManager();
    }

    public AltaDesktopPane(Color color) {
        this._parent = null;
        this.setDesktopManager(new DefaultDesktopManager());
        this.setBackground(color);
        this.putClientProperty("JDesktopPane.dragMode", "outline");
    }

    public void setImage(String imageFileName, boolean isPattern) {
        this._isPattern = isPattern;
        if (imageFileName.startsWith("BACKGROUND_")) {
            Image img = ResIcoCecilia.getInstance().getImage(imageFileName, -1, -1);
            if (img != null) {
                this._logo = new ImageIcon(img);
            } else {
                this.removeImage();
            }
        } else {
            this.removeImage();
        }
    }

    public void setImage(File imageFile, boolean isPattern) {
        this._isPattern = isPattern;
        this._logo = new ImageIcon(Toolkit.getDefaultToolkit().createImage(imageFile.getName()));
    }

    public void removeImage() {
        this._logo = null;
    }

    public void setColor(Color color) {
        this.setBackground(color);
    }

    public void setColor(int r, int g, int b) {
        this.setBackground(new Color(r, g, b));
    }

    public void closeAllFrame() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames != null) {
            for (int i = allFrames.length - 1; i >= 0; --i) {
                allFrames[i].doDefaultCloseAction();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this._logo != null) {
            if (this._isPattern) {
                int w = this._logo.getIconWidth();
                int h = this._logo.getIconHeight();
                int x = 0;
                for (int y = 0; y < this.getSize().height; y += h) {
                    for (x = 0; x < this.getSize().width; x += w) {
                        g.drawImage(this._logo.getImage(), x, y, w, h, this.getBackground(), this);
                    }
                }
            } else {
                g.drawImage(this._logo.getImage(), 0, 0, this.getSize().width, this.getSize().height, this.getBackground(), this);
            }
        } else {
            this.paintComponent(g);
        }
        this.paintChildren(g);
    }

    public void addChangeSelectedFrameListener(ChangeSelectedFrameListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeChangeSelectedFrameListener(ChangeSelectedFrameListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireChanged(ChangeSelectedFrameEvent event) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).selectChanged(event);
        }
    }

    @Override
    public void setSelectedFrame(JInternalFrame f) {
        JInternalFrame previousFrame = this.getSelectedFrame();
        if (previousFrame == f) {
            return;
        }
        super.setSelectedFrame(f);
        if (f == null) {
            this.fireChanged(new ChangeSelectedFrameEvent(f, null));
        } else {
            DBFolder dbFolder = null;
            if (!(f instanceof CInternalFrame)) {
                if (!this._forgetLogFrames.contains((Object)f)) {
                    _LOG.info("Fenetre interne qui n'etend pas CInternalFrame ? : " + f.getClass().getName() + " - " + f.getTitle());
                    this._forgetLogFrames.add((Object)f);
                }
            } else {
                CInternalFrame cf = (CInternalFrame)f;
                dbFolder = cf.getDBFolder();
                if (dbFolder == null && !this._forgetLogFrames.contains((Object)f)) {
                    _LOG.finer("Fenetre interne qui n'est pas rattachee a un objet metier : " + f.getClass().getName() + " - " + f.getTitle());
                    this._forgetLogFrames.add((Object)f);
                }
            }
            this.fireChanged(new ChangeSelectedFrameEvent(f, dbFolder));
        }
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        if (this._prefsCode == prefs.getRefresh()) {
            return;
        }
        this._prefsCode = prefs.getRefresh();
        PluginWithOptions opts = prefs.getOptions(DesktopPreferencies.PREF_KEY);
        if (opts != null && opts instanceof DesktopPreferencies) {
            DesktopPreferencies dPref = (DesktopPreferencies)opts;
            this.setColor(dPref.getColorBackground());
            this.setImage(dPref.getKeyPattern(), dPref.isPattern());
            this.repaint();
        }
    }

    public List<JInternalFrame> getReorganizableFrames() {
        ArrayList<JInternalFrame> visibleFrames = new ArrayList<JInternalFrame>();
        for (JInternalFrame frame : this.getAllFrames()) {
            if (!frame.isVisible() || frame.isIcon() || frame instanceof CInternalFrame && !((CInternalFrame)frame).withReorganizedFrame()) continue;
            visibleFrames.add(frame);
        }
        return visibleFrames;
    }

    public void updateActions() {
        int sizeWindows = this.getReorganizableFrames().size();
        this._parent.updateActions(sizeWindows);
    }

    public static class AltaDesktopManager
    extends DefaultDesktopManager {
        private AltaDesktopPane _pane;
        private Map<Class, Location> _mapClassFramesToCoord;
        private Map<Class, Map<String, Location>> _mapClassToMapTitleToLocation;
        private static final int DEC_X = 20;
        private static final int DEC_Y = 20;
        private static final int DEFAULT_X_CASCADE = 20;
        private static final int DEFAULT_Y_CASCADE = 20;

        public AltaDesktopManager(AltaDesktopPane pane) {
            this._pane = pane;
            this._mapClassFramesToCoord = new LinkedHashMap<Class, Location>();
            this._mapClassToMapTitleToLocation = new LinkedHashMap<Class, Map<String, Location>>();
        }

        @Override
        public void openFrame(JInternalFrame f) {
            CInternalFrame.MemorizedLocation type;
            super.openFrame(f);
            if (f instanceof CInternalFrame && (type = ((CInternalFrame)f).withMemorizedLocation()) != CInternalFrame.MemorizedLocation.NEVER) {
                Class<?> clazz = f.getClass();
                if (f instanceof CPlugPanel) {
                    clazz = ((CPlugPanel)f).getPlugPanel().getClass();
                }
                Location previousLocation = null;
                Map<String, Location> mapTitleToFrame = this._mapClassToMapTitleToLocation.get(clazz);
                if (mapTitleToFrame == null) {
                    this._mapClassToMapTitleToLocation.put(clazz, new LinkedHashMap());
                } else {
                    previousLocation = mapTitleToFrame.get(f.getTitle());
                }
                if (previousLocation == null && (previousLocation = this._mapClassFramesToCoord.get(clazz)) != null && type == CInternalFrame.MemorizedLocation.KEEP_SIZE_AT_FIRST) {
                    previousLocation.setLocation(new Rectangle(previousLocation.getX(), previousLocation.getY(), f.getWidth(), f.getHeight()));
                }
                if (previousLocation == null) {
                    Point initLoc = this.initLocation(f);
                    previousLocation = new Location().setMaximize(false).setLocation(new Rectangle(initLoc.x, initLoc.y, f.getWidth(), f.getHeight()));
                }
                if (previousLocation.isMaximize()) {
                    this.chgFrameDisplay(f, true);
                } else {
                    Point newLocation = this.findAvailableLocation(f, new Point(previousLocation.getX(), previousLocation.getY()));
                    f.setLocation(newLocation.x, newLocation.y);
                    f.setSize(previousLocation.getWidth(), previousLocation.getHeight());
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _pane.updateActions();
                }
            });
        }

        @Override
        public void closeFrame(JInternalFrame f) {
            if (!(f instanceof CInternalFrame) || ((CInternalFrame)f).withMemorizedLocation() == CInternalFrame.MemorizedLocation.NEVER) {
                super.closeFrame(f);
            } else {
                Class<?> clazz = f.getClass();
                if (f instanceof CPlugPanel) {
                    clazz = ((CPlugPanel)f).getPlugPanel().getClass();
                }
                Location loc = new Location();
                boolean isMaximize = f.isMaximum();
                loc.setMaximize(isMaximize);
                loc.setLocation(new Rectangle(f.getX(), f.getY(), f.getWidth(), f.getHeight()));
                this._mapClassFramesToCoord.put(clazz, loc);
                if (this._mapClassToMapTitleToLocation.get(clazz) == null) {
                    this._mapClassToMapTitleToLocation.put(clazz, new LinkedHashMap());
                }
                this._mapClassToMapTitleToLocation.get(clazz).put(f.getTitle(), loc);
                super.closeFrame(f);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _pane.updateActions();
                }
            });
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            super.iconifyFrame(f);
            this._pane.updateActions();
        }

        @Override
        public void deiconifyFrame(JInternalFrame f) {
            super.deiconifyFrame(f);
            this._pane.updateActions();
        }

        protected void updateFramesPosition() {
            for (JInternalFrame frame : this._pane.getAllFrames()) {
                if ((double)frame.getX() > this._pane.getSize().getWidth()) {
                    frame.setLocation(this._pane.getWidth() - 30, (int)frame.getLocation().getY());
                }
                if (!((double)frame.getY() > this._pane.getSize().getHeight())) continue;
                frame.setLocation((int)frame.getLocation().getX(), this._pane.getHeight() - 40);
            }
        }

        private Point findAvailableLocation(JInternalFrame frame, Point oldLoc) {
            int currentX = oldLoc.x;
            int currentY = oldLoc.y;
            while (true) {
                boolean locOK = true;
                for (JInternalFrame otherFrame : this._pane.getAllFrames()) {
                    if (otherFrame == frame || !otherFrame.isVisible() || (int)otherFrame.getLocation().getX() != currentX || (int)otherFrame.getLocation().getY() != currentY) continue;
                    locOK = false;
                    break;
                }
                if (locOK) break;
                currentX += 20;
                currentY += 20;
            }
            return new Point(currentX, currentY);
        }

        public void reorganizeWindowsCascade() {
            List<JInternalFrame> frames = this._pane.getReorganizableFrames();
            for (JInternalFrame frame : frames) {
                frame.setLocation(new Point(0, 0));
            }
            for (JInternalFrame frame : frames) {
                this.chgFrameDisplay(frame, false);
                frame.setLocation(this.findAvailableLocation(frame, new Point(20, 20)));
                frame.setSize(2 * this._pane.getWidth() / 3, 2 * this._pane.getHeight() / 3);
            }
        }

        public void reorganizeWindowsMosaic() {
            List<JInternalFrame> frames = this._pane.getReorganizableFrames();
            if (frames.size() < 2) {
                JOptionPane.showMessageDialog(null, ResMsgCecilia.getString("ERR_MOSAIC_NOT_ENOUGH_ELEMENTS"), ResMsgCecilia.getString("MENU_MOSAIC"), 0);
                return;
            }
            if (frames.size() > 6) {
                JOptionPane.showMessageDialog(null, ResMsgCecilia.getString("ERR_MOSAIC_TOO_MANY_ELEMENTS"), ResMsgCecilia.getString("MENU_MOSAIC"), 0);
                return;
            }
            int width = this._pane.getWidth();
            int height = this._pane.getHeight();
            int midPaneWidth = width / 2;
            int midPaneHeight = height / 2;
            int size = frames.size();
            Point[] points = new Point[size];
            points[0] = new Point(0, 0);
            points[1] = new Point(midPaneWidth, 0);
            if (size > 2) {
                points[2] = new Point(0, midPaneHeight);
                if (size > 3) {
                    points[3] = new Point(midPaneWidth, midPaneHeight);
                }
            }
            Point[] sizes = new Point[size];
            sizes[0] = new Point(midPaneWidth, size > 2 ? midPaneHeight : height);
            sizes[1] = new Point(midPaneWidth, size > 3 ? midPaneHeight : height);
            if (size > 2) {
                sizes[2] = new Point(midPaneWidth, midPaneHeight);
                if (size > 3) {
                    sizes[3] = new Point(midPaneWidth, midPaneHeight);
                }
            }
            for (int i = 0; i < points.length; ++i) {
                this.chgFrameDisplay(frames.get(i), false);
                if (points[i] == null || sizes[i] == null) continue;
                frames.get(i).setLocation(points[i]);
                frames.get(i).setSize(sizes[i].x, sizes[i].y);
            }
        }

        private void chgFrameDisplay(JInternalFrame frame, boolean maximise) {
            try {
                frame.setMaximum(maximise);
            }
            catch (PropertyVetoException e) {
                _LOG.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }

        public Point initLocation(Component comp) {
            Dimension internalFrameSize = comp.getSize();
            Dimension desktopSize = this._pane.getSize();
            int x = internalFrameSize.width >= desktopSize.width ? 0 : (desktopSize.width - internalFrameSize.width) / 2;
            int y = internalFrameSize.height >= desktopSize.height ? 0 : (desktopSize.height - internalFrameSize.height) / 2;
            return new Point(x, y);
        }

        private static class Location {
            private boolean _isMaximize;
            private Rectangle _location;

            private Location() {
            }

            public Location setMaximize(boolean isMaximize) {
                this._isMaximize = isMaximize;
                return this;
            }

            public boolean isMaximize() {
                return this._isMaximize;
            }

            public int getX() {
                return (int)this._location.getX();
            }

            public int getY() {
                return (int)this._location.getY();
            }

            public int getWidth() {
                return (int)this._location.getWidth();
            }

            public int getHeight() {
                return (int)this._location.getHeight();
            }

            public Location setLocation(Rectangle location) {
                this._location = location;
                return this;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("Coord : ").append(this._location).append('\n');
                sb.append("Is ").append(this._isMaximize ? "" : "not").append(" maximized");
                return super.toString();
            }
        }
    }

    public static interface ChangeSelectedFrameListener {
        public void selectChanged(ChangeSelectedFrameEvent var1);
    }

    public static class ChangeSelectedFrameEvent {
        DBFolder _folder;
        JInternalFrame _frame;

        public ChangeSelectedFrameEvent(JInternalFrame frame, DBFolder folder) {
            this._frame = frame;
            this._folder = folder;
        }

        public DBFolder getFolder() {
            return this._folder;
        }

        public JInternalFrame getFrame() {
            return this._frame;
        }
    }
}

