/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeModel;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOUser;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.component.gui.ComponentFolderTree;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.EquipmentFolderTree;
import com.dassault.cecilia.dbobj.mbsa.operator.gui.OperatorFolderTree;
import com.dassault.cecilia.dbobj.mbsa.type.gui.TypeFolderTree;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.BTPFolderTree;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CFoldersPanel
extends JPanel {
    private static Logger _LOG = Logger.getLogger(CFoldersPanel.class.getPackage().getName());
    CeciliaAppl _application;
    DBUser _dbUser;
    List<DBFolder> _roots;
    List<DBFolderTreeModel> _models;
    Map<DBFolder.Family, DBFolderTreeActivable> _trees;
    DBFolderTreeActivable _oldTreeSelected = null;
    JTabbedPane _tabPane;

    public CFoldersPanel(CeciliaAppl application, DBUser dbUser, List<DBFolder> roots) {
        super(new BorderLayout());
        this._application = application;
        this._dbUser = dbUser;
        this._roots = roots;
        this._models = new ArrayList<DBFolderTreeModel>(this._roots.size() + 1);
        this._trees = new HashMap<DBFolder.Family, DBFolderTreeActivable>();
        this.make();
    }

    public DBFolderTreeActivable getTree(DBFolder.Family family) {
        DBFolderTreeActivable result = this._trees.get((Object)family);
        if (result == null) {
            result = this._trees.get((Object)DBFolder.Family.APPLICATION);
        }
        return result;
    }

    public DBFolderTreeActivable getSelectedTree() {
        Component tabSelected = this._tabPane.getSelectedComponent();
        if (tabSelected == null) {
            return null;
        }
        if (!(tabSelected instanceof JScrollPane)) {
            _LOG.warning("Un element des onglets de la partie arborescence n'est pas un JScrollPane.");
            return null;
        }
        Component tabTree = ((JScrollPane)tabSelected).getViewport().getView();
        if (tabTree == null) {
            _LOG.warning("L'element du JScrollPane d'un onglet de la partie arborescence n'est pas defini.");
            return null;
        }
        if (!(tabTree instanceof DBFolderTreeActivable)) {
            _LOG.warning("Une des arborescences n'est pas un DBFolderTreeActivable.");
            return null;
        }
        return (DBFolderTreeActivable)tabTree;
    }

    public void make() {
        this._tabPane = new JTabbedPane();
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DAOUser daoUser = this._application.getDAOFactory().createUserDAO();
        this.filterAndSortRoots();
        for (int i = 0; i < this._roots.size(); ++i) {
            DBFolder root = this._roots.get(i);
            DBFolderTreeModel model = null;
            DBFolderTreeActivable tree = null;
            String title = null;
            ImageIcon icon = null;
            switch (root.getFamily()) {
                case APPLICATION: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, null, "Manage-Others"){

                        @Override
                        protected boolean filterFolder(DBFolder dbFolder) {
                            switch (dbFolder.getFamily()) {
                                case PROJECT: 
                                case IMAG: 
                                case EQUIPMENT: 
                                case COMPONENT: 
                                case OPERATOR: 
                                case TYPE: {
                                    return false;
                                }
                            }
                            return true;
                        }
                    };
                    tree = new BTPFolderTree(this._application, model);
                    title = ResMsgCore.getString("MSG_FOL_SYST_OTHER");
                    break;
                }
                case COMPONENT: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.COMPONENT, "Manage-Component");
                    tree = new ComponentFolderTree(this._application, model);
                    title = ResMsgVoc.getString("VOC_COMPONENTS");
                    icon = ResIcoCore.getImageIcon("FOLDER_COMPONENT_");
                    break;
                }
                case EQUIPMENT: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.EQUIPMENT, "Manage-Equipment");
                    tree = new EquipmentFolderTree(this._application, model);
                    title = ResMsgVoc.getString("VOC_EQUIPMENTS");
                    icon = ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_");
                    break;
                }
                case OPERATOR: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.OPERATOR, "Manage-Operator");
                    tree = new OperatorFolderTree(this._application, model);
                    title = ResMsgVoc.getString("VOC_OPERATORS");
                    icon = ResIcoCore.getImageIcon("FOLDER_OPERATOR_");
                    break;
                }
                case TYPE: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.TYPE, "Manage-Type");
                    tree = new TypeFolderTree(this._application, model);
                    title = ResMsgVoc.getString("VOC_TYPES");
                    icon = ResIcoCore.getImageIcon("FOLDER_LINK_");
                    break;
                }
                case PROJECT: {
                    model = new DBFolderVirtualTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.PROJECT, "Manage-Project");
                    tree = new ProjectFolderTree(this._application, model);
                    title = ResMsgVoc.getString("VOC_PROJECTS");
                    icon = ResIcoCore.getImageIcon("FOLDER_GRAPH_");
                    break;
                }
                case IMAG: {
                    model = new DBFolderTreeModel(daoFolder, daoUser, this._dbUser, DBFolder.Family.IMAG, "Manage-Icon");
                    tree = new DBFolderTreeActivable(this._application, model, true);
                    title = ResMsgVoc.getString("VOC_IMAGES");
                }
            }
            if (tree == null) continue;
            JScrollPane scroll = new JScrollPane(tree);
            scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (icon == null) {
                this._tabPane.addTab(title, scroll);
            } else {
                this._tabPane.addTab(title, icon, scroll);
            }
            model.setFolderRoot(root);
            this._application.addFolderUpdateListener(model);
            this._models.add(model);
            this._trees.put(root.getFamily(), tree);
            if (this._oldTreeSelected != null) continue;
            this._oldTreeSelected = tree;
        }
        this.add((Component)this._tabPane, "Center");
        this._tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CFoldersPanel.this._oldTreeSelected != null) {
                    CFoldersPanel.this._oldTreeSelected.toDoWhenDeActivated();
                }
                CFoldersPanel.this._oldTreeSelected = null;
                Component tabSelected = CFoldersPanel.this._tabPane.getSelectedComponent();
                if (tabSelected == null) {
                    return;
                }
                if (!(tabSelected instanceof JScrollPane)) {
                    _LOG.warning("Un element des onglets de la partie arborescence n'est pas un JScrollPane.");
                    return;
                }
                Component tabTree = ((JScrollPane)tabSelected).getViewport().getView();
                if (tabTree == null) {
                    _LOG.warning("L'element du JScrollPane d'un onglet de la partie arborescence n'est pas defini.");
                    return;
                }
                if (!(tabTree instanceof DBFolderTreeActivable)) {
                    _LOG.warning("Une des arborescences n'est pas un DBFolderTreeActivable.");
                    return;
                }
                CFoldersPanel.this._oldTreeSelected = (DBFolderTreeActivable)tabTree;
                if (CFoldersPanel.this._oldTreeSelected != null) {
                    CFoldersPanel.this._oldTreeSelected.toDoWhenActivated();
                }
            }
        });
        if (this._oldTreeSelected != null) {
            this._oldTreeSelected.toDoWhenActivated();
        }
    }

    public DBFolderTreeActivable selectDBFolderTree(DBFolder.Family family) {
        for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
            JScrollPane pane = (JScrollPane)this._tabPane.getComponentAt(i);
            DBFolderTreeActivable tabTree = (DBFolderTreeActivable)pane.getViewport().getView();
            DBFolder.Family treeFamily = tabTree.getModel().getFamilyFilter();
            if (treeFamily != family && (treeFamily != null || family != DBFolder.Family.APPLICATION)) continue;
            this._tabPane.setSelectedIndex(i);
            return tabTree;
        }
        return null;
    }

    private DBFolder removeFamily(List<DBFolder> list, DBFolder.Family family) {
        for (int i = 0; i < list.size(); ++i) {
            DBFolder item = list.get(i);
            if (!item.getFamily().equals((Object)family)) continue;
            list.remove(i);
            return item;
        }
        return null;
    }

    private void filterAndSortRoots() {
        ArrayList<DBFolder> roots = new ArrayList<DBFolder>(this._roots.size());
        DBFolder dbFolder = this.removeFamily(this._roots, DBFolder.Family.PROJECT);
        if (dbFolder == null) {
            _LOG.info("Pas de dossier PROJECT");
        } else {
            roots.add(dbFolder);
        }
        dbFolder = this.removeFamily(this._roots, DBFolder.Family.EQUIPMENT);
        if (dbFolder == null) {
            _LOG.info("Pas de dossier EQUIPMENT");
        } else {
            roots.add(dbFolder);
        }
        dbFolder = this.removeFamily(this._roots, DBFolder.Family.COMPONENT);
        if (dbFolder == null) {
            _LOG.info("Pas de dossier COMPONENT");
        } else {
            roots.add(dbFolder);
        }
        dbFolder = this.removeFamily(this._roots, DBFolder.Family.TYPE);
        if (dbFolder == null) {
            _LOG.info("Pas de dossier TYPE");
        } else {
            roots.add(dbFolder);
        }
        dbFolder = this.removeFamily(this._roots, DBFolder.Family.OPERATOR);
        if (dbFolder == null) {
            _LOG.info("Pas de dossier OPERATOR");
        } else {
            roots.add(dbFolder);
        }
        dbFolder = this.removeFamily(this._roots, DBFolder.Family.APPLICATION);
        if (dbFolder == null) {
            _LOG.info("Pas de dossier BTP/APPLICATION");
        } else {
            roots.add(dbFolder);
        }
        this._roots = roots;
    }

    public synchronized void parentWindowClosing() {
        for (int i = this._models.size() - 1; i >= 0; --i) {
            DBFolderTreeModel model = this._models.get(i);
            this._application.removeFolderUpdateListener(model);
        }
        this._models.clear();
    }
}

