/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.main.cecilia.gui.CRCIndicator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CPanelInformations
extends JPanel {
    private CAppl _application;
    JTextField _messageField = new JTextField();
    int _lastPosition = 0;
    int _crcIndex = 0;

    public CPanelInformations(CAppl appl) {
        super(new GridBagLayout());
        this._application = appl;
        this.make();
    }

    private void make() {
        final JTextField timeField = new JTextField();
        final JTextField dateField = new JTextField();
        timeField.setEditable(false);
        timeField.setColumns(7);
        timeField.setHorizontalAlignment(0);
        timeField.setBorder(BorderFactory.createLoweredBevelBorder());
        dateField.setEditable(false);
        dateField.setColumns(7);
        dateField.setHorizontalAlignment(0);
        dateField.setBorder(BorderFactory.createLoweredBevelBorder());
        this._application.addShedulerTask(new TimerTask(){

            @Override
            public void run() {
                Date date = new Date();
                DateFormat dateInstance = SimpleDateFormat.getDateInstance(3);
                DateFormat timeInstance = SimpleDateFormat.getTimeInstance(3);
                String timezone = System.getProperty("user.timezone");
                if (timezone != null) {
                    dateInstance.setTimeZone(TimeZone.getTimeZone(timezone));
                    timeInstance.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                dateField.setText(dateInstance.format(date));
                timeField.setText(timeInstance.format(date));
            }
        }, 10L, 60000L);
        this._messageField.setEditable(false);
        this._messageField.setColumns(60);
        this._messageField.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)timeField, new GridBagConstraints(this._lastPosition++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)dateField, new GridBagConstraints(this._lastPosition++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._messageField, new GridBagConstraints(this._lastPosition++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 2, 1, 0), 0, 0));
        if (!this._application.isReader() && ConfigManager.getInstance().getState() != ConfigManager.StateVersion.DEMO) {
            JTextField loginField = new JTextField();
            loginField.setEditable(false);
            loginField.setColumns(12);
            loginField.setHorizontalAlignment(0);
            DBUser user = this._application.getDBUser();
            loginField.setText(user.getLogin());
            StringBuffer tt = new StringBuffer().append(user.getName());
            String descr = user.getDescription();
            if (descr != null) {
                tt.append(" - ").append(descr);
            }
            loginField.setToolTipText(tt.toString());
            loginField.setBorder(BorderFactory.createLoweredBevelBorder());
            this.add((Component)loginField, new GridBagConstraints(this._lastPosition++, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(1, 2, 1, 0), 0, 0));
        }
    }

    public void displayMessage(String message) {
        if (message == null || message.isBlank()) {
            this._messageField.setText("");
            this._messageField.setToolTipText(null);
        } else {
            String msg = message.length() <= 60 ? message : message.substring(0, 60);
            this._messageField.setText(msg);
            this._messageField.setToolTipText(message);
        }
    }

    public void addCRCIndicator(String config) {
        CRCIndicator crcIndicator = new CRCIndicator(this._application, ++this._crcIndex, config);
        this.add((Component)crcIndicator, new GridBagConstraints(this._lastPosition++, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(1, 2, 1, 0), 0, 0));
    }
}

