/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.crc.client.CRCSchedulerUtil;
import com.dassault.cecilia.crc.common.CRCClientException;
import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.io.IOFilesExchangeSFTP;
import com.dassault.cecilia.crc.common.pojo.ManagerInfos;
import com.dassault.cecilia.crc.common.pojo.SftpInfosResponse;
import com.dassault.cecilia.crc.common.template.RestTemplateConfig;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class CRCIndicator
extends JLabel {
    private static final Logger _LOG = Logger.getLogger(CRCIndicator.class.getName());
    String _http;
    String _config;
    String _version;
    int _id;
    RestTemplate _restTemplate;
    String _errorMsg;
    ImageIcon[] _iconMsg;
    CAppl _application;
    long _lastCallRefresh = 0L;
    boolean _refreshActive = false;

    public CRCIndicator(CAppl appl, int id, String config) {
        super(ResIcoCore.getImageIcon("TASK_STOP"));
        this._application = appl;
        this._id = id;
        this._config = config;
        this._http = this._config.startsWith("https") ? "[https] " : "[http] ";
        this._version = null;
        this._iconMsg = new ImageIcon[]{ResIcoCore.getImageIcon("TASK_START"), ResIcoCore.getImageIcon("TASK_RESUME"), ResIcoCore.getImageIcon("TASK_RESUME_LOW"), ResIcoCore.getImageIcon("TASK_STOPPED"), ResIcoCore.getImageIcon("TASK_STOP")};
        this._errorMsg = "Not initialized";
        this.defineToolTip();
        this.init();
    }

    protected void defineToolTip() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>[").append(this._id).append("]: ");
        int beg = 0;
        int pos = this._errorMsg.indexOf(": ", beg);
        while (pos != -1) {
            buffer.append(this._errorMsg.substring(beg, pos + 2)).append("<br/>  ");
            beg = pos + 1;
            pos = this._errorMsg.indexOf(": ", beg);
        }
        buffer.append(this._errorMsg.substring(beg));
        buffer.append("</html>");
        this.setToolTipText(buffer.toString());
    }

    void init() {
        RestTemplateConfig restTemplateConfig = CRCSchedulerUtil.createRestTemplateConfig(this._config.startsWith("https"));
        try {
            this._restTemplate = restTemplateConfig.create();
        }
        catch (CRCException e) {
            this._errorMsg = "Structural exception when create REST Template: " + e.getMessage();
        }
        if (this._restTemplate != null) {
            long refreshPeriod = Long.getLong("cecilia.remote.computation.indicator.refresh", 0L);
            if (refreshPeriod >= 3000L) {
                this._application.addShedulerTask(new TimerTask(){

                    @Override
                    public void run() {
                        CRCIndicator.this.refresh();
                    }
                }, 2000L, refreshPeriod);
            } else {
                this.callRefresh();
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CRCIndicator.this.callRefresh();
                }
            });
        }
    }

    protected void callRefresh() {
        if (this._refreshActive) {
            return;
        }
        long timeCallRefresh = new Date().getTime();
        if (timeCallRefresh - this._lastCallRefresh < 3000L) {
            return;
        }
        this._lastCallRefresh = timeCallRefresh;
        _LOG.finest("Call Refresh indicator:" + this._id);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CRCIndicator.this.refresh();
            }
        }, "CRCIndicator.Refresh." + this._id);
        thread.start();
    }

    protected void refresh() {
        if (this._refreshActive) {
            return;
        }
        try {
            this._refreshActive = true;
            this.connectToCRCScheduler();
            this.defineToolTip();
            this.repaint();
        }
        finally {
            this._refreshActive = false;
        }
    }

    private static <T> T getForEntity(RestTemplate restTemplate, String uriString, Class<T> responseType) throws CRCException {
        try {
            URI uri = new URI(uriString);
            ResponseEntity response = restTemplate.getForEntity(uri, responseType);
            return (T)response.getBody();
        }
        catch (Exception e) {
            _LOG.log(Level.FINEST, "Call http exception", e);
            throw new CRCException((Throwable)e);
        }
    }

    protected void connectToCRCScheduler() {
        try {
            IOFilesExchangeSFTP ioFilesExchange;
            String errorMsg;
            String version = CRCIndicator.getForEntity(this._restTemplate, this._config + "/crcscheduler/version", String.class);
            if (this._version == null || !this._version.equals(version)) {
                this._version = version;
                _LOG.config("[CRCSheduler." + this._id + "] (Version): " + this._version);
            }
            if (!CRCSchedulerUtil.checkSchedulerVersion(version)) {
                this._errorMsg = "Version must be greater or equal at " + CRCSchedulerUtil.getMinSchedulerVersion();
                this.setIcon(this._iconMsg[4]);
                return;
            }
            SftpInfosResponse res = CRCIndicator.getForEntity(this._restTemplate, this._config + "/crcscheduler/credentials", SftpInfosResponse.class);
            if (res.getSftpHost() != null && (errorMsg = (ioFilesExchange = CRCSchedulerUtil.createIOFilesExchangeSFTP(res)).checkConnection()) != null) {
                this._errorMsg = "[sftp] Error during SFTP validation: " + errorMsg;
                this.setIcon(this._iconMsg[3]);
                return;
            }
            String mapString = CRCIndicator.getForEntity(this._restTemplate, this._config + "/crcscheduler/computations/managers", String.class);
            Map realMap = (Map)new ObjectMapper().readValue(mapString, (TypeReference)new TypeReference<Map<String, ManagerInfos>>(){});
            this.calculateOccupancyRate(realMap);
        }
        catch (CRCClientException e) {
            this._errorMsg = this._http + "The Scheduler service is not accessible.";
            this.setIcon(this._iconMsg[4]);
            return;
        }
        catch (Exception e) {
            this._errorMsg = this._http + "Exception during Scheduler connect: " + e.getMessage();
            this.setIcon(this._iconMsg[4]);
            return;
        }
    }

    private void calculateOccupancyRate(Map<String, ManagerInfos> realMap) {
        StringBuilder buffer = new StringBuilder();
        int curMem = 0;
        int maxMem = 0;
        int curCPU = 0;
        int maxCPU = 0;
        for (ManagerInfos infos : realMap.values()) {
            maxCPU += infos.getNbProcessor().intValue();
            curCPU += infos.getNbProcessor() - infos.getNbPendingComputations();
            maxMem += infos.getTotalMemory().intValue();
            curMem += infos.getAvailableMemory().intValue();
            buffer.append("{");
            buffer.append("Mem ").append(infos.getAvailableMemory()).append("/").append(infos.getTotalMemory());
            buffer.append(" - ");
            buffer.append("CPU ").append(infos.getNbProcessor() - infos.getNbPendingComputations()).append("/").append(infos.getNbProcessor());
            buffer.append("} ");
        }
        double rate = Math.min((double)curCPU / (double)maxCPU, (double)curMem / (double)maxMem);
        if (rate < 0.5) {
            this.setIcon(this._iconMsg[2]);
        } else if (rate < 1.0) {
            this.setIcon(this._iconMsg[1]);
        } else {
            this.setIcon(this._iconMsg[0]);
        }
        StringBuilder msg = new StringBuilder();
        msg.append((int)(rate *= 1000.0) / 10).append(".").append((int)rate % 10).append("%    ").append(buffer.toString());
        this._errorMsg = msg.toString();
    }
}

