/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.other.JIntegerTextField;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class DesktopPreferencies
implements PluginWithOptions,
PlugPanel {
    public static String PREF_KEY = DesktopPreferencies.class.getName();
    public static final String PREF_COLOR_R = PREF_KEY + "#ColorR";
    public static final String PREF_COLOR_G = PREF_KEY + "#ColorG";
    public static final String PREF_COLOR_B = PREF_KEY + "#ColorB";
    public static final String PREF_IMAG_KEY = PREF_KEY + "#ImagKey";
    public static final String PREF_IMAG_PATTERN = PREF_KEY + "#ImagPattern";
    static final String BACKGROUND_NONE = "NONE";
    JPanel _perfsPanel;
    int _colorR = 192;
    int _colorG = 192;
    int _colorB = 192;
    boolean _filePattern = true;
    BackgroundPredefine _predefine = BackgroundPredefine.NONE;
    private JIntegerTextField _ctrlRed;
    private JIntegerTextField _ctrlGreen;
    private JIntegerTextField _ctrlBlue;
    private JComboBox _ctrlImag;
    private JCheckBox _ctrlPattern;

    @Override
    public void trash() {
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this.load(launcher);
        return this;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this.load(launcher);
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        this.save(launcher);
        return true;
    }

    @Override
    public JPanel getPanel() {
        return this.makeContent();
    }

    @Override
    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return PREF_KEY;
        }
        if ("plugin.key.path".equals(key)) {
            return "GENERAL";
        }
        if ("plugin.name".equals(key)) {
            return ResMsgVoc.getString("VOC_DESK");
        }
        if ("plugin.title".equals(key)) {
            return ResMsgCecilia.getString("PREFS_DESK_TITLE");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgCecilia.getString("PREFS_DESK_DESC");
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return ResIcoCore.getImageIcon("PALETTE");
    }

    protected JPanel makeContent() {
        if (this._perfsPanel == null) {
            this._perfsPanel = new JPanel(new GridBagLayout());
            this._perfsPanel.add(this.createBackgroundPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 20, 10, 10), 0, 0));
            this._perfsPanel.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this._perfsPanel;
    }

    protected void load(Plugable launcher) {
        this.loadBackground(launcher);
    }

    protected void save(Plugable launcher) {
        this.saveBackground(launcher);
    }

    private Component createBackgroundPanel() {
        this._ctrlImag = new JComboBox();
        this._ctrlImag.setEditable(false);
        this._ctrlImag.addItem(BackgroundPredefine.NONE);
        this._ctrlImag.addItem(BackgroundPredefine.GRANIT);
        this._ctrlImag.addItem(BackgroundPredefine.GOUTTES);
        this._ctrlImag.addItem(BackgroundPredefine.CUIR);
        this._ctrlImag.addItem(BackgroundPredefine.CREPI);
        this._ctrlImag.addItem(BackgroundPredefine.NUAGE1);
        this._ctrlImag.addItem(BackgroundPredefine.NUAGE2);
        this._ctrlImag.addItem(BackgroundPredefine.BLEU);
        this._ctrlImag.addItem(BackgroundPredefine.MARBRE);
        this._ctrlImag.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof BackgroundPredefine) {
                    this.setText(((BackgroundPredefine)((Object)value)).getLbl());
                }
                return this;
            }
        });
        this._ctrlImag.setSelectedItem((Object)this._predefine);
        this._ctrlImag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopPreferencies.this._predefine = (BackgroundPredefine)((Object)DesktopPreferencies.this._ctrlImag.getSelectedItem());
            }
        });
        this._ctrlPattern = new JCheckBox(ResMsgCecilia.getString("PREFS_DESK_PATTERN"));
        this._ctrlPattern.setSelected(this._filePattern);
        this._ctrlPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopPreferencies.this._filePattern = DesktopPreferencies.this._ctrlPattern.isSelected();
            }
        });
        this._ctrlRed = new JIntegerTextField(Integer.toString(this._colorR), 0, 255);
        this._ctrlRed.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DesktopPreferencies.this._colorR = DesktopPreferencies.this.parseColor(DesktopPreferencies.this._ctrlRed.getText(), DesktopPreferencies.this._colorR);
            }
        });
        this._ctrlGreen = new JIntegerTextField(Integer.toString(this._colorG), 0, 255);
        this._ctrlGreen.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DesktopPreferencies.this._colorG = DesktopPreferencies.this.parseColor(DesktopPreferencies.this._ctrlGreen.getText(), DesktopPreferencies.this._colorG);
            }
        });
        this._ctrlBlue = new JIntegerTextField(Integer.toString(this._colorB), 0, 255);
        this._ctrlBlue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DesktopPreferencies.this._colorB = DesktopPreferencies.this.parseColor(DesktopPreferencies.this._ctrlBlue.getText(), DesktopPreferencies.this._colorB);
            }
        });
        int idx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ResMsgCecilia.getString("PREFS_DESK_COLOR")), new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgCecilia.getString("PREFS_DESK_COLOR_R")), new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlRed, new GridBagConstraints(idx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgCecilia.getString("PREFS_DESK_COLOR_G")), new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlGreen, new GridBagConstraints(idx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgCecilia.getString("PREFS_DESK_COLOR_B")), new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlBlue, new GridBagConstraints(idx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgCecilia.getString("PREFS_DESK_IMAG")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlImag, new GridBagConstraints(1, 1, idx - 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlPattern, new GridBagConstraints(idx, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgCecilia.getString("PREFS_DESK_BACKGROUND")));
        return panel;
    }

    private int parseColor(String text, int oldValue) {
        try {
            int value = Integer.parseInt(this._ctrlRed.getText());
            if (value >= 0 && value <= 255) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return oldValue;
    }

    protected void loadBackground(Plugable launcher) {
        String value = PlugableUtility.getStrOpt(launcher, PREF_IMAG_KEY, BACKGROUND_NONE);
        this._predefine = null;
        for (BackgroundPredefine select : BackgroundPredefine.values()) {
            if (!select.getKey().equals(value)) continue;
            this._predefine = select;
            break;
        }
        if (this._predefine == null) {
            this._predefine = BackgroundPredefine.NONE;
        }
        if (this._ctrlImag != null) {
            this._ctrlImag.setSelectedItem((Object)this._predefine);
        }
        this._colorR = PlugableUtility.getIntOpt(launcher, PREF_COLOR_R, 192);
        if (this._colorR < 0) {
            this._colorR = 0;
        }
        if (this._colorR > 255) {
            this._colorR = 255;
        }
        if (this._ctrlRed != null) {
            this._ctrlRed.setText(Integer.toString(this._colorR));
        }
        this._colorG = PlugableUtility.getIntOpt(launcher, PREF_COLOR_G, 192);
        if (this._colorG < 0) {
            this._colorG = 0;
        }
        if (this._colorG > 255) {
            this._colorG = 255;
        }
        if (this._ctrlGreen != null) {
            this._ctrlGreen.setText(Integer.toString(this._colorG));
        }
        this._colorB = PlugableUtility.getIntOpt(launcher, PREF_COLOR_B, 192);
        if (this._colorB < 0) {
            this._colorB = 0;
        }
        if (this._colorB > 255) {
            this._colorB = 255;
        }
        if (this._ctrlBlue != null) {
            this._ctrlBlue.setText(Integer.toString(this._colorB));
        }
    }

    protected void saveBackground(Plugable launcher) {
        launcher.setOption(PREF_COLOR_R, Integer.toString(this._colorR));
        launcher.setOption(PREF_COLOR_G, Integer.toString(this._colorG));
        launcher.setOption(PREF_COLOR_B, Integer.toString(this._colorB));
        launcher.setOption(PREF_IMAG_PATTERN, Boolean.toString(this._filePattern));
        launcher.setOption(PREF_IMAG_KEY, this._predefine.getKey());
    }

    public Color getColorBackground() {
        return new Color(this._colorR, this._colorG, this._colorB);
    }

    public String getKeyPattern() {
        return this._predefine.getKey();
    }

    public boolean isPattern() {
        return this._filePattern;
    }

    private static enum BackgroundPredefine {
        NONE("NONE", ResMsgVoc.getString("VOC_NONE")),
        GRANIT("BACKGROUND_GRANIT", ResMsgCecilia.getString("PREFS_DESK_BG_GRANIT")),
        GOUTTES("BACKGROUND_GOUTTES", ResMsgCecilia.getString("PREFS_DESK_BG_GOUTTES")),
        CUIR("BACKGROUND_CUIR", ResMsgCecilia.getString("PREFS_DESK_BG_CUIR")),
        CREPI("BACKGROUND_CREPI", ResMsgCecilia.getString("PREFS_DESK_BG_CREPI")),
        NUAGE1("BACKGROUND_NUAGES1", ResMsgCecilia.getString("PREFS_DESK_BG_NUAGE1")),
        NUAGE2("BACKGROUND_NUAGES2", ResMsgCecilia.getString("PREFS_DESK_BG_NUAGE2")),
        BLEU("BACKGROUND_BLEU", ResMsgCecilia.getString("PREFS_DESK_BG_BLEU")),
        MARBRE("BACKGROUND_MARBRE", ResMsgCecilia.getString("PREFS_DESK_BG_MARBRE"));

        String _key;
        String _label;

        public String getKey() {
            return this._key;
        }

        public String getLbl() {
            return this._label;
        }

        private BackgroundPredefine(String key, String lbl) {
            this._key = key;
            this._label = lbl;
        }
    }
}

