/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaPlugable;
import com.dassault.cecilia.main.cecilia.ResIcoCecilia;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class DlgPreferencies
extends JDialogCecilia {
    private static Logger _LOG = Logger.getLogger(DlgPreferencies.class.getPackage().getName());
    CeciliaAppl _application;
    Preferencies _prefs;
    CeciliaPlugable _plugable;
    private boolean _firstVisible = true;
    JTree _ctrlTree;
    Preferencies.Item _itemSelected;
    JPanelWithFixMinimumSize _ctrlCard;
    CardLayout _layoutCard;
    JSplitPane _split;
    protected JPopupMenu _utilityMenu;
    protected JButton _utilityButton;
    protected JFileChooser _utilityFileChooser;
    protected FileFilterExtention _utilityFileFilter;

    public DlgPreferencies(Window owner, CeciliaAppl application) throws HeadlessException {
        super(owner, ResMsgVoc.getString("VOC_PREFERENCES"), true);
        this._application = application;
        this._prefs = application.getPreferencies();
        this._plugable = application.getPlugable();
        this.make();
        this.pack();
        this.setDefaultCloseOperation(1);
        this._split.setDividerLocation(0.33);
        this.setSize(new Dimension(800, 600));
        this._ctrlCard.setFixMinimumSize(new Dimension(this._ctrlCard.getSize()));
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this._firstVisible) {
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getOwner()));
            this._firstVisible = false;
        }
        super.setVisible(b);
    }

    private void make() {
        Object lastPathComponent;
        this.init();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DlgPreferencies.this.doClose();
            }
        });
        this._ctrlTree = new JTree(this._prefs);
        this._ctrlTree.getSelectionModel().setSelectionMode(1);
        this._ctrlTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath tpath = e.getPath();
                if (tpath == null) {
                    return;
                }
                Object lastPathComponent = tpath.getLastPathComponent();
                if (lastPathComponent instanceof Preferencies.Item) {
                    Preferencies.Item item = (Preferencies.Item)lastPathComponent;
                    if (DlgPreferencies.this._itemSelected != null && DlgPreferencies.this._itemSelected != item) {
                        if (DlgPreferencies.this._itemSelected.getPlug() == null) {
                            if (!DlgPreferencies.this._itemSelected.getKey().equals("<root>")) {
                                _LOG.fine("Selection d'un noeud d'arborescence de preference sans Plugin : " + DlgPreferencies.this._itemSelected.getKey());
                            }
                        } else {
                            DlgPreferencies.this._itemSelected.getPlug().validOptions(DlgPreferencies.this._plugable);
                        }
                    }
                    DlgPreferencies.this._itemSelected = item;
                    if (item.withPanel()) {
                        DlgPreferencies.this._layoutCard.show(DlgPreferencies.this._ctrlCard, item.getKey());
                    }
                }
            }
        });
        DefaultTreeCellRenderer myRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
                Preferencies.Item item = (Preferencies.Item)value;
                this.setText(item.getLabel());
                this.setToolTipText(item.getDescription());
                Icon icon = item.getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
                return this;
            }
        };
        myRenderer.setLeafIcon(ResIcoCecilia.getImageIcon("TARGET_VALUE"));
        myRenderer.setClosedIcon(ResIcoCore.getImageIcon("FOLDER_DEFAULT_C"));
        myRenderer.setOpenIcon(ResIcoCore.getImageIcon("FOLDER_DEFAULT_O"));
        this._ctrlTree.setCellRenderer(myRenderer);
        this._ctrlTree.setRootVisible(true);
        this._ctrlTree.setRowHeight(ResIcoAbstract.getIconSize());
        JPanel west = new JPanel(new BorderLayout());
        west.add(new JScrollPane(this._ctrlTree));
        west.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._layoutCard = new CardLayout();
        this._ctrlCard = new JPanelWithFixMinimumSize(this._layoutCard);
        this.updatePreferencePanels();
        this._prefs.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                DlgPreferencies.this._ctrlCard.removeAll();
                DlgPreferencies.this.updatePreferencePanels();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }
        });
        this._split = new JSplitPane(1, west, this._ctrlCard);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._split, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.createButPanelSaveAndClose(), "Center");
        southPanel.add(this.createButUtility(), "East");
        this.getContentPane().add((Component)southPanel, "South");
        this._ctrlTree.setSelectionRow(1);
        TreePath tpath = this._ctrlTree.getSelectionPath();
        if (tpath != null && (lastPathComponent = tpath.getLastPathComponent()) instanceof Preferencies.Item) {
            this._itemSelected = (Preferencies.Item)lastPathComponent;
        }
    }

    private void updatePreferencePanel(Preferencies.Item item, PlugPanel plug) {
        if (plug == null) {
            return;
        }
        Component panel = plug.getPanel();
        if (panel == null) {
            return;
        }
        this._ctrlCard.add((Component)new DefaultPrefPanel(panel, item.getTitle()), item.getKey());
    }

    private void updatePreferencePanels() {
        Preferencies.Item root = this._prefs.getRoot();
        this.updatePreferencePanel(root, root.getPanel(this._plugable));
        for (Preferencies.Item item : this._prefs.getAllItems()) {
            PlugPanel plug = item.getPanel(this._plugable);
            this.updatePreferencePanel(item, plug);
        }
    }

    public void refreshPanels() {
        for (Preferencies.Item item : this._prefs.getAllItems()) {
            item.getPanel(this._plugable);
        }
    }

    private JComponent createButPanelSaveAndClose() {
        Insets insetsPanel = new Insets(7, 10, 7, 10);
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new GridBagLayout());
        JPanel fPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        fPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JButton butSave = new JButton();
        AbstractAction actSave = new AbstractAction(ResMsgVoc.getString("VOC_SAVE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgPreferencies.this._itemSelected != null) {
                    if (DlgPreferencies.this._itemSelected.getPlug() == null) {
                        _LOG.fine("Impossible de sauvegarder des preferences sans Plugin : " + DlgPreferencies.this._itemSelected.getKey());
                    } else {
                        DlgPreferencies.this._itemSelected.getPlug().validOptions(DlgPreferencies.this._plugable);
                    }
                }
                if (!DlgPreferencies.this._application.savePreferencies()) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(butSave), ResMsgCecilia.getString("MSG_PREFERENCIES_ERR_SAVE"), ResMsgVoc.getString("VOC_PREFERENCES"), 0);
                }
            }
        };
        butSave.setAction(actSave);
        if (!this._application.isReader()) {
            fPanel.add(butSave);
        }
        final JButton butClose = new JButton();
        AbstractAction actClose = new AbstractAction(ResMsgVoc.getString("VOC_CLOSE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                butClose.requestFocus();
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!butClose.hasFocus()) {
                    return;
                }
                DlgPreferencies.this.setVisible(false);
                DlgPreferencies.this.doClose();
            }
        };
        butClose.setAction(actClose);
        fPanel.add(butClose);
        this.putAction("CECILIA_ENTER", actClose);
        this.putAction("CECILIA_CANCEL", actClose);
        resultPanel.add((Component)fPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, insetsPanel, 0, 0));
        return resultPanel;
    }

    private void doClose() {
        this._application.getPreferencies().incRefresh();
    }

    private Component createButUtility() {
        this._utilityFileChooser = new JFileChooser();
        this._utilityFileChooser.setCurrentDirectory(new File(FileUtility.getBasePath(DlgPreferencies.class)));
        this._utilityFileFilter = new FileFilterExtention("Preferences file (*.xml)", ".xml");
        this._utilityFileChooser.addChoosableFileFilter(this._utilityFileFilter);
        this._utilityFileChooser.setFileFilter(this._utilityFileFilter);
        this._utilityMenu = new JPopupMenu();
        AbstractAction action = new AbstractAction(ResMsgCecilia.getString("OPT_MENU_SAVE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgPreferencies.this._utilityFileChooser.showSaveDialog(DlgPreferencies.this._utilityButton) != 0) {
                    return;
                }
                File file = DlgPreferencies.this._utilityFileChooser.getSelectedFile();
                if (!FileUtility.verifyPath((String)(file = DlgPreferencies.this._utilityFileFilter.addDefaultExtention(file)).getAbsolutePath(), (boolean)true, (Component)DlgPreferencies.this._utilityButton, (String)ResMsgCecilia.getString("OPT_MENU_SAVE"))) {
                    return;
                }
                try {
                    BufferedWriter w = new BufferedWriter(new FileWriter(file));
                    w.append("<?xml version='1.0'?>\n");
                    DlgPreferencies.this._plugable.savePreferencies(w, "");
                    w.close();
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(DlgPreferencies.this._utilityButton), exc.getMessage(), ResMsgCecilia.getString("OPT_MENU_SAVE"), 0);
                }
            }
        };
        this._utilityMenu.add(action);
        action = new AbstractAction(ResMsgCecilia.getString("OPT_MENU_LOAD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgPreferencies.this._utilityFileChooser.showOpenDialog(DlgPreferencies.this._utilityButton) != 0) {
                    return;
                }
                File file = DlgPreferencies.this._utilityFileChooser.getSelectedFile();
                if (!FileUtility.verifyPath((String)file.getAbsolutePath(), (boolean)false, (Component)DlgPreferencies.this._utilityButton, (String)ResMsgCecilia.getString("OPT_MENU_LOAD"))) {
                    return;
                }
                try {
                    BufferedReader r = new BufferedReader(new FileReader(file));
                    DlgPreferencies.this._plugable.loadPreferencies(r);
                    r.close();
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(DlgPreferencies.this._utilityButton), exc.getMessage(), ResMsgCecilia.getString("OPT_MENU_LOAD"), 0);
                    return;
                }
                DlgPreferencies.this.refreshPanels();
            }
        };
        this._utilityMenu.add(action);
        if (this._application.isDebugMode()) {
            action = new AbstractAction(ResMsgCecilia.getString("OPT_MENU_CLEAR")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgPreferencies.this._plugable.clearPreferencies();
                    DlgPreferencies.this.refreshPanels();
                }
            };
            this._utilityMenu.add(action);
        }
        this._utilityButton = new JButton(ResIcoCore.getImageIcon("BUT_SAVE"));
        this._utilityButton.setToolTipText(ResMsgCecilia.getString("OPT_MENU_TOOLTIP"));
        this._utilityButton.setPreferredSize(new Dimension(25, 25));
        this._utilityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle butRect = DlgPreferencies.this._utilityButton.getBounds();
                JPopupMenu menu = DlgPreferencies.this._utilityMenu;
                Dimension menSize = menu.getPreferredSize();
                menu.show(DlgPreferencies.this._utilityButton, butRect.width - menSize.width, -menSize.height);
            }
        });
        JPanel panel = new JPanel();
        panel.add(this._utilityButton);
        return panel;
    }

    static class JPanelWithFixMinimumSize
    extends JPanel {
        Dimension _fixMinimumSize = null;

        JPanelWithFixMinimumSize(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getMinimumSize() {
            if (this._fixMinimumSize != null) {
                return this._fixMinimumSize;
            }
            return super.getMinimumSize();
        }

        public void setFixMinimumSize(Dimension size) {
            this._fixMinimumSize = size;
        }
    }

    static class DefaultPrefPanel
    extends JPanel {
        JLabel _bandeau = new JLabel(new ImageIcon(ResIcoCecilia.getInstance().getImage("PREFBANDEAU", 500, 100)));
        JLabel _title = new JLabel("");

        DefaultPrefPanel(Component panelOpts, String title) {
            super(new GridBagLayout());
            this._title.setFont(new Font(this._title.getFont().getFamily(), 1, 14));
            this._title.setText(title);
            JScrollPane panel = null;
            panel = panelOpts instanceof JScrollPane ? (JScrollPane)panelOpts : new JScrollPane(panelOpts);
            panel.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)this._bandeau, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._title, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
            this.add((Component)panel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
    }
}

