/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.OpenFolderList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OpenFoldersPanel
extends JPanel {
    static boolean __DEBUG = Boolean.getBoolean("cecilia.core.debug");
    OpenFolderList _source;
    DefaultListModel<OpenFolder> _modelList;
    JListOpenFolders _ctrlList;
    boolean _bChangeMasterFrame = true;

    public OpenFoldersPanel(OpenFolderList source) {
        super(new BorderLayout());
        this._source = source;
        this.add(this.makeFolderList(), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    protected Component makeFolderList() {
        this._modelList = new DefaultListModel();
        this._ctrlList = new JListOpenFolders((ListModel)this._modelList);
        final FolderRenderer delegateRenderer = new FolderRenderer(){

            @Override
            protected String convertFolderToText(DBFolder dbFolder) {
                if (dbFolder.isVersion()) {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append(dbFolder.getParent().getName()).append(";").append(dbFolder.getName());
                    return sb.toString();
                }
                return super.convertFolderToText(dbFolder);
            }
        };
        this._ctrlList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof OpenFolder) {
                    delegateRenderer.getListCellRendererComponent(list, ((OpenFolder)value).getDBFolder(), index, isSelected, cellHasFocus);
                    if (__DEBUG) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html><b>").append(delegateRenderer.getToolTipText()).append("</b><br/><ul>");
                        for (JInternalFrame iframe : ((OpenFolder)value).getFrames()) {
                            sb.append("<li>").append(iframe.getTitle());
                            sb.append(" [<i>").append(iframe.getClass().getName()).append("</i>]</li>");
                        }
                        sb.append("</ul></html>");
                        delegateRenderer.setToolTipText(sb.toString());
                    }
                    return delegateRenderer;
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this._source.addOpenFoldersListener(new OpenFolderList.OpenFoldersListener(){

            @Override
            public void listChanged(OpenFolderList.OpenFoldersEvent event) {
                switch (event.getAction()) {
                    case INSERT: {
                        OpenFoldersPanel.this._modelList.addElement(event.getFolder());
                        OpenFoldersPanel.this._ctrlList.setSelectedValue(event.getFolder(), true);
                        break;
                    }
                    case REMOVE: {
                        OpenFoldersPanel.this._modelList.removeElement(event.getFolder());
                        break;
                    }
                    case SELECT: {
                        try {
                            OpenFoldersPanel.this._bChangeMasterFrame = event.getSource() == null;
                            OpenFoldersPanel.this._ctrlList.setSelectedValue(event.getFolder(), true);
                            break;
                        }
                        finally {
                            OpenFoldersPanel.this._bChangeMasterFrame = true;
                        }
                    }
                    case REFRESH: {
                        OpenFoldersPanel.this._ctrlList.repaint();
                    }
                }
            }
        });
        this._ctrlList.setSelectionMode(0);
        this._ctrlList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                OpenFoldersPanel.this._source.setSelectedFolder((OpenFolder)OpenFoldersPanel.this._ctrlList.getSelectedValue(), OpenFoldersPanel.this._bChangeMasterFrame);
            }
        });
        return new JScrollPane(this._ctrlList);
    }

    private static final class JListOpenFolders
    extends JList
    implements JTableTransfertHandler.HelperConvert {
        public JListOpenFolders(ListModel listModel) {
            super(listModel);
            this.setTransferHandler(new JTableTransfertHandler.JListTransferHandler());
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj == null) {
                return "";
            }
            if (obj instanceof OpenFolder) {
                OpenFolder opFolder = (OpenFolder)obj;
                return opFolder.getDBFolder().getRefPath();
            }
            return "";
        }
    }
}

