/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.export.docbook;

import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.UtilityPluginProcess;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.export.docbook.ParamsDocBook;
import com.dassault.cecilia.plugin.export.docbook.ResDocBook;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PluginDocbook
extends AbstractPluginModel
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginDocbook.class.getPackage().getName());
    public static final String OPT_TYPE = "PluginDocBook.Type";
    public static final String OPT_OPERATOR = "PluginDocBook.Operator";
    public static final String OPT_COMPONENT = "PluginDocBook.Component";
    public static final String OPT_EQUIPMENT = "PluginDocBook.Equipment";
    public static final String OPT_IMAGE = "PluginDocBook.Image";
    IOptsPanel _opts = null;

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new IOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    @Override
    public boolean withParameters() {
        return true;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return "";
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        ParamsDocBook clone = new ParamsDocBook((String)parameters);
        if (clone.change(parent)) {
            return clone.getPluginKey();
        }
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        return DefaultIOParameters.getInstance();
    }

    @Override
    public void createSession(Plugable launcher, Object parameters) {
        IModel model = launcher.getModel("docbook.file");
        if (model == null) {
            return;
        }
        if (parameters == null) {
            return;
        }
        if (!(parameters instanceof String)) {
            _LOG.warning("Parameters of DocBook plugin is not String");
            return;
        }
        String param = (String)parameters;
        if (param.length() == 0) {
            return;
        }
        PluginModel plugin = launcher.getPlugin(param);
        if (plugin == null || !(plugin instanceof PluginMProcess)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResDocBook.getString("ERR_DEPEND_PLUGIN") + "\n   [" + param + "]");
            return;
        }
        BanEntry ban = null;
        try {
            ban = new BanEntry();
        }
        catch (BanLicenseException e) {
            _LOG.log(Level.WARNING, "No licence ban", e);
            return;
        }
        File logFile = this.createFile(launcher, "DocBook", ".log");
        if (logFile == null) {
            return;
        }
        UtilityDocBookProcess util = new UtilityDocBookProcess((PluginMProcess)plugin, model.getFile());
        BanInputStream script = util.createBanScript(launcher, "DocBook", util.getEmptyBanScript(), logFile);
        if (script == null) {
            return;
        }
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, ban, script, logFile){

            @Override
            protected String getDesc() {
                return PluginDocbook.this.getInfo("plugin.name");
            }

            @Override
            protected String getName() {
                return "DocBook";
            }

            @Override
            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-01.svg"));
                }
                return PluginDocbook.this.getIcon(key);
            }
        };
        launcher.addTask(task, model.getUID());
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResDocBook.getString("PLUG_DOCBOOK_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResDocBook.getString("PLUG_DOCBOOK_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "params";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "alt D";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-01.svg"));
        }
        return super.getIcon(key);
    }

    class IOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JCheckBox _ctrlType;
        JCheckBox _ctrlOp;
        JCheckBox _ctrlComp;
        JCheckBox _ctrlEquip;
        JCheckBox _ctrlImag;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlType.setSelected(PlugableUtility.getBoolOpt(this._launcher, PluginDocbook.OPT_TYPE, true));
            this._ctrlOp.setSelected(PlugableUtility.getBoolOpt(this._launcher, PluginDocbook.OPT_OPERATOR, true));
            this._ctrlComp.setSelected(PlugableUtility.getBoolOpt(this._launcher, PluginDocbook.OPT_COMPONENT, true));
            this._ctrlEquip.setSelected(PlugableUtility.getBoolOpt(this._launcher, PluginDocbook.OPT_EQUIPMENT, true));
            this._ctrlImag.setSelected(PlugableUtility.getBoolOpt(this._launcher, PluginDocbook.OPT_IMAGE, true));
        }

        private JCheckBox createCheckBox(String keyLbl, final String keyOpt) {
            final JCheckBox cb = new JCheckBox(ResDocBook.getString(keyLbl));
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IOptsPanel.this._launcher.setOption(keyOpt, cb.isSelected() ? "true" : "false");
                }
            });
            return cb;
        }

        public IOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel opts = new JPanel(new GridBagLayout());
            opts.setBorder(BorderFactory.createTitledBorder(ResDocBook.getString("OPTIONS")));
            this._ctrlType = this.createCheckBox("OPT_TYPE", PluginDocbook.OPT_TYPE);
            opts.add((Component)this._ctrlType, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            this._ctrlOp = this.createCheckBox("OPT_OPERATOR", PluginDocbook.OPT_OPERATOR);
            opts.add((Component)this._ctrlOp, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            this._ctrlComp = this.createCheckBox("OPT_COMPONENT", PluginDocbook.OPT_COMPONENT);
            opts.add((Component)this._ctrlComp, new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            this._ctrlEquip = this.createCheckBox("OPT_EQUIPMENT", PluginDocbook.OPT_EQUIPMENT);
            opts.add((Component)this._ctrlEquip, new GridBagConstraints(0, 3, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            this._ctrlImag = this.createCheckBox("OPT_IMAGE", PluginDocbook.OPT_IMAGE);
            opts.add((Component)this._ctrlImag, new GridBagConstraints(0, 4, 1, 1, 100.0, 100.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            JButton defVal = new JButton(ResDocBook.getString("DLG_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IOptsPanel.this._ctrlType.setSelected(true);
                    IOptsPanel.this._launcher.setOption(PluginDocbook.OPT_TYPE, "true");
                    IOptsPanel.this._ctrlOp.setSelected(true);
                    IOptsPanel.this._launcher.setOption(PluginDocbook.OPT_OPERATOR, "true");
                    IOptsPanel.this._ctrlComp.setSelected(true);
                    IOptsPanel.this._launcher.setOption(PluginDocbook.OPT_COMPONENT, "true");
                    IOptsPanel.this._ctrlEquip.setSelected(true);
                    IOptsPanel.this._launcher.setOption(PluginDocbook.OPT_EQUIPMENT, "true");
                    IOptsPanel.this._ctrlImag.setSelected(true);
                    IOptsPanel.this._launcher.setOption(PluginDocbook.OPT_IMAGE, "true");
                }
            });
            opts.add((Component)defVal, new GridBagConstraints(0, 5, 1, 1, 100.0, 100.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
            this.add((Component)opts, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public Component getPanel() {
            return this;
        }

        @Override
        public void trash() {
        }

        @Override
        public String getInfo(String key) {
            return PluginDocbook.this.getInfo(key);
        }

        @Override
        public Icon getIcon(String key) {
            return null;
        }
    }

    class UtilityDocBookProcess
    extends UtilityPluginProcess {
        PluginMProcess _process;

        UtilityDocBookProcess(PluginMProcess process, File resFile) {
            super(resFile);
            this._process = process;
        }

        @Override
        protected PluginMProcess getPostProcess(Plugable launcher) {
            return this._process;
        }

        @Override
        protected File createFile(Plugable launcher, String base, String ext) {
            return PluginDocbook.this.createFile(launcher, base, ext);
        }

        @Override
        protected String getTitle() {
            return PluginDocbook.this.getInfo("plugin.name");
        }
    }
}

