/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.export.wordxml;

import com.dassault.cecilia.plugin.export.wordxml.Base64;
import com.dassault.cecilia.plugin.export.wordxml.Border;
import com.dassault.cecilia.plugin.export.wordxml.DrawImgXml;
import com.dassault.cecilia.plugin.export.wordxml.ResWordXml;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParseurWord {
    protected File _filePathImage;
    public BufferedWriter _outputFile;
    public int _indPict = 1;
    public int _pageOrientation = 1;
    public String _pageFormat = "A4";
    private static Map<File, File> _LOCAL_FILES = new HashMap<File, File>();
    private static Object _LOCK_FILES = new Object();

    public static String formatStringForXml(String str) {
        StringBuffer finalStr = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '&') {
                finalStr.append("&amp;");
                continue;
            }
            if (c == '<') {
                finalStr.append("&lt;");
                continue;
            }
            if (c == '>') {
                finalStr.append("&gt;");
                continue;
            }
            if (c == '\"') {
                finalStr.append("&quot;");
                continue;
            }
            if (c == '\t') {
                finalStr.append("&#9;");
                continue;
            }
            finalStr.append(c);
        }
        return finalStr.toString();
    }

    protected Document checkXml(InputStream iStream) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(iStream);
        }
        catch (SAXParseException spe) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId(), spe);
            if (spe.getException() != null) {
                ResWordXml.LOG.log(Level.WARNING, " => package error", spe.getException());
            }
            return null;
        }
        catch (SAXException sxe) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - SAXException", sxe);
            if (sxe.getException() != null) {
                ResWordXml.LOG.log(Level.WARNING, " => package error", sxe.getException());
            }
            return null;
        }
        catch (ParserConfigurationException pce) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - ParserConfigurationException", pce);
            return null;
        }
        catch (IOException ioe) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - IOException", ioe);
            return null;
        }
        catch (Exception e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - Exception", e);
            return null;
        }
        return document;
    }

    protected void parse(File file) {
        Document document = null;
        try {
            document = this.checkXml(new FileInputStream(file));
            if (document != null) {
                this.parseXml(document);
            }
        }
        catch (FileNotFoundException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - FileNotFoundException", e);
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordWML - IOException", e);
        }
    }

    protected void parseXml(Document document) throws IOException {
        Node root = document.getLastChild();
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            NamedNodeMap attributs;
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("TITRE_CENTRE")) {
                attributs = node.getAttributes();
                if (attributs.getNamedItem("TEXTE") == null) continue;
                this.writeWithStyle("TitreCentre", attributs.getNamedItem("TEXTE").getNodeValue());
                continue;
            }
            if (node.getNodeName().equals("TITRE1")) {
                attributs = node.getAttributes();
                if (attributs.getNamedItem("TEXTE") == null) continue;
                this.writeWithStyle("Titre1", attributs.getNamedItem("TEXTE").getNodeValue());
                continue;
            }
            if (node.getNodeName().equals("LISTE_PUCE1")) {
                attributs = node.getAttributes();
                String label = "";
                String texte = "";
                if (attributs.getNamedItem("LABEL") != null) {
                    label = attributs.getNamedItem("LABEL").getNodeValue();
                }
                if (attributs.getNamedItem("TEXTE") != null) {
                    texte = attributs.getNamedItem("TEXTE").getNodeValue();
                }
                this.writePuce1(label, texte);
                continue;
            }
            if (node.getNodeName().equals("TEXTE_NORMAL")) {
                attributs = node.getAttributes();
                if (attributs.getNamedItem("TEXTE") == null) continue;
                this.writeTexteNormal(attributs.getNamedItem("TEXTE").getNodeValue());
                continue;
            }
            if (node.getNodeName().equals("SAUT_DE_LIGNE")) {
                this.writeSautDeLigne();
                continue;
            }
            if (node.getNodeName().equals("SAUT_DE_PAGE")) {
                this.writeSautDePage();
                continue;
            }
            if (node.getNodeName().equals("TABLEAU")) {
                this.writeArray(node);
                continue;
            }
            if (!node.getNodeName().equals("IMAGE")) continue;
            DrawImgXml img = new DrawImgXml();
            NamedNodeMap attributs2 = node.getAttributes();
            if (attributs2.getNamedItem("URL") != null) {
                img.setUrl(attributs2.getNamedItem("URL").getNodeValue());
            }
            if (attributs2.getNamedItem("LARGEUR") != null) {
                img.setWidth(Integer.parseInt(attributs2.getNamedItem("LARGEUR").getNodeValue()));
            }
            if (attributs2.getNamedItem("HAUTEUR") != null) {
                img.setHeight(Integer.parseInt(attributs2.getNamedItem("HAUTEUR").getNodeValue()));
            }
            for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                Node childNode = node.getChildNodes().item(j);
                if (!childNode.getNodeName().equals("SECTION")) continue;
                img._newSection = true;
                NamedNodeMap childAttributs = childNode.getAttributes();
                if (childAttributs.getNamedItem("FORMAT") != null) {
                    img._pageFormat = childAttributs.getNamedItem("FORMAT").getNodeValue();
                }
                if (childAttributs.getNamedItem("ORIENTATION") == null) continue;
                img._pageOrientation = childAttributs.getNamedItem("ORIENTATION").getNodeValue();
            }
            this.drawPicture(System.getProperty("DataPath") + "/from_word2003/", img, this._indPict++, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildXml(File dataPath, File inputFile, File outputFile, File filePathImage) {
        if (ResWordXml.LOG.isLoggable(Level.FINER)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("WordXML - buildXml(dataPath='").append(dataPath.getAbsolutePath()).append("'");
            buffer.append(", inputFile='").append(inputFile).append("'");
            buffer.append(", outputFile='").append(outputFile).append("')");
            ResWordXml.LOG.finer(buffer.toString());
        }
        File modelFile = null;
        Object object = _LOCK_FILES;
        synchronized (object) {
            modelFile = _LOCAL_FILES.get(dataPath);
            if (modelFile != null) {
                if (!modelFile.exists()) {
                    modelFile = null;
                } else if (!modelFile.isFile()) {
                    modelFile = null;
                } else if (!modelFile.canRead() || modelFile.length() == 0L) {
                    if (!modelFile.delete()) {
                        ResWordXml.LOG.info("Impossible de supprimer un fichier vide ou sans acces pour le repertoire :" + dataPath);
                    }
                    modelFile = null;
                }
                if (modelFile == null) {
                    ResWordXml.LOG.info("Impossible de supprimer un fichier vide ou sans acces pour le repertoire :" + dataPath);
                    _LOCAL_FILES.remove(dataPath);
                }
            }
            if (modelFile == null) {
                try {
                    File tmpFile = File.createTempFile("Model", ".xml");
                    tmpFile.deleteOnExit();
                    FileOutputStream fos = null;
                    FileInputStream fis = null;
                    try {
                        fos = new FileOutputStream(tmpFile);
                        fis = new FileInputStream(new File(dataPath, "model.xml"));
                        FileChannel channelSrc = fis.getChannel();
                        FileChannel channelDest = fos.getChannel();
                        channelSrc.transferTo(0L, channelSrc.size(), channelDest);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    modelFile = tmpFile;
                }
                catch (Exception exc) {
                    ResWordXml.LOG.log(Level.WARNING, "WordXML - prepare Local file", exc);
                }
                if (modelFile != null) {
                    _LOCAL_FILES.put(dataPath, modelFile);
                }
            }
            if (modelFile == null) {
                modelFile = new File(dataPath, "model.xml");
            }
        }
        this.doBuildXml(modelFile, inputFile, outputFile, filePathImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBuildXml(File modelFile, File inputFile, File outputFile, File filePathImage) {
        this._outputFile = null;
        FileOutputStream fos = null;
        try {
            this._filePathImage = filePathImage;
            fos = new FileOutputStream(outputFile);
            try (Object fis = null;){
                fis = new FileInputStream(modelFile);
                FileChannel channelSrc = ((FileInputStream)fis).getChannel();
                FileChannel channelDest = fos.getChannel();
                channelSrc.transferTo(0L, channelSrc.size(), channelDest);
            }
            this._outputFile = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            this._outputFile.write("\n");
            this._outputFile.write("<w:body><wx:sect>\n");
            ResWordXml.LOG.finer("WordXML - buildXml - Start parsing XML");
            this.parse(inputFile);
            ResWordXml.LOG.finer("WordXML - buildXml - End parsing XML");
            if (this._pageOrientation == 0) {
                switch (this._pageFormat) {
                    default: {
                        this.writePageDefine(16838, 11906, true, -1);
                        break;
                    }
                    case "A3": {
                        this.writePageDefine(23814, 16839, true, -1);
                        break;
                    }
                    case "LETTER": {
                        this.writePageDefine(15840, 12240, true, 1);
                        break;
                    }
                    case "B5": {
                        this.writePageDefine(14571, 10319, true, 13);
                        break;
                    }
                    case "B4": {
                        this.writePageDefine(20639, 14572, true, 12);
                        break;
                    }
                }
            } else {
                switch (this._pageFormat) {
                    default: {
                        this.writePageDefine(11906, 16838, false, -1);
                        break;
                    }
                    case "A3": {
                        this.writePageDefine(16839, 23814, false, -1);
                        break;
                    }
                    case "LETTER": {
                        this.writePageDefine(12240, 15840, false, 1);
                        break;
                    }
                    case "B5": {
                        this.writePageDefine(10319, 14571, false, 13);
                        break;
                    }
                    case "B4": {
                        this.writePageDefine(14572, 20639, false, 12);
                    }
                }
            }
            this._outputFile.write("</wx:sect>");
            this._outputFile.write("</w:body></w:wordDocument>\n");
            if (!inputFile.delete()) {
                inputFile.deleteOnExit();
            }
            if (this._filePathImage.isDirectory()) {
                File[] files = this._filePathImage.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    ResWordXml.LOG.finer("WordXML - delete file : " + files[i].toString());
                    if (files[i].delete()) continue;
                    files[i].deleteOnExit();
                }
                if (!this._filePathImage.delete()) {
                    this._filePathImage.deleteOnExit();
                }
            }
            ResWordXml.LOG.finer("WordXML - buildXml : fin de l'export ");
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordXML - buildXml : IOException", e);
        }
        finally {
            try {
                if (this._outputFile != null) {
                    this._outputFile.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                ResWordXml.LOG.log(Level.WARNING, "WordXML - buildXml : IOException during close", e);
            }
        }
    }

    public void writePageDefine(int w, int h, boolean landscape, int code) throws IOException {
        StringBuilder buffer = new StringBuilder(300);
        buffer.append("<w:sectPr><w:pgSz ");
        buffer.append("w:w=\"").append(w).append("\" ");
        buffer.append("w:h=\"").append(h).append("\" ");
        if (landscape) {
            buffer.append("w:orient=\"landscape\" ");
        }
        if (code >= 0) {
            buffer.append("w:code=\"").append(code).append("\" ");
        }
        buffer.append(" />");
        buffer.append("  <w:pgMar w:top=\"1417\" w:right=\"1417\" w:bottom=\"1417\" w:left=\"1417\" w:header=\"708\" w:footer=\"708\" w:gutter=\"0\" />");
        buffer.append("  <w:cols w:space=\"708\" />");
        buffer.append("  <w:docGrid w:line-pitch=\"360\" />");
        buffer.append("</w:sectPr>");
        this._outputFile.write(buffer.toString());
    }

    public void writeWithStyle(String style, String texte) throws IOException {
        this._outputFile.write("<w:p>");
        this._outputFile.write("<w:pPr><w:pStyle w:val=\"" + style + "\"/></w:pPr>");
        this._outputFile.write("<w:r><w:t>");
        this._outputFile.write(ParseurWord.formatStringForXml(texte));
        this._outputFile.write("</w:t></w:r>");
        this._outputFile.write("</w:p>\n");
    }

    public void writeTexteNormal(String texte) throws IOException {
        this._outputFile.write("<w:p><w:r><w:t>");
        this._outputFile.write(ParseurWord.formatStringForXml(texte));
        this._outputFile.write("</w:t></w:r></w:p>\n");
    }

    public void writeTexteCorps(String texte, String att) throws IOException {
        boolean previousIsText = false;
        StringTokenizer t = new StringTokenizer(texte, "\n", true);
        while (t.hasMoreElements()) {
            String str = t.nextToken();
            if (str.equals("\n")) {
                if (!previousIsText) {
                    this.writeSautDeLigne();
                    continue;
                }
                previousIsText = false;
                continue;
            }
            previousIsText = true;
            this._outputFile.write("<w:p>");
            this._outputFile.write("<w:pPr><w:pStyle w:val=\"Corps\"/>");
            this._outputFile.write(this.transcodeEmphasis(att) + "</w:pPr>");
            this._outputFile.write("<w:r><w:t>");
            this._outputFile.write(ParseurWord.formatStringForXml(str));
            this._outputFile.write("</w:t></w:r></w:p>\n");
        }
    }

    public String transcodeEmphasis(String att) {
        switch (att) {
            case "bold": {
                return "<w:b />";
            }
            case "italic": {
                return "<w:i />";
            }
            case "strike": {
                return "<w:strike />";
            }
            case "underline": {
                return "<w:u w:val=\"single\" />";
            }
        }
        return "";
    }

    public void writeSautDeLigne() throws IOException {
        this._outputFile.write("<w:p><w:r><w:t></w:t></w:r></w:p>\n");
    }

    public void writeSautDePage() throws IOException {
        this._outputFile.write("<w:p><w:r><w:br w:type=\"page\"/></w:r></w:p>\n");
    }

    public void writePuce1(String label, String texte) throws IOException {
        this._outputFile.write("<w:p>\n  <w:pPr><w:pStyle w:val=\"Listepuces1\"/>  <w:listPr>    <wx:t wx:wTabBefore=\"705\" wx:wTabAfter=\"225\"/>    <wx:font wx:val=\"Symbol\"/>  </w:listPr>  </w:pPr>\n<w:r><w:t>" + ParseurWord.formatStringForXml(label) + "</w:t></w:r>\n");
        if (!texte.isEmpty()) {
            this._outputFile.write("<w:r><w:tab wx:wTab=\"690\" wx:tlc=\"none\" wx:cTlc=\"8\"/>  <w:t> : </w:t></w:r>\n<w:r><w:tab wx:wTab=\"210\" wx:tlc=\"none\" wx:cTlc=\"2\"/>  <w:t>" + ParseurWord.formatStringForXml(texte) + "</w:t></w:r>\n");
        }
        this._outputFile.write("</w:p>\n");
    }

    public void writeArray(Node root) throws IOException {
        int nbCol = 0;
        NamedNodeMap attributs = root.getAttributes();
        if (attributs.getNamedItem("NB_COL") != null) {
            nbCol = Integer.parseInt(attributs.getNamedItem("NB_COL").getNodeValue());
        }
        this.writeArrayBegin();
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("TITRE_TAB")) {
                this.writeTitleTab(node, nbCol);
            }
            if (!node.getNodeName().equals("LIGNE")) continue;
            this.writeRow(node);
        }
        this.writeArrayEnd();
        this.writeSautDeLigne();
    }

    public void writeArrayBegin() throws IOException {
        this._outputFile.write("<w:tbl>\n  <w:tblPr>\n    <w:tblW w:w=\"0\" w:type=\"auto\"/>\n    <w:tblBorders>\n      <w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\" />\n      <w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\" />\n      <w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\" />\n      <w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\" />\n      <w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\" />\n      <w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\" />\n    </w:tblBorders>\n    <w:tblLook w:val=\"01E0\"/>\n  </w:tblPr>\n  <w:tblGrid>\n    <w:gridCol w:w=\"4606\"/>\n    <w:gridCol w:w=\"4606\"/>\n  </w:tblGrid>\n");
    }

    public void writeArrayEnd() throws IOException {
        this._outputFile.write("</w:tbl>\n");
    }

    public void writeTitleTab(Node root, int nbCol) throws IOException {
        String alg = "center";
        String titre = "";
        String color = "";
        boolean bold = false;
        boolean strike = false;
        boolean italic = false;
        boolean underline = false;
        NamedNodeMap attributs = root.getAttributes();
        if (attributs.getNamedItem("ALG") != null) {
            alg = this.getAlg(attributs.getNamedItem("ALG").getNodeValue());
        }
        if (attributs.getNamedItem("BOLD") != null) {
            bold = this.getBooleanAttribut(attributs, "BOLD");
        }
        if (attributs.getNamedItem("STRIKE") != null) {
            strike = this.getBooleanAttribut(attributs, "STRIKE");
        }
        if (attributs.getNamedItem("ITALIC") != null) {
            italic = this.getBooleanAttribut(attributs, "ITALIC");
        }
        if (attributs.getNamedItem("UNDERLINE") != null) {
            underline = this.getBooleanAttribut(attributs, "UNDERLINE");
        }
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("TEXTE_NORMAL")) {
                NamedNodeMap textAttributs = node.getAttributes();
                if (textAttributs.getNamedItem("TEXTE") == null) continue;
                titre = textAttributs.getNamedItem("TEXTE").getNodeValue();
                continue;
            }
            if (!node.getNodeName().equals("COLOR")) continue;
            NamedNodeMap colorAttributs = node.getAttributes();
            if (colorAttributs.getNamedItem("R") != null) {
                color = Integer.toHexString(Integer.parseInt(colorAttributs.getNamedItem("R").getNodeValue()));
            }
            if (colorAttributs.getNamedItem("V") != null) {
                color = color.concat(Integer.toHexString(Integer.parseInt(colorAttributs.getNamedItem("V").getNodeValue())));
            }
            if (colorAttributs.getNamedItem("B") == null) continue;
            color = color.concat(Integer.toHexString(Integer.parseInt(colorAttributs.getNamedItem("B").getNodeValue())));
        }
        this._outputFile.write("<w:tr><w:tc>  <w:tcPr><w:tcW w:w=\"9212\" w:type=\"dxa\"/><w:gridSpan w:val=\"" + nbCol + "\"/>");
        if (!color.isEmpty()) {
            this._outputFile.write("<w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"" + color + "\" />");
        }
        this._outputFile.write("</w:tcPr>\n");
        this._outputFile.write("<w:p>");
        if (bold | italic | strike | underline | !alg.equals("left")) {
            this._outputFile.write("<w:pPr>");
            if (!alg.equals("left")) {
                this._outputFile.write("<w:jc w:val=\"" + alg + "\"/>");
            }
            if (bold) {
                this._outputFile.write("<w:b />");
            }
            if (italic) {
                this._outputFile.write("<w:i />");
            }
            if (strike) {
                this._outputFile.write("<w:strike />");
            }
            if (underline) {
                this._outputFile.write("<w:u w:val=\"single\" />");
            }
            this._outputFile.write("</w:pPr>\n");
        }
        this._outputFile.write("<w:r><w:t>" + titre + "</w:t></w:r>");
        this._outputFile.write("</w:p></w:tc></w:tr>\n");
    }

    public void writeRow(Node root) throws IOException {
        this._outputFile.write("<w:tr>");
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (!node.getNodeName().equals("CELLULE")) continue;
            this.writeCell(node);
        }
        this._outputFile.write("</w:tr>\n");
    }

    public void writeCell(Node root) throws IOException {
        String alg = "left";
        String color = "";
        String texte = "";
        boolean bold = false;
        boolean strike = false;
        boolean underline = false;
        boolean italic = false;
        NamedNodeMap attributs = root.getAttributes();
        if (attributs.getNamedItem("ALG") != null) {
            alg = this.getAlg(attributs.getNamedItem("ALG").getNodeValue());
        }
        if (attributs.getNamedItem("BOLD") != null) {
            bold = this.getBooleanAttribut(attributs, "BOLD");
        }
        if (attributs.getNamedItem("STRIKE") != null) {
            strike = this.getBooleanAttribut(attributs, "STRIKE");
        }
        if (attributs.getNamedItem("ITALIC") != null) {
            italic = this.getBooleanAttribut(attributs, "ITALIC");
        }
        if (attributs.getNamedItem("UNDERLINE") != null) {
            underline = this.getBooleanAttribut(attributs, "UNDERLINE");
        }
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (node.getNodeName().equals("TEXTE_NORMAL")) {
                NamedNodeMap attributsN = node.getAttributes();
                if (attributsN.getNamedItem("TEXTE") == null) continue;
                texte = ParseurWord.formatStringForXml(attributsN.getNamedItem("TEXTE").getNodeValue());
                continue;
            }
            if (!node.getNodeName().equals("COLOR")) continue;
            NamedNodeMap colorAttributs = node.getAttributes();
            if (colorAttributs.getNamedItem("R") != null) {
                color = Integer.toHexString(Integer.parseInt(colorAttributs.getNamedItem("R").getNodeValue()));
            }
            if (colorAttributs.getNamedItem("V") != null) {
                color = color.concat(Integer.toHexString(Integer.parseInt(colorAttributs.getNamedItem("V").getNodeValue())));
            }
            if (colorAttributs.getNamedItem("B") == null) continue;
            color = color.concat(Integer.toHexString(Integer.parseInt(colorAttributs.getNamedItem("B").getNodeValue())));
        }
        this.drawCell(alg, color, texte, bold, strike, underline, italic, null);
    }

    public void drawCell(String alg, String color, String texte, boolean bold, boolean strike, boolean underline, boolean italic, Border border) throws IOException {
        this._outputFile.write("<w:tc><w:tcPr><w:tcW w:w=\"9216\" w:type=\"dxa\"/>");
        if (!color.equals("")) {
            this._outputFile.write("<w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"" + color + "\" />");
        }
        if (border != null) {
            boolean right;
            boolean top = !border._top.equals("single");
            boolean bottom = !border._bottom.equals("single");
            boolean left = !border._left.equals("single");
            boolean bl = right = !border._right.equals("single");
            if (top | bottom | left | right) {
                this._outputFile.write("<w:tcBorders>");
                if (top) {
                    this._outputFile.write("<w:top w:val=\"" + border._top + "\"/>");
                }
                if (left) {
                    this._outputFile.write("<w:left w:val=\"" + border._left + "\"/>");
                }
                if (bottom) {
                    this._outputFile.write("<w:bottom w:val=\"" + border._bottom + "\"/>");
                }
                if (right) {
                    this._outputFile.write("<w:right w:val=\"" + border._right + "\"/>");
                }
                this._outputFile.write("</w:tcBorders>");
            }
        }
        this._outputFile.write("</w:tcPr>");
        if (texte.isEmpty()) {
            this._outputFile.write("<w:p/>");
        } else if (texte.indexOf("\n") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(texte, "\n");
            if (tokenizer.hasMoreElements()) {
                while (tokenizer.hasMoreElements()) {
                    this.drawTextCell(alg, bold, strike, underline, italic, tokenizer.nextToken());
                }
            } else {
                this._outputFile.write("<w:p/>");
            }
        } else {
            this.drawTextCell(alg, bold, strike, underline, italic, texte);
        }
        this._outputFile.write("</w:tc>");
    }

    public void drawTextCell(String alg, boolean bold, boolean strike, boolean underline, boolean italic, String texte) throws IOException {
        this._outputFile.write("<w:p>");
        this._outputFile.write("<w:pPr>");
        this._outputFile.write("<w:pStyle w:val=\"Cellule\"/>");
        if (!alg.equals("left")) {
            this._outputFile.write("<w:jc w:val=\"" + alg + "\"/>");
        }
        if (bold) {
            this._outputFile.write("<w:b />");
        }
        if (italic) {
            this._outputFile.write("<w:i />");
        }
        if (strike) {
            this._outputFile.write("<w:strike />");
        }
        if (underline) {
            this._outputFile.write("<w:u w:val=\"single\" />");
        }
        this._outputFile.write("</w:pPr>");
        this._outputFile.write("<w:r><w:t>");
        this._outputFile.write(ParseurWord.formatStringForXml(texte));
        this._outputFile.write("</w:t></w:r></w:p>");
    }

    public void drawPicture(String path, DrawImgXml img, int indice, boolean inCell) {
        int width = img.getWidth();
        int height = img.getHeight();
        try {
            if (inCell && !img.getAlg().equals("")) {
                this._outputFile.write("<w:p><w:pPr><w:jc w:val=\"" + img.getAlg() + "\"/></w:pPr><w:r>");
            } else {
                this._outputFile.write("<w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr><w:r>");
            }
            this._outputFile.write("<w:pict>");
            if (indice == 1) {
                this.writeShapeType();
            }
            this._outputFile.write("<w:binData w:name=\"wordml://0200000" + indice + "." + img._format + "\"\n>");
            this._outputFile.write(this.coderImage(path + img.getUrl()));
            this._outputFile.write("</w:binData>\n");
            this._outputFile.write("<v:shape id=\"_x0000_i102" + indice + "4\" type=\"#_x0000_t75\" style=\"width:" + width + "pt;height:" + height + "pt\">");
            this._outputFile.write("<v:imagedata src=\"wordml://0200000" + indice + "." + img._format + "\" o:title=\"" + img.getUrl() + "\"/>");
            this._outputFile.write("</v:shape> </w:pict> </w:r></w:p>\n");
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordXML - drawPicture : IOException", e);
        }
    }

    public void writeShapeType() {
        try {
            this._outputFile.write("<v:shapetype id=\"_x0000_t75\" coordsize=\"21600,21600\" o:spt=\"75\" o:preferrelative=\"t\" path=\"m@4@5l@4@11@9@11@9@5xe\" filled=\"f\" stroked=\"f\"><v:stroke joinstyle=\"miter\"/><v:formulas><v:f eqn=\"if lineDrawn pixelLineWidth 0\"/><v:f eqn=\"sum @0 1 0\"/><v:f eqn=\"sum 0 0 @1\"/><v:f eqn=\"prod @2 1 2\"/><v:f eqn=\"prod @3 21600 pixelWidth\"/><v:f eqn=\"prod @3 21600 pixelHeight\"/><v:f eqn=\"sum @0 0 1\"/><v:f eqn=\"prod @6 1 2\"/><v:f eqn=\"prod @7 21600 pixelWidth\"/><v:f eqn=\"sum @8 21600 0\"/><v:f eqn=\"prod @7 21600 pixelHeight\"/><v:f eqn=\"sum @10 21600 0\"/></v:formulas><v:path o:extrusionok=\"f\" gradientshapeok=\"t\" o:connecttype=\"rect\"/><o:lock v:ext=\"edit\" aspectratio=\"t\"/></v:shapetype>");
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordXML - writeShapeType : IOException", e);
        }
    }

    private String coderImage(String fichier) {
        try {
            byte[] buffer = this.readFile(fichier);
            return Base64.encodeBytes(buffer);
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordXML - coderImage : IOException", e);
            return "";
        }
    }

    public boolean getBooleanAttribut(NamedNodeMap attributs, String nameAtt) {
        boolean value = false;
        if (attributs.getNamedItem(nameAtt) != null) {
            value = attributs.getNamedItem(nameAtt).getNodeValue().equals("true");
        }
        return value;
    }

    public void writeBold(String value) {
        try {
            this._outputFile.write(value);
        }
        catch (IOException e) {
            ResWordXml.LOG.log(Level.WARNING, "WordXML - writeBold : IOException", e);
        }
    }

    private byte[] readFile(String fileName) throws IOException {
        File file = new File(fileName);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        int bytes = (int)file.length();
        byte[] buffer = new byte[bytes];
        bis.read(buffer);
        bis.close();
        return buffer;
    }

    private String getAlg(String in) {
        String out = "left";
        if (in.equals("L")) {
            out = "left";
        } else if (in.equals("C")) {
            out = "center";
        } else if (in.equals("R")) {
            out = "right";
        } else if (in.equals("J")) {
            out = "both";
        }
        return out;
    }
}

