/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.export.xml;

import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.UtilityPluginProcess;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.export.xml.ParamsExportXml;
import com.dassault.cecilia.plugin.export.xml.ResExportXml;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginExportXml
extends AbstractPluginModel
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginExportXml.class.getPackage().getName());

    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    public boolean withParameters() {
        return true;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return "";
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        ParamsExportXml clone = new ParamsExportXml((String)parameters);
        if (clone.change(parent)) {
            return clone.getPluginKey();
        }
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        return DefaultIOParameters.getInstance();
    }

    @Override
    public void createSession(Plugable launcher, Object parameters) {
        IModel model = launcher.getModel("xml.file");
        if (model == null) {
            return;
        }
        if (parameters == null) {
            return;
        }
        if (!(parameters instanceof String)) {
            _LOG.warning("Parameters of ExportXML plugin is not String");
            return;
        }
        String param = (String)parameters;
        if (param.length() == 0) {
            return;
        }
        PluginModel plugin = launcher.getPlugin(param);
        if (plugin == null || !(plugin instanceof PluginMProcess)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResExportXml.getString("ERR_DEPEND_PLUGIN") + "\n   [" + param + "]");
            return;
        }
        BanEntry ban = null;
        try {
            ban = new BanEntry();
        }
        catch (BanLicenseException e) {
            _LOG.log(Level.WARNING, "No licence ban", e);
            return;
        }
        File logFile = this.createFile(launcher, "ExportXml", ".log");
        if (logFile == null) {
            return;
        }
        UtilityExportXmlProcess util = new UtilityExportXmlProcess((PluginMProcess)plugin, model.getFile());
        BanInputStream script = util.createBanScript(launcher, "ExportXml", util.getEmptyBanScript(), logFile);
        if (script == null) {
            return;
        }
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, ban, script, logFile){

            @Override
            protected String getDesc() {
                return PluginExportXml.this.getInfo("plugin.name");
            }

            @Override
            protected String getName() {
                return "ExportXml";
            }

            @Override
            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("FolderFiles-17.svg"));
                }
                return PluginExportXml.this.getIcon(key);
            }
        };
        launcher.addTask(task, model.getUID());
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResExportXml.getString("PLUG_EXPORT_XML_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResExportXml.getString("PLUG_EXPORT_XML_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "params";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "alt X";
        }
        return "Info";
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("FolderFiles-17.svg"));
        }
        return super.getIcon(key);
    }

    class UtilityExportXmlProcess
    extends UtilityPluginProcess {
        PluginMProcess _process;

        UtilityExportXmlProcess(PluginMProcess process, File resFile) {
            super(resFile);
            this._process = process;
        }

        @Override
        protected PluginMProcess getPostProcess(Plugable launcher) {
            return this._process;
        }

        @Override
        protected File createFile(Plugable launcher, String base, String ext) {
            return PluginExportXml.this.createFile(launcher, base, ext);
        }

        @Override
        protected String getTitle() {
            return PluginExportXml.this.getInfo("plugin.name");
        }
    }
}

