/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.ActionControl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanCut;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanEvt;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanEvtAtRisk;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanEvtEvident;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderControl;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskComputeProxy;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BooleanMCS
implements MCS {
    private static Logger _LOG = Logger.getLogger(BooleanMCS.class.getPackage().getName());
    BooleanStore _store;
    List<List<BooleanCut>> _mcs;
    boolean _bConfigMELSimplify = false;
    static AverageRiskComputeProxy __ARPCompute = new AverageRiskComputeProxy();
    static final Comparator __COMPARE_EVENTS = new Comparator<BooleanNode>(){

        @Override
        public int compare(BooleanNode o1, BooleanNode o2) {
            int idx2;
            int idx1 = o1.getIndex();
            if (idx1 < (idx2 = o2.getIndex())) {
                return -1;
            }
            if (idx1 > idx2) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator __COMPARE_CUTS = new Comparator<BooleanCut>(){

        @Override
        public int compare(BooleanCut cut1, BooleanCut cut2) {
            int order1 = cut1.getOrder();
            for (int i = 0; i < order1; ++i) {
                int idx2;
                int idx1 = cut1.getEvent(i).getIndex();
                if (idx1 < (idx2 = cut2.getEvent(i).getIndex())) {
                    return -1;
                }
                if (idx1 <= idx2) continue;
                return 1;
            }
            return 0;
        }
    };
    int[] _limitRows;
    int[] _limitCuts;
    int _nbrCuts;
    List<MCS.InfoOrder> _infoOrders;

    public BooleanMCS(BooleanStore store) {
        this._store = store;
        this._mcs = new ArrayList<List<BooleanCut>>();
    }

    public BooleanStore getStore() {
        return this._store;
    }

    public double computeProbabilities(TypeProbability type, double missionTime, ActionControl ctrl) {
        switch (type) {
            case NONE: {
                break;
            }
            case BDD: 
            case MCS: {
                return this.computeProbabilitiesMCS(ctrl);
            }
            case ARP1: 
            case ARP3: {
                return this.computeProbabilitiesARP(missionTime, false, ctrl);
            }
            case ARP2: {
                return this.computeProbabilitiesARP(missionTime, true, ctrl);
            }
        }
        return Double.NaN;
    }

    private double computeProbabilitiesMCS(ActionControl ctrl) {
        double pr = 0.0;
        int len = this._mcs.size();
        block0: for (int i = 0; i < len && !ctrl.isCanceled(); ++i) {
            List<BooleanCut> cuts = this._mcs.get(i);
            for (BooleanCut cut : cuts) {
                if (ctrl.isCanceled()) continue block0;
                if (cut.getFlag() == '\u2000') continue;
                if (i == 1 && cut.getFlag() == '\u1000') {
                    return 1.0;
                }
                pr += this.computeProbabilitiesMCS(cut);
            }
        }
        return pr;
    }

    private double computeProbabilitiesMCS(BooleanCut cut) {
        double proba = 1.0;
        for (int j = 0; j < cut._cuts.length; ++j) {
            if (cut._cuts[j].getFlag() == '\u1000') continue;
            proba *= cut._cuts[j].getProbability();
        }
        cut.setProbability(proba);
        return proba;
    }

    private double computeProbabilitiesARP(double missionTime, boolean critical, ActionControl ctrl) {
        String info;
        int nbrLeaves = this._store.getNbrLeaves();
        double[] lbd = new double[nbrLeaves];
        Arrays.fill(lbd, Double.NaN);
        double[] T = new double[nbrLeaves];
        Arrays.fill(T, Double.NaN);
        for (int i = 0; i < nbrLeaves; ++i) {
            BooleanNode leaf = this._store.getLeaf(i);
            T[i] = leaf.getPeriodInspection(missionTime);
            if (Double.isNaN(T[i])) continue;
            if (T[i] < missionTime) {
                T[i] = missionTime;
            }
            lbd[i] = leaf.getLambda();
        }
        if (Boolean.getBoolean("cecilia.ft.compute.AverageRiskReinit")) {
            __ARPCompute.init();
        }
        Object previousLongResult = __ARPCompute.getLongResult();
        double pr = 0.0;
        int len = this._mcs.size();
        if (critical) {
            block1: for (i = 0; i < len && !ctrl.isCanceled(); ++i) {
                List<BooleanCut> cuts = this._mcs.get(i);
                for (BooleanCut cut : cuts) {
                    if (ctrl.isCanceled()) continue block1;
                    if (cut.getFlag() == '\u2000') continue;
                    if (i == 1 && cut.getFlag() == '\u1000') {
                        return 1.0;
                    }
                    pr += this.computeProbabilitiesARP(cut, lbd, T, missionTime);
                }
            }
        } else {
            block3: for (i = 0; i < len && !ctrl.isCanceled(); ++i) {
                List<BooleanCut> cuts = this._mcs.get(i);
                for (BooleanCut cut : cuts) {
                    if (ctrl.isCanceled()) continue block3;
                    if (cut.getFlag() == '\u2000') continue;
                    if (i == 1 && cut.getFlag() == '\u1000') {
                        return 1.0;
                    }
                    pr += this.computeProbabilitiesARP(cut, lbd, T);
                }
            }
        }
        if (_LOG.isLoggable(Level.FINER) && previousLongResult != __ARPCompute.getLongResult() && (info = __ARPCompute.printLongCompute(Integer.getInteger("cecilia.ft.compute.AverageRiskTimeNbr", 10), Long.getLong("cecilia.ft.compute.AverageRiskTimeLimit", 1000000L))).length() > 0) {
            _LOG.log(Level.FINER, "Long time compute for Average Risk: \n" + info);
        }
        return pr;
    }

    private double computeProbabilitiesARP(BooleanCut cut, double[] lbd, double[] t) {
        double proba = 1.0;
        double[] curLbd = new double[3];
        double[] curT = new double[3];
        int nbrHide = 0;
        for (int j = 0; j < cut._cuts.length; ++j) {
            BooleanEvt leaf = cut._cuts[j];
            if (leaf.getFlag() == '\u1000') continue;
            if (Double.isNaN(t[leaf.getIndex()]) || leaf instanceof BooleanEvtEvident || leaf instanceof BooleanEvtAtRisk) {
                proba *= leaf.getProbability();
                continue;
            }
            if (nbrHide >= 3) {
                return this.computeProbabilitiesMCS(cut);
            }
            curLbd[nbrHide] = lbd[leaf.getIndex()];
            curT[nbrHide] = t[leaf.getIndex()];
            ++nbrHide;
        }
        switch (nbrHide) {
            case 1: {
                proba *= __ARPCompute.computeOneFailures(curLbd[0], curT[0]);
                break;
            }
            case 2: {
                proba *= __ARPCompute.computeTwoFailures(curLbd[0], curT[0], curLbd[1], curT[1]);
                break;
            }
            case 3: {
                proba *= __ARPCompute.computeThreeFailures(curLbd[0], curT[0], curLbd[1], curT[1], curLbd[2], curT[2]);
            }
        }
        cut.setProbability(proba);
        return proba;
    }

    private double computeProbabilitiesARP(BooleanCut cut, double[] lbd, double[] t, double tm) {
        double proba = 1.0;
        double[] curLbd = new double[3];
        double[] curT = new double[3];
        int nbrHide = 0;
        for (int j = 0; j < cut._cuts.length; ++j) {
            BooleanEvt leaf = cut._cuts[j];
            if (leaf.getFlag() == '\u1000') continue;
            if (Double.isNaN(t[leaf.getIndex()])) {
                proba *= leaf.getProbability();
                continue;
            }
            if (nbrHide >= 3) {
                return this.computeProbabilitiesMCS(cut);
            }
            curLbd[nbrHide] = lbd[leaf.getIndex()];
            curT[nbrHide] = t[leaf.getIndex()];
            ++nbrHide;
        }
        if (nbrHide == cut._cuts.length && nbrHide > 0) {
            switch (nbrHide) {
                default: {
                    throw new UnsupportedOperationException("Internal error");
                }
                case 1: {
                    return this.computeProbabilitiesMCS(cut);
                }
                case 2: {
                    proba *= __ARPCompute.computeTwoFailuresExcluded(tm, curLbd[0], curT[0], curLbd[1], curT[1]);
                    break;
                }
                case 3: {
                    proba *= __ARPCompute.computeThreeFailuresExcluded(tm, curLbd[0], curT[0], curLbd[1], curT[1], curLbd[2], curT[2]);
                    break;
                }
            }
        } else {
            switch (nbrHide) {
                case 1: {
                    proba *= __ARPCompute.computeOneFailures(curLbd[0], curT[0]);
                    break;
                }
                case 2: {
                    proba *= __ARPCompute.computeTwoFailures(curLbd[0], curT[0], curLbd[1], curT[1]);
                    break;
                }
                case 3: {
                    proba *= __ARPCompute.computeThreeFailures(curLbd[0], curT[0], curLbd[1], curT[1], curLbd[2], curT[2]);
                }
            }
        }
        cut.setProbability(proba);
        return proba;
    }

    public boolean addCut(String line, MCSReaderControl ctrl) {
        int len = line.length();
        if (len < 2) {
            return false;
        }
        if (line.charAt(0) != '{') {
            return false;
        }
        int state = 0;
        int pos = 1;
        StringBuffer var = new StringBuffer();
        ArrayList<BooleanNode> cut = new ArrayList<BooleanNode>(){

            @Override
            public boolean add(BooleanNode e) {
                int llen = this.size();
                int i = llen;
                if (i < 7) {
                    while (i > 0 && __COMPARE_EVENTS.compare(this.get(i - 1), e) > 0) {
                        if (i == llen) {
                            super.add((BooleanNode)this.get(i - 1));
                        } else {
                            this.set(i, (BooleanNode)this.get(i - 1));
                        }
                        --i;
                    }
                    if (i == llen) {
                        super.add(e);
                    } else {
                        this.set(i, e);
                    }
                } else {
                    super.add(e);
                }
                return true;
            }
        };
        while (state != 4) {
            if (pos >= len) {
                return false;
            }
            char cur = line.charAt(pos);
            switch (state) {
                case 0: {
                    if (cur == '\'' || cur == '`') {
                        var = new StringBuffer();
                        state = 2;
                        ++pos;
                        break;
                    }
                    if (cur == '}') {
                        state = 4;
                        break;
                    }
                    if (Character.isWhitespace(cur)) {
                        ++pos;
                        break;
                    }
                    if (cur >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z') {
                        state = 1;
                        var = new StringBuffer();
                        var.append(cur);
                        ++pos;
                        break;
                    }
                    return false;
                }
                case 1: {
                    if (cur >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z' || cur >= '0' && cur <= '9' || cur == '-' || cur == '_' || cur == '.' || cur == '^') {
                        var.append(cur);
                        ++pos;
                        break;
                    }
                    BooleanNode evt = this.convertEvent(var.toString());
                    if (evt == null) {
                        return false;
                    }
                    cut.add(evt);
                    state = 3;
                    break;
                }
                case 2: {
                    BooleanNode evt;
                    if (cur == '\'') {
                        evt = this.convertEvent(var.toString());
                        if (evt == null) {
                            return false;
                        }
                        cut.add(evt);
                        state = 3;
                    } else {
                        var.append(cur);
                    }
                    ++pos;
                    break;
                }
                case 3: {
                    if (Character.isWhitespace(cur)) {
                        ++pos;
                        break;
                    }
                    if (cur == '}') {
                        state = 4;
                        break;
                    }
                    if (cur == ',') {
                        ++pos;
                        state = 0;
                        break;
                    }
                    return false;
                }
            }
        }
        if (ctrl.addCuts((List<BooleanNode>)cut)) {
            this.addCut(new BooleanCut((List<? extends BooleanEvt>)cut, cut.size() > 7));
        } else {
            while (ctrl.getLimitOrder() < this._mcs.size()) {
                this._mcs.remove(this._mcs.size() - 1);
            }
        }
        return true;
    }

    private BooleanNode convertEvent(String name) {
        BooleanNode leaf = this._store.getNode(name);
        if (leaf == null) {
            _LOG.info("BooleanMCS : Event unknown '" + name + "'");
            return null;
        }
        if (leaf.getType() == 2) {
            return leaf;
        }
        if (leaf.getType() == 6) {
            return leaf;
        }
        if (leaf.getType() == 0 && this._store.getNbrLeaves() == 0) {
            return leaf;
        }
        _LOG.info("BooleanMCS : Bad type for event '" + name + "' : " + leaf.getType());
        return null;
    }

    public void addCut(BooleanCut cut) {
        int order = cut.getOrder();
        while (order >= this._mcs.size()) {
            this._mcs.add(new ArrayList(100));
        }
        this._mcs.get(order).add(cut);
    }

    public boolean isAlwaysTrue() {
        if (this._bConfigMELSimplify && this._mcs.size() > 1) {
            List<BooleanCut> cuts = this._mcs.get(1);
            int nbrCut = cuts.size();
            for (int j = 0; j < nbrCut; ++j) {
                BooleanCut cut = cuts.get(j);
                if (cut.getEvent(0).getFlag() != '\u1000') continue;
                return true;
            }
        }
        return this._mcs.size() == 1 && this._mcs.get(0).size() > 0;
    }

    public boolean isAlwaysFalse() {
        for (int i = this._mcs.size() - 1; i >= 0; --i) {
            if (this._mcs.get(i).size() <= 0) continue;
            return false;
        }
        return true;
    }

    public String constructWarning() {
        if (this.isAlwaysTrue()) {
            return ResCompute.getString("MCS_MSG_TREE_TRUE");
        }
        if (this.isAlwaysFalse()) {
            return ResCompute.getString("MCS_MSG_TREE_FALSE");
        }
        return null;
    }

    public String getOrderAbstract() {
        StringBuffer sb = new StringBuffer();
        int len = this._mcs.size();
        long max = 0L;
        for (int i = 0; i < len; ++i) {
            int nbr = this._mcs.get(i).size();
            if (i > 0) {
                sb.append(";");
            }
            sb.append(nbr);
            max += (long)nbr;
        }
        sb.append("=>").append(max);
        return sb.toString();
    }

    public String getOrderString() {
        StringBuffer sb = new StringBuffer();
        int len = this._mcs.size();
        long max = 0L;
        for (int i = 0; i < len; ++i) {
            int nbr = this._mcs.get(i).size();
            sb.append(i).append(";").append(nbr).append("\n");
            max += (long)nbr;
        }
        sb.append("total;").append(max).append("\n");
        return sb.toString();
    }

    public String getProductString() {
        StringBuffer sb = new StringBuffer();
        int len = this._mcs.size();
        sb.append("product() = \n");
        for (int i = 0; i < len; ++i) {
            List<BooleanCut> cuts = this._mcs.get(i);
            for (BooleanCut cut : cuts) {
                sb.append(cut.toString()).append("\n");
            }
        }
        sb.append("end\n");
        return sb.toString();
    }

    @Override
    public int getOrderMax() {
        return this._infoOrders.size();
    }

    @Override
    public int getOrderNumber(int idx) {
        return this._infoOrders.get(idx).getNumber();
    }

    @Override
    public double getOrderProbability(int idx) {
        return this._infoOrders.get(idx).getProbability();
    }

    public void prepare() {
        if (this._infoOrders != null) {
            return;
        }
        int size = this._mcs.size();
        while (size > 0 && this._mcs.get(size - 1).size() <= 0) {
            this._mcs.remove(--size);
        }
        this._infoOrders = new ArrayList<MCS.InfoOrder>(size);
        if (size == 0) {
            this._nbrCuts = 0;
            this._limitRows = new int[1];
            this._limitRows[0] = 0;
            this._limitCuts = new int[1];
            this._limitCuts[0] = 0;
        } else {
            this._nbrCuts = 0;
            this._limitRows = new int[size];
            this._limitCuts = new int[size];
            int curRank = 0;
            for (int i = 0; i < size; ++i) {
                List<BooleanCut> cuts = this._mcs.get(i);
                int nbrCutForOrder_i = cuts.size();
                double proba = 0.0;
                for (int j = 0; j < nbrCutForOrder_i; ++j) {
                    double probaCut = cuts.get(j).getProbability();
                    if (probaCut < 0.0 || Double.isNaN(probaCut)) {
                        proba = Double.NaN;
                        break;
                    }
                    proba += probaCut;
                }
                this._infoOrders.add(new MCS.InfoOrder(i, nbrCutForOrder_i, proba));
                this._nbrCuts += nbrCutForOrder_i;
                this._limitRows[i] = curRank += nbrCutForOrder_i * i;
                this._limitCuts[i] = this._nbrCuts;
            }
        }
    }

    @Override
    public int getCutCount() {
        return this._nbrCuts;
    }

    @Override
    public BooleanMCSOrderCutIterator cutIterate() {
        return new BooleanMCSOrderCutIterator();
    }

    public Cut getCut(int cut) {
        int idxOrder;
        int nbrCutForOrder_idx;
        int maxOrder = this._mcs.size();
        for (idxOrder = 0; idxOrder < maxOrder && cut >= (nbrCutForOrder_idx = this._mcs.get(idxOrder).size()); cut -= nbrCutForOrder_idx, ++idxOrder) {
        }
        return this._mcs.get(idxOrder).get(cut);
    }

    @Override
    public int getRowCount() {
        return this._limitRows[this._limitRows.length - 1];
    }

    @Override
    public Cut getRowCut(int row) {
        for (int i = this._limitRows.length - 1; i >= 0; --i) {
            if (this._limitRows[i] > row) continue;
            if ((row - this._limitRows[i]) % (i + 1) == 0) {
                return this._mcs.get(i + 1).get((row - this._limitRows[i]) / (i + 1));
            }
            return null;
        }
        return null;
    }

    @Override
    public int getRowIndexCut(int row) {
        for (int i = this._limitRows.length - 1; i >= 0; --i) {
            if (this._limitRows[i] > row) continue;
            return this._limitCuts[i] + (row - this._limitRows[i]) / (i + 1);
        }
        return -1;
    }

    @Override
    public Evt getRowEvent(int row) {
        for (int i = this._limitRows.length - 1; i >= 0; --i) {
            if (this._limitRows[i] > row) continue;
            Cut cut = this._mcs.get(i + 1).get((row - this._limitRows[i]) / (i + 1));
            return cut.getEvent((row - this._limitRows[i]) % (i + 1));
        }
        return null;
    }

    public void limitAt(int limitOrder) {
        while (this._mcs.size() > limitOrder + 1) {
            this._mcs.remove(this._mcs.size() - 1);
        }
        if (this._infoOrders != null) {
            while (this._infoOrders.size() > limitOrder + 1) {
                this._infoOrders.remove(this._infoOrders.size() - 1);
            }
        }
        if (this._limitRows != null && this._limitRows.length > limitOrder + 1) {
            int size = this._mcs.size();
            int[] newLimitRows = new int[size];
            System.arraycopy(this._limitRows, 0, newLimitRows, 0, size);
            this._limitRows = newLimitRows;
            this._nbrCuts = 0;
            for (int i = 0; i < size; ++i) {
                this._nbrCuts += this._mcs.get(i).size();
            }
        }
    }

    public void configureForMELStep(BooleanNode node, EngineControl ctrl, int limitOrder) {
        int i;
        for (i = this.getStore().getNbrLeaves() - 1; i >= 0; --i) {
            this.getStore().getLeaf(i).setFlag('\u0000');
        }
        for (i = this._mcs.size() - 1; i >= 0; --i) {
            List<BooleanCut> cuts = this._mcs.get(i);
            char flag = limitOrder <= 0 || i <= limitOrder ? (char)'\u0000' : '\u2000';
            for (int j = cuts.size() - 1; j >= 0; --j) {
                cuts.get(j).setFlag(flag);
            }
        }
        if (node != null) {
            int k;
            BooleanCut cut;
            int j;
            this._bConfigMELSimplify = true;
            node.setFlag('\u1000');
            int maxOrder = this._mcs.size();
            ArrayList<BooleanCut> cutsWithEvt = new ArrayList<BooleanCut>();
            for (int i2 = 0; i2 < maxOrder; ++i2) {
                List<BooleanCut> cuts = this._mcs.get(i2);
                int nbrCuts = cuts.size();
                if (ctrl.isCanceled()) {
                    return;
                }
                char flag = limitOrder <= 0 || i2 <= limitOrder ? (char)'\u0000' : '\u2000';
                block4: for (j = 0; j < nbrCuts; ++j) {
                    cut = cuts.get(j);
                    cut.setFlag(flag);
                    for (k = cut.getOrder() - 1; k >= 0; --k) {
                        if (((BooleanNode)cut.getEvent(k)).getFlag() != '\u1000') continue;
                        cut.setFlag('\u1000');
                        if (flag != '\u0000') continue block4;
                        cutsWithEvt.add(cut);
                        continue block4;
                    }
                }
            }
            int nbrCutsWithEvt = cutsWithEvt.size();
            if (limitOrder > 0 && limitOrder < maxOrder) {
                maxOrder = limitOrder + 1;
            }
            for (int i3 = 0; i3 < maxOrder; ++i3) {
                List<BooleanCut> cuts = this._mcs.get(i3);
                int nbrCuts = cuts.size();
                block7: for (j = 0; j < nbrCuts; ++j) {
                    BooleanCut cutWith;
                    cut = cuts.get(j);
                    if (cut.getFlag() == '\u1000') continue;
                    if (ctrl.isCanceled()) {
                        return;
                    }
                    for (k = 0; k < nbrCutsWithEvt && (cutWith = (BooleanCut)cutsWithEvt.get(k)).getOrder() <= cut.getOrder(); ++k) {
                        if (!this.isIncludeCut(cut, cutWith)) continue;
                        cut.setFlag('\u2000');
                        continue block7;
                    }
                }
            }
        } else {
            this._bConfigMELSimplify = false;
            this._infoOrders = null;
            this.prepare();
        }
    }

    private boolean isIncludeCut(BooleanCut cut1, BooleanCut cut2) {
        int nbrFind = cut2.getOrder() - 1;
        int order1 = cut1.getOrder();
        int order2 = cut2.getOrder();
        block0: for (int i1 = 0; i1 < order1; ++i1) {
            BooleanEvt evt1 = cut1.getEvent(i1);
            for (int i2 = 0; i2 < order2; ++i2) {
                BooleanEvt evt2 = cut2.getEvent(i2);
                if (((BooleanNode)evt2).getFlag() == '\u1000' || evt1 != evt2) continue;
                if (--nbrFind != 0) continue block0;
                return true;
            }
        }
        return false;
    }

    public void prepareMELInfoOrder(int limitedOrder) {
        int size = this._mcs.size();
        while (size > 0 && this._mcs.get(size - 1).size() <= 0) {
            this._mcs.remove(--size);
        }
        int limited = size - 1;
        if (limitedOrder > 0) {
            limited = limitedOrder + 1;
        }
        this._infoOrders = new ArrayList<MCS.InfoOrder>(limited);
        if (limited == 0) {
            this._nbrCuts = 0;
            this._limitRows = new int[1];
            this._limitRows[0] = 0;
            this._limitCuts = new int[1];
            this._limitCuts[0] = 0;
        } else {
            this._nbrCuts = 0;
            this._limitRows = new int[limited];
            this._limitCuts = new int[limited];
            for (int i = 0; i < limited; ++i) {
                int nbr = 0;
                double proba = 0.0;
                if (i < size) {
                    double probaCut;
                    BooleanCut cut;
                    int j;
                    List<BooleanCut> cuts = this._mcs.get(i);
                    int nbrCut = cuts.size();
                    for (j = 0; j < nbrCut; ++j) {
                        cut = cuts.get(j);
                        if (cut.getFlag() == '\u1000' || cut.getFlag() == '\u2000') continue;
                        if (!Double.isNaN(proba)) {
                            probaCut = cut.getProbability();
                            proba = probaCut < 0.0 || Double.isNaN(probaCut) ? Double.NaN : (proba += probaCut);
                        }
                        ++nbr;
                    }
                    if ((i + 1 < limited || limitedOrder > 0) && i + 1 < size) {
                        cuts = this._mcs.get(i + 1);
                        nbrCut = cuts.size();
                        for (j = 0; j < nbrCut; ++j) {
                            cut = cuts.get(j);
                            if (cut.getFlag() != '\u1000') continue;
                            if (!Double.isNaN(proba)) {
                                probaCut = cut.getProbability();
                                proba = probaCut < 0.0 || Double.isNaN(probaCut) ? Double.NaN : (proba += probaCut);
                            }
                            ++nbr;
                        }
                    }
                }
                this._infoOrders.add(new MCS.InfoOrder(i, nbr, proba));
                if (i == 0 && nbr > 0) break;
            }
        }
    }

    public BooleanMCS postTreatmentHide(double missiontime) {
        BooleanMCS result = new BooleanMCS(this.getStore());
        HashMap<Integer, BooleanEvtEvident> mapEvident = new HashMap<Integer, BooleanEvtEvident>();
        boolean atLeastOneNewCuts = false;
        BooleanMCSOrderCutIterator cutIter = this.cutIterate();
        while (cutIter.hasNext()) {
            int i;
            BooleanCut cut = cutIter.next();
            if (cut.getFlag() == '\u2000') continue;
            int nbrHide = 0;
            int nbrEvt = 0;
            int cutOrder = cut.getOrder();
            for (i = 0; i < cutOrder; ++i) {
                BooleanEvt evt = cut.getEvent(i);
                if (evt.getFlag() == '\u1000') continue;
                ++nbrEvt;
                double T = evt.getPeriodInspection(1.0);
                if (Double.isNaN(T)) continue;
                ++nbrHide;
            }
            if (nbrHide == nbrEvt) {
                for (i = 0; i < cutOrder; ++i) {
                    BooleanEvt testEvt = cut.getEvent(i);
                    if (testEvt.getFlag() == '\u1000') continue;
                    BooleanEvtEvident evtEvident = (BooleanEvtEvident)mapEvident.get(testEvt.getIndex());
                    if (evtEvident == null) {
                        evtEvident = new BooleanEvtEvident(testEvt);
                        evtEvident.setProbability(evtEvident.getLaw().getValue(missiontime));
                        mapEvident.put(testEvt.getIndex(), evtEvident);
                    }
                    ArrayList<BooleanEvt> postCut = new ArrayList<BooleanEvt>();
                    for (int j = 0; j < cutOrder; ++j) {
                        BooleanEvt evt = cut.getEvent(j);
                        if (evt.getFlag() == '\u1000') continue;
                        if (i == j) {
                            postCut.add(evtEvident);
                            continue;
                        }
                        postCut.add(evt);
                    }
                    result.addCut(new BooleanCut(postCut, false));
                }
                atLeastOneNewCuts = true;
                continue;
            }
            ArrayList<BooleanEvt> postCut = new ArrayList<BooleanEvt>();
            for (int j = 0; j < cutOrder; ++j) {
                BooleanEvt evt = cut.getEvent(j);
                if (evt.getFlag() == '\u1000') continue;
                postCut.add(evt);
            }
            result.addCut(new BooleanCut(postCut, false));
        }
        if (atLeastOneNewCuts) {
            return result;
        }
        return this;
    }

    public BooleanMCS postTreatmentRisk(double specificTime) {
        BooleanMCS result = new BooleanMCS(this.getStore());
        HashMap<Integer, BooleanEvtAtRisk> mapAtRisk = new HashMap<Integer, BooleanEvtAtRisk>();
        BooleanMCSOrderCutIterator cutIter = this.cutIterate();
        while (cutIter.hasNext()) {
            BooleanEvt evt;
            int i;
            BooleanCut cut = cutIter.next();
            if (cut.getFlag() == '\u2000') continue;
            int nbrHide = 0;
            int nbrEvt = 0;
            int cutOrder = cut.getOrder();
            ArrayList<BooleanEvt> postCut = new ArrayList<BooleanEvt>();
            int idxSelectAtRisk = -1;
            double maxScale = 0.0;
            for (i = 0; i < cutOrder; ++i) {
                evt = cut.getEvent(i);
                if (evt.getFlag() == '\u1000') continue;
                ++nbrEvt;
                double T = evt.getPeriodInspection(1.0);
                if (Double.isNaN(T)) {
                    double scale;
                    BooleanEvtAtRisk evtAtRisk = (BooleanEvtAtRisk)mapAtRisk.get(evt.getIndex());
                    if (evtAtRisk == null) {
                        evtAtRisk = new BooleanEvtAtRisk(evt);
                        evtAtRisk.setProbability(evtAtRisk.getLaw().getValue(specificTime));
                        mapAtRisk.put(evt.getIndex(), evtAtRisk);
                    }
                    if (!((scale = evtAtRisk.getProbability() / evt.getProbability()) > maxScale)) continue;
                    maxScale = scale;
                    idxSelectAtRisk = i;
                    continue;
                }
                ++nbrHide;
            }
            if (nbrHide == nbrEvt) {
                return null;
            }
            for (i = 0; i < cutOrder; ++i) {
                evt = cut.getEvent(i);
                if (evt.getFlag() == '\u1000') continue;
                if (idxSelectAtRisk == i) {
                    BooleanEvtAtRisk evtAtRisk = (BooleanEvtAtRisk)mapAtRisk.get(evt.getIndex());
                    if (evtAtRisk == null) {
                        return null;
                    }
                    postCut.add(evtAtRisk);
                    continue;
                }
                postCut.add(evt);
            }
            result.addCut(new BooleanCut(postCut, false));
        }
        return result;
    }

    class BooleanMCSOrderCutIterator
    implements MCS.CutIterator {
        int _idxOrder = 0;
        int _idxCut = -1;

        BooleanMCSOrderCutIterator() {
            this.findNext();
        }

        void findNext() {
            ++this._idxCut;
            while (this._idxOrder < BooleanMCS.this._mcs.size()) {
                List<BooleanCut> cuts = BooleanMCS.this._mcs.get(this._idxOrder);
                if (this._idxCut < cuts.size()) {
                    return;
                }
                ++this._idxOrder;
                this._idxCut = 0;
            }
        }

        @Override
        public boolean hasNext() {
            return this._idxOrder < BooleanMCS.this._mcs.size();
        }

        @Override
        public BooleanCut next() {
            BooleanCut current = BooleanMCS.this._mcs.get(this._idxOrder).get(this._idxCut);
            this.findNext();
            return current;
        }
    }
}

