/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttrAvg;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttribute;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanEvt;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanExpression;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanParser;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BooleanNode
extends BooleanEvt {
    private static Logger _LOG = Logger.getLogger(BooleanNode.class.getPackage().getName());
    String _name;
    String _userName;
    int _idx;
    byte _type;
    BooleanExpression _distribution;
    double _probability;
    Map<Attr.Key, BooleanAttribute> _attributes;

    public BooleanNode(String name, int type, boolean ext) {
        this._name = name;
        this._userName = this._name.endsWith("'") ? this._name.substring(1, this._name.length() - 1) : this._name;
        this._type = (byte)(ext ? -type : type);
        this._probability = Double.NaN;
    }

    @Override
    public String getName() {
        return this._userName;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public boolean isExtern() {
        return this._type < 0;
    }

    public int getType() {
        return this._type < 0 ? -this._type : this._type;
    }

    public boolean isLeaf() {
        int type = this.getType();
        return type == 2 || type == 6;
    }

    public void setIndex(int idx) {
        this._idx = idx;
    }

    @Override
    public int getIndex() {
        return this._idx;
    }

    @Override
    public double getProbability() {
        return this._probability;
    }

    public void setProbability(double value) {
        this._probability = value;
    }

    public void addAttribute(BooleanAttribute attr) {
        if (this._attributes == null) {
            this._attributes = new LinkedHashMap<Attr.Key, BooleanAttribute>();
        }
        this._attributes.put(attr.getKey(), attr);
    }

    protected void removeAttribute(Attr.Key keyAttr) {
        if (this._attributes != null) {
            this._attributes.remove(keyAttr);
        }
    }

    @Override
    public BooleanAttribute getAttribute(Attr.Key key) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(key);
    }

    @Override
    public Collection<? extends Attr> getAttributs() {
        if (this._attributes == null) {
            return Collections.emptyList();
        }
        return this._attributes.values();
    }

    private static BooleanExpression convertExpression(BooleanStore store, Object value, int tokenToRead) {
        BooleanExpression expr;
        BooleanParser parser = store.getParser();
        parser.restart(new StringReader(value.toString()), tokenToRead);
        parser.run();
        if (!parser.withError() && (expr = parser.getBooleanExpression()).convert(store)) {
            return expr;
        }
        return null;
    }

    public boolean convert(BooleanStore store) {
        BooleanExpression expr;
        boolean result = true;
        BooleanAttribute attr = this.getAttribute(BooleanAttribute.KEY_LAW);
        if (attr != null) {
            expr = BooleanNode.convertExpression(store, attr.getValue(), 277);
            if (expr != null) {
                attr.setValue(expr);
            } else {
                this._attributes.remove(BooleanAttribute.KEY_LAW);
                result = false;
            }
        }
        if ((attr = this.getAttribute(BooleanAttribute.KEY_INSPECTED)) != null) {
            expr = BooleanNode.convertExpression(store, attr.getValue(), 278);
            if (expr != null) {
                attr.setValue(expr);
            } else {
                this._attributes.remove(BooleanAttribute.KEY_INSPECTED);
                result = false;
            }
        }
        if ((attr = this.getAttribute(BooleanAttribute.KEY_INFLIGHT)) != null) {
            expr = BooleanNode.convertExpression(store, attr.getValue(), 278);
            if (expr != null) {
                attr.setValue(expr);
            } else {
                this._attributes.remove(BooleanAttribute.KEY_INFLIGHT);
                result = false;
            }
        }
        return result;
    }

    public void writeProbability(Appendable output) throws IOException {
        BooleanAttribute attr = this.getAttribute(BooleanAttribute.KEY_STATE);
        if (attr != null) {
            if ("2".equals(attr.getValue())) {
                return;
            }
            if ("1".equals(attr.getValue())) {
                return;
            }
        }
        if (!Double.isNaN(this._probability)) {
            output.append("law ").append(this._name);
            output.append(" constant ");
            output.append(Double.toString(this._probability));
            output.append(" ;\n");
        }
    }

    public boolean withoutProbability() {
        BooleanAttribute attr = this.getAttribute(BooleanAttribute.KEY_STATE);
        if (attr != null) {
            if ("2".equals(attr.getValue())) {
                return false;
            }
            if ("1".equals(attr.getValue())) {
                return false;
            }
        }
        return (attr = this.getAttribute(BooleanAttribute.KEY_LAW)) == null;
    }

    public void computeProbability(double missionTime, BooleanStore.ProbabilityControl ctrl) {
        double expositionTime;
        double periodicity;
        BooleanAttribute attr = this.getAttribute(BooleanAttribute.KEY_STATE);
        if (attr != null) {
            if ("2".equals(attr.getValue())) {
                this._probability = 0.0;
                return;
            }
            if ("1".equals(attr.getValue())) {
                this._probability = 1.0;
                return;
            }
        }
        if ((attr = this.getAttribute(BooleanAttribute.KEY_INSPECTED)) != null && (periodicity = ((BooleanExpression)attr.getValue()).getValue(missionTime)) > 0.0 && (attr = this.getAttribute(BooleanAttribute.KEY_LAW)) != null) {
            try {
                double lbd = ((BooleanExpression)attr.getValue()).getLambda();
                if (missionTime <= periodicity) {
                    lbd *= periodicity / missionTime;
                } else {
                    ctrl.appendLesserPeriodicity(this);
                }
                this._probability = 1.0 - Math.exp(-lbd * missionTime);
                return;
            }
            catch (UnsupportedOperationException e) {
                _LOG.log(Level.INFO, "Inspected event '" + this.getName() + "' without lambda in law", e);
                ctrl.appendMissingProbability(this);
                return;
            }
        }
        attr = this.getAttribute(BooleanAttribute.KEY_INFLIGHT);
        if (attr != null && (expositionTime = ((BooleanExpression)attr.getValue()).getValue(missionTime)) > 0.0 && (attr = this.getAttribute(BooleanAttribute.KEY_LAW)) != null) {
            try {
                double lbd = ((BooleanExpression)attr.getValue()).getLambda();
                if (missionTime >= expositionTime) {
                    lbd *= expositionTime / missionTime;
                } else {
                    ctrl.appendGreaterExposition(this);
                }
                this._probability = 1.0 - Math.exp(-lbd * missionTime);
                return;
            }
            catch (UnsupportedOperationException e) {
                _LOG.log(Level.INFO, "Inflight event '" + this.getName() + "' without lambda in law", e);
                ctrl.appendMissingProbability(this);
                return;
            }
        }
        attr = this.getAttribute(BooleanAttribute.KEY_LAW);
        if (attr != null) {
            this._probability = ((BooleanExpression)attr.getValue()).getValue(missionTime);
            if (Double.isNaN(this._probability)) {
                ctrl.appendErrorProbability(this);
            }
            return;
        }
        ctrl.appendMissingProbability(this);
    }

    public void prepareComputeAverageRisk(Collection<BooleanAttrAvg> attributeAverage, BooleanStore store, double missionTime, BooleanStore.ProbabilityControl ctrl) {
        BooleanAttrAvg.Choice choice = BooleanAttrAvg.Choice.DEF;
        BooleanAttribute attrInspected = this.getAttribute(BooleanAttribute.KEY_INSPECTED);
        if (attributeAverage == null || attributeAverage.size() < 0) {
            if (attrInspected != null) {
                choice = BooleanAttrAvg.Choice.AVG;
            }
        } else {
            Iterator<BooleanAttrAvg> iAttAvg = attributeAverage.iterator();
            BooleanAttrAvg curAttAvg = iAttAvg.next();
            Attr.Key keyAttAvg = curAttAvg.getAttributeKey();
            BooleanAttribute attrAverage = this.getAttribute(keyAttAvg);
            if (attrInspected != null && attrAverage == null) {
                ctrl.appendAvgNoAttribute(this);
                return;
            }
            if (attrAverage != null) {
                BooleanAttrAvg attAvg = null;
                boolean first = true;
                while (attAvg == null && (first || iAttAvg.hasNext())) {
                    if (!first) {
                        curAttAvg = iAttAvg.next();
                    }
                    if (curAttAvg.getCriterion().match(attrAverage)) {
                        attAvg = curAttAvg;
                    }
                    first = false;
                }
                if (attAvg == null) {
                    ctrl.appendAvgNoMatrix(this);
                    return;
                }
                if (attAvg.getChoice() == BooleanAttrAvg.Choice.DEF) {
                    if (attrInspected != null) {
                        ctrl.appendAvgDefInspected(this);
                        return;
                    }
                } else if (attrInspected == null) {
                    ctrl.appendAvgNoInspected(this);
                } else {
                    switch (attAvg.getChoice()) {
                        case MAX: {
                            this.addAttribute(new BooleanAttribute(BooleanAttribute.KEY_UNAVERAGE, "true"));
                            break;
                        }
                        case AVG: {
                            choice = BooleanAttrAvg.Choice.AVG;
                        }
                        case DEF: {
                            this.removeAttribute(BooleanAttribute.KEY_UNAVERAGE);
                        }
                    }
                    String parameter = attAvg.getParameter();
                    if (parameter != null) {
                        BooleanExpression paramExpr = store.getNamedParameter(parameter);
                        if (paramExpr == null) {
                            ctrl.appendAvgBadParameter(this);
                        } else if (paramExpr.getValue(1.0) != ((BooleanExpression)attrInspected.getValue()).getValue(1.0)) {
                            ctrl.appendAvgBadParameter(this);
                        }
                    }
                }
            }
        }
        if (choice == BooleanAttrAvg.Choice.AVG) {
            if (attrInspected == null) {
                _LOG.warning("Choice for compute is 'Average Risk Approach' and event is not inspected !!");
            } else {
                BooleanAttribute law;
                double periodicity = ((BooleanExpression)attrInspected.getValue()).getValue(missionTime);
                if (periodicity > 0.0 && (law = this.getAttribute(BooleanAttribute.KEY_LAW)) != null) {
                    try {
                        double lbd = ((BooleanExpression)law.getValue()).getLambda();
                        if (missionTime > periodicity) {
                            periodicity = missionTime;
                        }
                        this._probability = BooleanMCS.__ARPCompute.computeOneFailures(lbd, periodicity);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public String getEngineName() {
        return this._name;
    }

    @Override
    public Object getInfo(Evt.KeyInfo key, ArborRenderer renderer) {
        BooleanAttribute attr = null;
        switch (key) {
            case COMMENT: {
                attr = this.getAttribute(BooleanAttribute.KEY_LABEL);
                if (attr != null) {
                    return attr.getValue();
                }
                return "";
            }
            case LAW: {
                Object law;
                attr = this.getAttribute(BooleanAttribute.KEY_LAW);
                if (attr != null && (law = attr.getValue()) instanceof BooleanExpression) {
                    StringBuffer sb = new StringBuffer();
                    try {
                        ((BooleanExpression)law).export(sb, renderer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return sb.toString();
                }
                return null;
            }
            case PROBABILITY: {
                return this.getProbability();
            }
            case STATE: {
                attr = this.getAttribute(BooleanAttribute.KEY_STATE);
                if (attr != null) {
                    int state = -1;
                    try {
                        state = Integer.parseInt(attr.getValue().toString());
                    }
                    catch (NumberFormatException e) {
                        _LOG.log(Level.INFO, "State field for '" + this.getName() + "' is not integer", e);
                    }
                    if (state == 1) {
                        return ResMsgVoc.getString("VOC_TRUE");
                    }
                    if (state == 2) {
                        return ResMsgVoc.getString("VOC_FALSE");
                    }
                }
                return ResMsgVoc.getString("VOC_NORMAL");
            }
            case GENERIC: {
                attr = this.getAttribute(BooleanAttribute.KEY_GENERIC);
                if (attr != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case EXTENTION: {
                attr = this.getAttribute(BooleanAttribute.KEY_GENERIC);
                if (attr != null) {
                    return attr.getValue();
                }
                return null;
            }
            case UNDEVELOPPED: {
                return Math.abs(this._type) == 2;
            }
            case SUBTREE: {
                return Math.abs(this._type) == 3;
            }
            case DSF: {
                return Math.abs(this._type) == 4;
            }
            case TREENAME: {
                attr = this.getAttribute(BooleanAttribute.KEY_EQUIV);
                if (attr != null) {
                    return attr.getValue();
                }
                return null;
            }
            case BTP: {
                attr = this.getAttribute(BooleanAttribute.KEY_FRB);
                if (attr != null) {
                    return attr.getValue();
                }
                return null;
            }
            case FMEA: {
                attr = this.getAttribute(BooleanAttribute.KEY_FMEA);
                if (attr != null) {
                    return attr.getValue();
                }
                return null;
            }
            case GSR: {
                attr = this.getAttribute(BooleanAttribute.KEY_GSR);
                if (attr != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case INSPECTED: {
                attr = this.getAttribute(BooleanAttribute.KEY_INSPECTED);
                if (attr != null) {
                    Object value = attr.getValue();
                    if (value instanceof BooleanExpression) {
                        StringBuffer sb = new StringBuffer();
                        try {
                            ((BooleanExpression)value).export(sb, renderer);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return sb.toString();
                    }
                    return value.toString();
                }
                return null;
            }
            case INSPECTED_VALUE: {
                Object value;
                attr = this.getAttribute(BooleanAttribute.KEY_INSPECTED);
                if (attr != null && (value = attr.getValue()) instanceof BooleanExpression) {
                    if (renderer == null) {
                        return Double.toString(((BooleanExpression)value).getValue(1.0));
                    }
                    return renderer.formatNumber(((BooleanExpression)value).getValue(1.0));
                }
                return null;
            }
            case TESTED: {
                attr = this.getAttribute(BooleanAttribute.KEY_INFLIGHT);
                if (attr != null) {
                    Object value = attr.getValue();
                    if (value instanceof BooleanExpression) {
                        StringBuffer sb = new StringBuffer();
                        try {
                            ((BooleanExpression)value).export(sb, renderer);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return sb.toString();
                    }
                    return value.toString();
                }
                return null;
            }
            case TESTED_VALUE: {
                Object value;
                attr = this.getAttribute(BooleanAttribute.KEY_INFLIGHT);
                if (attr != null && (value = attr.getValue()) instanceof BooleanExpression) {
                    if (renderer == null) {
                        return Double.toString(((BooleanExpression)value).getValue(1.0));
                    }
                    return renderer.formatNumber(((BooleanExpression)value).getValue(1.0));
                }
                return null;
            }
            case ATTRIBS: {
                return this.printAttributes(renderer);
            }
        }
        return null;
    }

    private String printAttributes(ArborRenderer renderer) {
        StringBuffer sb = new StringBuffer(128);
        if (this._attributes != null) {
            for (BooleanAttribute attribute : this._attributes.values()) {
                if (attribute.getType() == AttrType.FIELD) continue;
                sb.append("'").append(attribute.getName()).append("'");
                if (attribute.getType() != AttrType.ALIAS) {
                    sb.append("=");
                    if (attribute.getType() == AttrType.NUMBER) {
                        String value = attribute.getValue().toString();
                        try {
                            double dvalue = Double.parseDouble(value);
                            sb.append(renderer.formatNumber(dvalue));
                        }
                        catch (NumberFormatException e) {
                            _LOG.log(Level.INFO, "Number attribute for '" + this.getName() + "' is not double", e);
                            sb.append(value);
                        }
                    } else {
                        sb.append(attribute.getValue().toString());
                    }
                }
                sb.append("; ");
            }
            int len = sb.length();
            if (len > 2 && sb.charAt(len - 1) == ' ' && sb.charAt(len - 2) == ',') {
                sb.delete(len - 2, len);
            }
        }
        return sb.toString();
    }
}

