/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CAACut
implements Comparable<CAACut>,
Cut {
    static final Object __undefValue = new Object(){

        public String toString() {
            return ResCompute.getString("CAA_VALUE_UNDEF");
        }
    };
    Attr.Key _attribute;
    List<CAAEvt> _values;

    public CAACut(Attr.Key attribute, List<Object> values) {
        this._attribute = attribute;
        this._values = new ArrayList<CAAEvt>();
        for (Object val : values) {
            this._values.add(new CAAEvt(val));
        }
        Collections.sort(this._values);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._attribute.getName()).append(" : ");
        sb.append("{");
        for (int i = 0; i < this._values.size(); ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(this._values.get((int)i)._value);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(CAACut o) {
        if (!this._attribute.equals(o._attribute)) {
            throw new UnsupportedOperationException();
        }
        int diff = this._values.size() - o._values.size();
        if (diff != 0) {
            return diff;
        }
        for (int i = 0; i < this._values.size(); ++i) {
            CAAEvt oevt;
            CAAEvt evt = this._values.get(i);
            diff = evt.compareTo(oevt = o._values.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    @Override
    public int getOrder() {
        return this._values.size();
    }

    @Override
    public Evt getEvent(int idx) {
        return this._values.get(idx);
    }

    @Override
    public double getProbability() {
        return Double.NaN;
    }

    public Attr.Key getAttribute() {
        return this._attribute;
    }

    public String printCuts() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this._values.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (this._values.get((int)i)._value == __undefValue) {
                sb.append(this._values.get((int)i)._value);
                continue;
            }
            sb.append("[");
            sb.append(this._values.get((int)i)._value);
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    class CAAEvt
    implements Comparable<CAAEvt>,
    Evt {
        Object _value;

        public CAAEvt(Object val) {
            this._value = val;
        }

        @Override
        public int compareTo(CAAEvt o) {
            if (o._value.equals(this._value)) {
                return 0;
            }
            if (this._value == __undefValue) {
                return 1;
            }
            if (o._value == __undefValue) {
                return -1;
            }
            if (!(this._value instanceof Comparable)) {
                throw new UnsupportedOperationException();
            }
            return ((Comparable)this._value).compareTo(o._value);
        }

        public String toString() {
            return this._value.toString();
        }

        @Override
        public String getName() {
            StringBuffer sb = new StringBuffer(256);
            sb.append("'").append(CAACut.this._attribute.getName());
            sb.append("'=[").append(this._value.toString());
            sb.append("]");
            return sb.toString();
        }

        @Override
        public double getProbability() {
            return Double.NaN;
        }

        @Override
        public boolean isExtern() {
            return false;
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public Object getInfo(Evt.KeyInfo key, ArborRenderer renderer) {
            return null;
        }

        @Override
        public Collection<? extends Attr> getAttributs() {
            return Collections.emptyList();
        }

        @Override
        public Attr getAttribute(Attr.Key key) {
            return null;
        }
    }
}

