/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanCut;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.CAACut;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CAAItem
implements MCS,
Cut {
    CAACut _cut;
    BooleanMCS _mcs;
    Map<CAACut, CAAItem> _subCuts;
    CAAItem[] _childrenCuts;
    double _probability;
    int _level;
    CAAItem _parent;
    List<MCS.InfoOrder> _infoOrders;

    public CAAItem(CAACut caaCut, BooleanStore store, int level, CAAItem parentItem) {
        this._cut = caaCut;
        this._mcs = new BooleanMCS(store);
        this._subCuts = new TreeMap<CAACut, CAAItem>();
        this._childrenCuts = null;
        this._level = level;
        this._parent = parentItem;
    }

    public void addCut(Cut cut) {
        this._mcs.addCut((BooleanCut)cut);
    }

    public void prepare() {
        this._childrenCuts = new CAAItem[this._subCuts.size()];
        int idx = 0;
        for (CAAItem child : this._subCuts.values()) {
            this._childrenCuts[idx++] = child;
            child.prepare();
        }
        this.prepareInfoOrders();
        this._mcs.prepare();
        this._probability = 0.0;
        for (int i = this._mcs.getOrderMax() - 1; i >= 0; --i) {
            this._probability += this._mcs.getOrderProbability(i);
        }
    }

    public BooleanStore getStore() {
        return this._mcs.getStore();
    }

    public CAACut getCAACut() {
        return this._cut;
    }

    public MCS getMCS() {
        return this._mcs;
    }

    public int getNumber() {
        return this._mcs.getCutCount();
    }

    public int getChildCount() {
        return this._childrenCuts.length;
    }

    public CAAItem getChildAt(int i) {
        return this._childrenCuts[i];
    }

    public String toString() {
        if (this._cut == null) {
            return ResCompute.getString("CAA_MCS_ORIGIN");
        }
        return this._cut.toString();
    }

    @Override
    public int getOrder() {
        return this._cut.getOrder();
    }

    @Override
    public Evt getEvent(int idx) {
        return this._cut.getEvent(idx);
    }

    @Override
    public double getProbability() {
        return this._probability;
    }

    public int getLevel() {
        return this._level;
    }

    public CAAItem getParent() {
        return this._parent;
    }

    @Override
    public int getCutCount() {
        return this._subCuts.size();
    }

    @Override
    public MCS.CutIterator cutIterate() {
        return new MCS.CutIterator(){
            Iterator<CAAItem> _iterator;
            {
                this._iterator = CAAItem.this._subCuts.values().iterator();
            }

            @Override
            public Cut next() {
                return this._iterator.next();
            }

            @Override
            public boolean hasNext() {
                return this._iterator.hasNext();
            }
        };
    }

    @Override
    public int getRowCount() {
        return 0;
    }

    @Override
    public Cut getRowCut(int row) {
        return null;
    }

    @Override
    public Evt getRowEvent(int row) {
        return null;
    }

    @Override
    public int getRowIndexCut(int row) {
        return -1;
    }

    private void prepareInfoOrders() {
        this._infoOrders = new ArrayList<MCS.InfoOrder>();
        MCS.CutIterator iCut = this.cutIterate();
        while (iCut.hasNext()) {
            Cut cut = iCut.next();
            int order = cut.getOrder();
            while (order >= this._infoOrders.size()) {
                this._infoOrders.add(new MCS.InfoOrder(order, 0, 0.0));
            }
            MCS.InfoOrder info = this._infoOrders.get(order);
            info.incInfo(1, cut.getProbability());
        }
    }

    @Override
    public int getOrderMax() {
        return this._infoOrders.size();
    }

    @Override
    public int getOrderNumber(int idx) {
        return this._infoOrders.get(idx).getNumber();
    }

    @Override
    public double getOrderProbability(int idx) {
        return this._infoOrders.get(idx).getProbability();
    }
}

