/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderControl;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import java.util.ArrayList;
import java.util.List;

public abstract class MCSReaderHelper
implements MCSReaderControl {
    static final int PROP_DEF_TREE_COMPUTE_MCS_LIMIT = 10000000;
    static final String PROP_TREE_COMPUTE_MCS_LIMIT = "cecilia.ft.compute.mcs.ReaderLimited";
    int _nbrKeepCut = 0;
    int _nbrLimitCut;
    int _orderLimit;
    List<Cpt> _counters;

    MCSReaderHelper(int limit) {
        this._nbrLimitCut = limit;
        this._orderLimit = Integer.MAX_VALUE;
        this._counters = new ArrayList<Cpt>(16);
    }

    public MCSReaderHelper() {
        this(Integer.getInteger(PROP_TREE_COMPUTE_MCS_LIMIT, 10000000));
    }

    @Override
    public boolean addCuts(List<BooleanNode> cut) {
        if (this._nbrLimitCut < 0) {
            return true;
        }
        int order = cut.size();
        while (this._counters.size() <= order) {
            this._counters.add(new Cpt());
        }
        ++this._counters.get((int)order)._nbr;
        if (order >= this._orderLimit) {
            return false;
        }
        ++this._nbrKeepCut;
        if (this._nbrKeepCut <= this._nbrLimitCut) {
            return true;
        }
        int cpt = 0;
        for (int i = 0; i < this._counters.size(); ++i) {
            if ((cpt += this._counters.get((int)i)._nbr) <= this._nbrLimitCut) continue;
            int oldLimit = Math.min(this._orderLimit, this._counters.size());
            this._orderLimit = i;
            do {
                this._nbrKeepCut -= this._counters.get((int)i++)._nbr;
            } while (i < oldLimit);
            break;
        }
        return order < this._orderLimit;
    }

    @Override
    public int getLimitOrder() {
        return this._orderLimit;
    }

    @Override
    public boolean hasLimited() {
        return this._orderLimit != Integer.MAX_VALUE;
    }

    @Override
    public int[] getOrders() {
        int[] result = new int[this._counters.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this._counters.get((int)i)._nbr;
        }
        return result;
    }

    @Override
    public String getWarningMsg() {
        int nbrCuts = 0;
        for (int i = this._orderLimit; i < this._counters.size(); ++i) {
            nbrCuts += this._counters.get((int)i)._nbr;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ResCompute.msgFormat("MSG_RESULT_READ_LIMIT", this._nbrLimitCut, this._orderLimit, nbrCuts));
        return sb.toString();
    }

    static class Cpt {
        int _nbr = 0;

        Cpt() {
        }

        public String toString() {
            return Integer.toString(this._nbr);
        }
    }
}

