/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainerWithMsg;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIStoreLoad;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class PluginCmdCuts
extends AbstractPluginModel {
    private static Logger _LOG = Logger.getLogger(PluginCmdCuts.class.getPackage().getName());
    private static final String LOG_NAME = PluginCmdCuts.class.getSimpleName();
    protected static final String KEY_DATUM = ComputeType.MCS.toString();

    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        return null;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
    }

    @Override
    public boolean withParameters() {
        return false;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    @Override
    public IOParameters getIOParameters() {
        return null;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCompute.getString("PLUG_CMD_NOMINAL_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "ctrl alt C";
        }
        return ResMsgVoc.getString("VOC_ERROR");
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoCompute.getImageIcon("PLUGIN_MCS");
        }
        return super.getIcon(key);
    }

    private String createXMLDatum() {
        StringBuffer out = new StringBuffer(512);
        out.append("<?xml version='1.0'>\n");
        out.append("<").append("cecilia.datum").append(">\n");
        out.append("  <").append("tree");
        out.append(" ").append("path").append("=''");
        out.append(">\n");
        out.append("    <").append("compute");
        out.append(" ").append("type").append("='MCS'");
        out.append(">\n");
        out.append("    </").append("compute").append(">\n");
        out.append("  </").append("tree").append(">\n");
        out.append("</").append("cecilia.datum").append(">\n");
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(Plugable launcher, Object sessionParams) {
        _LOG.finer("Entering : " + LOG_NAME + ".createSession");
        PluginModel pluginEngine = launcher.getPlugin(PluginCmdEngine.class.getName());
        if (pluginEngine == null || !(pluginEngine instanceof EngineBDDConfig)) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No EngineBDDConfig");
            return;
        }
        EngineBDDConfig engineBDDCfg = (EngineBDDConfig)((Object)pluginEngine);
        InfoDatum idatum = launcher.getDatum(this.createXMLDatum());
        if (idatum == null) {
            return;
        }
        String msgError = idatum.getParameters().get("tree.error");
        if (msgError != null && !msgError.isEmpty()) {
            JOptionCecilia.showMessageDialog(launcher.getWindow(), msgError, this.getInfo("plugin.name"), 0);
            return;
        }
        _LOG.finer("Tracing : " + LOG_NAME + ".createSession - getDatum");
        File dagFile = idatum.getInputFiles().get("ceciliabdd.file.dag");
        if (dagFile == null || !dagFile.exists() || dagFile.length() == 0L) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No inputFile('ceciliabdd.file.dag')");
            return;
        }
        File xmlFile = idatum.getInputFiles().get("ceciliabdd.file.xml");
        if (xmlFile == null || !xmlFile.exists() || xmlFile.length() == 0L) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No inputFile('ceciliabdd.file.res')");
            return;
        }
        boolean bSuccess = false;
        StringBuffer pathTree = new StringBuffer();
        try {
            ParamComputeMCS iparameters;
            EngineBDDMCS engineBDD;
            BooleanResult results;
            ParamComputeMCS parameters;
            BooleanStore store;
            block39: {
                store = new BooleanStore();
                parameters = new ParamComputeMCS();
                results = new BooleanResult(store, parameters);
                engineBDD = new EngineBDDMCS(engineBDDCfg);
                TaskContainerWithMsg task = new TaskContainerWithMsg(launcher, this.getInfo("plugin.name"));
                TaskIStoreLoad bTask = new TaskIStoreLoad(task, store, xmlFile);
                bTask.run();
                if (!((TaskItem)bTask).continueWhenFinnished()) {
                    return;
                }
                _LOG.finer("Tracing : " + LOG_NAME + ".createSession - TaskIStoreLoad.run");
                pathTree.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
                pathTree.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
                pathTree.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
                pathTree.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
                if (!store.getInfo(BooleanStore.INFO_TREE).equals(store.getRoot().getName())) {
                    pathTree.append(" : ").append(store.getRoot().getName());
                }
                task.setTitle(ResCompute.getString("PLUG_CMD_NOMINAL_HEADER") + pathTree.toString());
                engineBDD.defineComputeType(store);
                iparameters = null;
                File paramFile = idatum.getInputFiles().get("result.abstract");
                if (paramFile != null && paramFile.exists() && paramFile.length() != 0L) {
                    iparameters = new ParamComputeMCS();
                    try {
                        iparameters.loadFromXML(new FileInputStream(paramFile));
                    }
                    catch (IOException e) {
                        _LOG.log(Level.WARNING, "Error during read 'result.abstract'", e);
                        iparameters = null;
                        break block39;
                    }
                    parameters.copy(iparameters);
                }
            }
            if (store.oneOrMoreLeavesWithoutProbability()) {
                parameters.setDefaultTypeProbability(TypeProbability.NONE);
            } else {
                String latentProbability;
                if (iparameters == null) {
                    double missionTime = store.getAverageFlightDuration();
                    if (!Double.isNaN(missionTime)) {
                        parameters.setMissionTimeSec(missionTime);
                    } else {
                        missionTime = store.getDefaultMissionTime();
                        if (!Double.isNaN(missionTime)) {
                            parameters.setMissionTimeSec(missionTime);
                        }
                    }
                }
                if ((latentProbability = store.getInfo(BooleanStore.INFO_LATENT_PROBABILITY)) != null && latentProbability.length() > 0) {
                    try {
                        parameters.setDefaultTypeProbability(TypeProbability.valueOf(latentProbability));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (parameters.getTypeProbability() == null) {
                    parameters.setTypeProbability(TypeProbability.BDD);
                }
            }
            String readOnly = store.getInfo(BooleanStore.INFO_READONLY);
            if (readOnly != null && readOnly.equals("true")) {
                parameters.setReferenceCompute(false, false);
            } else if (iparameters != null) {
                parameters.setReferenceCompute(false, true);
            } else {
                parameters.setReferenceCompute(true, true);
            }
            parameters.setReferenceIgnore(false, true);
            _LOG.finer("Tracing : " + LOG_NAME + ".createSession - Display parameters dialog - started");
            if (!parameters.displayDialog(store, launcher)) {
                return;
            }
            _LOG.finer("Tracing : " + LOG_NAME + ".createSession - Display parameters dialog - finalized");
            boolean bLaunchCompute = true;
            boolean bComputeProbability = true;
            if (iparameters != null) {
                boolean bSameCRCXml = false;
                String keyCRCXmlEquals = idatum.getParameters().get("CRC.Xml.equals");
                if (keyCRCXmlEquals != null) {
                    bSameCRCXml = keyCRCXmlEquals.equals("true");
                }
                if (iparameters.isCompatible(parameters, bSameCRCXml)) {
                    bLaunchCompute = false;
                    if (iparameters.equals(parameters)) {
                        bComputeProbability = false;
                    }
                }
            }
            if (bLaunchCompute) {
                ComputeMCS compute = new ComputeMCS(parameters, results);
                compute.defineFiles(dagFile, xmlFile);
                compute.launchCompute(idatum, launcher, engineBDD, pathTree.toString());
            } else {
                ComputeMCS compute = new ComputeMCS(parameters, results);
                compute.defineFiles(dagFile, xmlFile);
                compute.launchDisplay(idatum, launcher, bComputeProbability, pathTree.toString());
            }
            bSuccess = true;
        }
        finally {
            if (!bSuccess) {
                if (dagFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !dagFile.delete())) {
                    dagFile.deleteOnExit();
                }
                if (xmlFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !xmlFile.delete())) {
                    xmlFile.deleteOnExit();
                }
            }
            _LOG.finer("Exiting : " + LOG_NAME + ".createSession");
        }
    }
}

