/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineProcess;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PluginCmdEngine
extends AbstractPluginModel
implements PluginMAction,
EngineBDDConfig {
    private static Logger _LOG = Logger.getLogger(PluginCmdEngine.class.getPackage().getName());
    public static final String PROP_COMPUTE_KEEPFILE = "cecilia.ft.compute.KeepFile";
    public static final String PROP_COMPUTE_KEEPFILE_MEL = "cecilia.ft.compute.KeepFile.MEL";
    public static final String PROP_BDDENGINE_LOCAL = "cecilia.ft.engine.select.Local";
    public static final String PROP_BDDENGINE_LOCAL_DISABLE = "cecilia.ft.engine.select.LocalDisable";
    public static final String PROP_BDDENGINE_DISTRIB = "cecilia.ft.engine.select.Distrib";
    public static final String PROP_BDDENGINE_DISTRIB_DISABLE = "cecilia.ft.engine.select.DistribDisable";
    public static final String PROP_BDDENGINE_PATH = "cecilia.ft.engine.define.Path";
    public static final String PROP_BDDENGINE_EXEC = "cecilia.ft.engine.define.Exec";
    public static final String PROP_BDDENGINE_CTRL = "cecilia.ft.engine.define.Ctrl";
    public static final String PROP_BDDENGINE_CTRL_OPTIONS = "cecilia.ft.engine.define.CtrlOptions";
    public static final String PROP_BDDENGINE_MEMORYMAX = "cecilia.ft.engine.memory.Max";
    static final String PROP_BDDENGINE_MEMORYMAX_LOCAL = "cecilia.ft.engine.memory.MaxLocal";
    static final String PROP_BDDENGINE_MEMORYMAX_DISTRIB = "cecilia.ft.engine.memory.MaxDistrib";
    public static final String PROP_BDDENGINE_TYPE_DEFAULT = "cecilia.ft.engine.type.Default";
    public static final String PROP_BDDENGINE_TYPE_LOCAL_DISABLE = "cecilia.ft.engine.type.LocalDisable";
    public static final String PROP_BDDENGINE_TYPE_DISTRIB_DISABLE = "cecilia.ft.engine.type.DistribDisable";
    public static final String PROP_BDDENGINE_TYPE_AUTO_DISABLE = "cecilia.ft.engine.type.AutomaticDisable";
    public static final String PROP_BDDENGINE_TYPE_AUTO_WLEAF = "cecilia.ft.engine.type.AutomaticWeightLeaf";
    public static final String PROP_BDDENGINE_TYPE_AUTO_WGATE = "cecilia.ft.engine.type.AutomaticWeightGate";
    public static final String PROP_BDDENGINE_TYPE_AUTO_LIMIT = "cecilia.ft.engine.type.AutomaticLimit";
    Plugable _launcher = null;
    public static final String DEFAULT_DEFINE_MEMORY_LIST = "2,4,6,8,12,14,16,24,30,32,45,48,60,64";
    public static final String PROP_DEFINE_MEMORY_LIST = "cecilia.ft.engine.memory.List";
    boolean _engineLocalCeciliaBDDIsValid;
    boolean _engineLocalAralia4IsValid;
    boolean _engineLocalIsValid;
    EngineBDDConfig.EngineType _engineLocal;
    EngineBDDConfig.EngineType _engineDistrib;
    boolean _engineDistribIsValid;
    boolean _computeLocalIsValid;
    boolean _computeAutoIsValid;
    boolean _computeDistribIsValid;
    EngineBDDConfig.ComputeType _computeType;
    public static final String OPT_ENGINE_CECILIA_CFG_TYPE = PluginCmdEngine.class.getName() + "#EngineCeciliaCfgType";
    public static final String OPT_ENGINE_CECILIA_CFG_USER = PluginCmdEngine.class.getName() + "#EngineCeciliaCfgUser";
    public static final String OPT_ENGINE_ARALIA_CFG_TYPE = PluginCmdEngine.class.getName() + "#EngineAraliaCfgType";
    public static final String OPT_ENGINE_ARALIA_CFG_USER = PluginCmdEngine.class.getName() + "#EngineAraliaCfgUser";
    public static final String OPT_ENGINE_LOCAL = PluginCmdEngine.class.getName() + "#EngineLocal";
    public static final String OPT_ENGINE_DISTRIB = PluginCmdEngine.class.getName() + "#EngineDistrib";
    public static final String OPT_COMPUTE_TYPE = PluginCmdEngine.class.getName() + "#ComputeType";
    EngineOptsPanel _opts = null;

    @Override
    public boolean withParameters() {
        return false;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    @Override
    public IOParameters getIOParameters() {
        return null;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCompute.getString("PLUG_CMD_ENGINE_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCompute.getString("PLUG_CMD_ENGINE_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    @Override
    public void createSession(Plugable launcher, Object parameters) {
        if (parameters != null && parameters instanceof File) {
            if (this._engineLocal == null) {
                throw new RuntimeException("Engine bdd unavailable !");
            }
            ArrayList<String> execArray = this.createExecLine(this._engineLocal);
            if (execArray == null) {
                throw new RuntimeException("Engine bdd bad configuration !");
            }
            File dagFile = (File)parameters;
            int execSize = execArray.size();
            switch (this._engineLocal) {
                case Aralia4: {
                    String[] args = new String[execSize + 1];
                    execArray.toArray(args);
                    args[execSize] = dagFile.getAbsolutePath();
                    EngineVerify ctrl = new EngineVerify();
                    EngineProcess thread = new EngineProcess(args, null, "exit;\n", ctrl);
                    thread.run();
                    if (!ctrl._withError) break;
                    if (ctrl._errorBuffer.length() >= 1024) {
                        ctrl._errorBuffer.append("\n...\n");
                    }
                    throw new RuntimeException(ctrl._errorBuffer.toString());
                }
                case CeciliaBDD: {
                    String[] args = new String[execSize + 3];
                    execArray.toArray(args);
                    args[execSize + 0] = "--verify";
                    args[execSize + 1] = "-f";
                    args[execSize + 2] = dagFile.getAbsolutePath();
                    EngineVerify ctrl = new EngineVerify();
                    EngineProcess thread = new EngineProcess(args, null, "", ctrl);
                    thread.run();
                    if (!ctrl._withError) break;
                    if (ctrl._errorBuffer.length() >= 1024) {
                        ctrl._errorBuffer.append("\n...\n");
                    }
                    throw new RuntimeException(ctrl._errorBuffer.toString());
                }
            }
        }
    }

    public boolean verifyEngine(EngineBDDConfig.EngineType engine) {
        String enginePath = System.getProperty(PROP_BDDENGINE_PATH + engine.toString());
        if (enginePath == null && this._launcher != null) {
            enginePath = PlugableUtility.getStrOpt(this._launcher, "plugable.option.path", ".");
        }
        StringBuffer engineFile = new StringBuffer(1024);
        engineFile.append(new File(enginePath).getAbsolutePath());
        engineFile.append(File.separator);
        engineFile.append(System.getProperty(PROP_BDDENGINE_EXEC + engine.toString()));
        if (!new File(engineFile.toString()).isFile()) {
            _LOG.finest("Don't find : " + engineFile);
            return false;
        }
        ArrayList<String> execArray = this.createExecLine(engine);
        if (execArray == null) {
            return false;
        }
        String[] args = new String[execArray.size()];
        EngineVerify ctrl = new EngineVerify();
        String inputCmd = engine == EngineBDDConfig.EngineType.Aralia4 ? "exit;\n" : "";
        EngineProcess thread = new EngineProcess(execArray.toArray(args), null, inputCmd, ctrl);
        thread.run();
        switch (engine) {
            case Aralia4: {
                if (!ctrl._withError) break;
                if (ctrl._errorBuffer.length() >= 1024) {
                    ctrl._errorBuffer.append("\n...\n");
                }
                _LOG.info("Aralia4 engine with error : \n" + ctrl._errorBuffer.toString());
                return false;
            }
            case CeciliaBDD: {
                if (!ctrl._withError || ctrl._errorBuffer.toString().contains("No arguments files")) break;
                if (ctrl._errorBuffer.length() >= 1024) {
                    ctrl._errorBuffer.append("\n...\n");
                }
                _LOG.info("CeciliaBDD engine with error : \n" + ctrl._errorBuffer.toString());
                return false;
            }
        }
        return true;
    }

    private ArrayList<String> createExecLine(EngineBDDConfig.EngineType engine) {
        String enginePath = System.getProperty(PROP_BDDENGINE_PATH + engine.toString());
        if (enginePath == null && this._launcher != null) {
            enginePath = PlugableUtility.getStrOpt(this._launcher, "plugable.option.path", ".");
        }
        StringBuffer engineFile = new StringBuffer(1024);
        engineFile.append(new File(enginePath).getAbsolutePath());
        engineFile.append(File.separator);
        engineFile.append(System.getProperty(PROP_BDDENGINE_EXEC + engine.toString()));
        if (!new File(engineFile.toString()).isFile()) {
            _LOG.finest("Don't find (in createExecLine) : " + engineFile.toString());
            return null;
        }
        ArrayList<String> execArray = null;
        String ctrlFile = System.getProperty(PROP_BDDENGINE_CTRL + engine.toString());
        if (ctrlFile != null && ctrlFile.length() > 0) {
            execArray = new ArrayList(20);
            if (new File(ctrlFile).isFile()) {
                execArray.add(ctrlFile);
            } else {
                StringBuffer execLine = new StringBuffer();
                execLine.append(new File(enginePath).getAbsolutePath());
                execLine.append(File.separator);
                execLine.append(ctrlFile);
                if (!new File(execLine.toString()).isFile()) {
                    _LOG.finest("Don't find (in createExecLine) : " + execLine.toString());
                    return null;
                }
                execArray.add(execLine.toString());
            }
            String ctrlOpts = System.getProperty(PROP_BDDENGINE_CTRL_OPTIONS + engine.toString());
            if (ctrlOpts != null && ctrlOpts.length() > 0) {
                StringTokenizer st = new StringTokenizer(ctrlOpts);
                while (st.hasMoreTokens()) {
                    execArray.add(st.nextToken());
                }
            }
        } else {
            execArray = new ArrayList<String>(10);
        }
        execArray.add(engineFile.toString());
        return execArray;
    }

    @Override
    public List<String> createExecLine() {
        return this.createExecLine(this._engineLocal);
    }

    @Override
    public EngineBDDConfig.EngineType getEngineType(boolean distrib) {
        return distrib ? this._engineDistrib : this._engineLocal;
    }

    private void setComputeType(EngineBDDConfig.ComputeType value) {
        this._computeType = value;
    }

    @Override
    public EngineBDDConfig.ComputeType getComputeType() {
        if (this._computeType == null) {
            throw new NullPointerException();
        }
        return this._computeType;
    }

    @Override
    public Collection<Integer> getMemoryItems() {
        String property = System.getProperty(PROP_DEFINE_MEMORY_LIST, DEFAULT_DEFINE_MEMORY_LIST);
        List<String> items = Arrays.asList(property.split(","));
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (String item : items) {
            try {
                int value = Integer.parseInt(item);
                if (value < 0) continue;
                result.add(value);
            }
            catch (NumberFormatException e) {
                _LOG.info("Error parsing property 'cecilia.ft.engine.memory.List' for item '" + item + "'");
            }
        }
        return result;
    }

    @Override
    public int getMemoryMax(EngineBDDConfig.EngineType engine) {
        return Integer.getInteger(PROP_BDDENGINE_MEMORYMAX + engine, 64);
    }

    @Override
    public int getMemoryMax(EngineBDDConfig.ComputeType compute) {
        if (compute == EngineBDDConfig.ComputeType.LOCAL) {
            return Integer.getInteger(PROP_BDDENGINE_MEMORYMAX_LOCAL, 12);
        }
        return Integer.getInteger(PROP_BDDENGINE_MEMORYMAX_DISTRIB, 64);
    }

    private void validCompute(EngineBDDConfig.ComputeType computeType) {
        switch (computeType) {
            case LOCAL: {
                if (!this._computeLocalIsValid || !this._engineLocalIsValid) break;
                this.setComputeType(computeType);
                break;
            }
            case AUTOMATIC: {
                if (!this._engineLocalIsValid) break;
                this.setComputeType(computeType);
                break;
            }
            default: {
                this.setComputeType(computeType);
            }
        }
    }

    private void prepareOptions() {
        this._engineLocalCeciliaBDDIsValid = this.verifyEngine(EngineBDDConfig.EngineType.CeciliaBDD);
        if (!this._engineLocalCeciliaBDDIsValid) {
            _LOG.fine("BoolEquation - Pas de calcul local avec CeciliaBDD");
        }
        this._engineLocalAralia4IsValid = this.verifyEngine(EngineBDDConfig.EngineType.Aralia4);
        if (!this._engineLocalAralia4IsValid) {
            _LOG.fine("BoolEquation - Pas de calcul local avec Aralia4");
        }
        this._engineLocalIsValid = this._engineLocalCeciliaBDDIsValid || this._engineLocalAralia4IsValid;
        this._engineDistribIsValid = true;
        if (!this._engineLocalIsValid) {
            this.setComputeType(EngineBDDConfig.ComputeType.DISTRIB);
            this._computeLocalIsValid = false;
            this._computeAutoIsValid = false;
            this._computeDistribIsValid = false;
        } else {
            this._computeLocalIsValid = !Boolean.getBoolean(PROP_BDDENGINE_TYPE_LOCAL_DISABLE);
            this._computeAutoIsValid = !Boolean.getBoolean(PROP_BDDENGINE_TYPE_AUTO_DISABLE);
            this._computeDistribIsValid = !Boolean.getBoolean(PROP_BDDENGINE_TYPE_DISTRIB_DISABLE);
            int nbrDisable = 0;
            if (!this._computeLocalIsValid) {
                ++nbrDisable;
            }
            if (!this._computeAutoIsValid) {
                ++nbrDisable;
            }
            if (!this._computeDistribIsValid) {
                ++nbrDisable;
            }
            this.setComputeType(EngineBDDConfig.ComputeType.LOCAL);
            this.validCompute(EngineBDDConfig.ComputeType.valueOf(System.getProperty(PROP_BDDENGINE_TYPE_DEFAULT, EngineBDDConfig.ComputeType.LOCAL.toString())));
            if (nbrDisable == 2) {
                if (this._computeLocalIsValid) {
                    this.setComputeType(EngineBDDConfig.ComputeType.LOCAL);
                } else if (this._computeAutoIsValid) {
                    this.setComputeType(EngineBDDConfig.ComputeType.AUTOMATIC);
                } else if (this._computeDistribIsValid) {
                    this.setComputeType(EngineBDDConfig.ComputeType.DISTRIB);
                }
            }
        }
        this._engineLocal = EngineBDDConfig.EngineType.valueOf(System.getProperty(PROP_BDDENGINE_LOCAL, EngineBDDConfig.EngineType.CeciliaBDD.toString()));
        if (this._engineLocal == null) {
            this._engineLocal = EngineBDDConfig.EngineType.CeciliaBDD;
        }
        if (!this._engineLocalIsValid) {
            this._engineLocal = null;
        } else if (this._engineLocal == EngineBDDConfig.EngineType.CeciliaBDD && !this._engineLocalCeciliaBDDIsValid) {
            this._engineLocal = EngineBDDConfig.EngineType.Aralia4;
        } else if (this._engineLocal == EngineBDDConfig.EngineType.Aralia4 && !this._engineLocalAralia4IsValid) {
            this._engineLocal = EngineBDDConfig.EngineType.CeciliaBDD;
        }
        this._engineDistrib = EngineBDDConfig.EngineType.valueOf(System.getProperty(PROP_BDDENGINE_DISTRIB, EngineBDDConfig.EngineType.Aralia4.toString()));
        if (this._engineDistrib == null) {
            this._engineDistrib = EngineBDDConfig.EngineType.Aralia4;
        }
    }

    private void refreshOptionsFromLauncher() {
        EngineBDDConfig.ComputeType computeType;
        String strType;
        EngineBDDConfig.EngineType engineDistrib;
        EngineBDDConfig.EngineType engineLocal;
        String strEngine;
        if (!(Boolean.getBoolean(PROP_BDDENGINE_LOCAL_DISABLE) || (strEngine = this._launcher.getOption(OPT_ENGINE_LOCAL)) == null || strEngine.length() == 0 || (engineLocal = EngineBDDConfig.EngineType.valueOf(strEngine)) == null || engineLocal == EngineBDDConfig.EngineType.Aralia4 && !this._engineLocalAralia4IsValid || engineLocal == EngineBDDConfig.EngineType.CeciliaBDD && !this._engineLocalCeciliaBDDIsValid)) {
            this._engineLocal = engineLocal;
        }
        if (!Boolean.getBoolean(PROP_BDDENGINE_DISTRIB_DISABLE) && (strEngine = this._launcher.getOption(OPT_ENGINE_DISTRIB)) != null && strEngine.length() != 0 && (engineDistrib = EngineBDDConfig.EngineType.valueOf(strEngine)) != null) {
            this._engineDistrib = engineDistrib;
        }
        if ((strType = this._launcher.getOption(OPT_COMPUTE_TYPE)) != null && strType.length() != 0 && (computeType = EngineBDDConfig.ComputeType.valueOf(strType)) != null) {
            switch (computeType) {
                case LOCAL: {
                    if (!this._computeLocalIsValid || !this._engineLocalIsValid) break;
                    this.setComputeType(computeType);
                    break;
                }
                case AUTOMATIC: {
                    if (!this._engineLocalIsValid) break;
                    this.setComputeType(computeType);
                    break;
                }
                default: {
                    this.setComputeType(computeType);
                }
            }
        }
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this._launcher = launcher;
        if (this._computeType == null) {
            this.prepareOptions();
        }
        if (this._opts == null) {
            this._opts = new EngineOptsPanel();
        }
        this.refreshOptionsFromLauncher();
        this._opts.refreshOptions();
        return this._opts;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this._launcher = launcher;
        if (this._computeType == null) {
            this.prepareOptions();
        }
        this.refreshOptionsFromLauncher();
        if (this._opts != null) {
            this._opts.refreshOptions();
        }
    }

    class EngineOptsPanel
    extends JPanel
    implements PlugPanel {
        JComboBox _choiceEngineLocal;
        JComboBox _choiceEngineDistrib;
        JRadioButton _choiceComputeLocal;
        JRadioButton _choiceComputeAutomatic;
        JRadioButton _choiceComputeDistrib;

        public void refreshOptions() {
            this._choiceEngineLocal.setSelectedItem((Object)PluginCmdEngine.this._engineLocal);
            this._choiceEngineDistrib.setSelectedItem((Object)PluginCmdEngine.this._engineDistrib);
            switch (PluginCmdEngine.this._computeType) {
                case LOCAL: {
                    this._choiceComputeLocal.setSelected(true);
                    break;
                }
                case AUTOMATIC: {
                    this._choiceComputeAutomatic.setSelected(true);
                    break;
                }
                case DISTRIB: {
                    this._choiceComputeDistrib.setSelected(true);
                }
            }
        }

        public EngineOptsPanel() {
            super(new GridBagLayout());
            int optLine = 0;
            JPanel root = new JPanel(new GridBagLayout());
            JLabel labelEngineLocal = new JLabel(ResCompute.getString("DLG_ENGINE_LBL_FOR_LOCAL"));
            JLabel labelEngineDistrib = new JLabel(ResCompute.getString("DLG_ENGINE_LBL_FOR_DISTRIB"));
            this._choiceEngineLocal = new JComboBox();
            if (PluginCmdEngine.this._engineLocalCeciliaBDDIsValid) {
                this._choiceEngineLocal.addItem(EngineBDDConfig.EngineType.CeciliaBDD);
            }
            if (PluginCmdEngine.this._engineLocalAralia4IsValid) {
                this._choiceEngineLocal.addItem(EngineBDDConfig.EngineType.Aralia4);
            }
            this._choiceEngineLocal.setMinimumSize(new Dimension(300, 20));
            if (!PluginCmdEngine.this._engineLocalIsValid || Boolean.getBoolean(PluginCmdEngine.PROP_BDDENGINE_LOCAL_DISABLE)) {
                labelEngineLocal.setEnabled(false);
                this._choiceEngineLocal.setEnabled(false);
            }
            this._choiceEngineLocal.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PluginCmdEngine.this._engineLocal = (EngineBDDConfig.EngineType)((Object)EngineOptsPanel.this._choiceEngineLocal.getSelectedItem());
                    PluginCmdEngine.this._launcher.setOption(OPT_ENGINE_LOCAL, PluginCmdEngine.this._engineLocal.toString());
                }
            });
            this._choiceEngineDistrib = new JComboBox();
            this._choiceEngineDistrib.addItem(EngineBDDConfig.EngineType.Aralia4);
            this._choiceEngineDistrib.addItem(EngineBDDConfig.EngineType.CeciliaBDD);
            this._choiceEngineDistrib.setMinimumSize(new Dimension(300, 20));
            if (Boolean.getBoolean(PluginCmdEngine.PROP_BDDENGINE_DISTRIB_DISABLE)) {
                labelEngineDistrib.setEnabled(false);
                this._choiceEngineDistrib.setEnabled(false);
            }
            this._choiceEngineDistrib.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PluginCmdEngine.this._engineDistrib = (EngineBDDConfig.EngineType)((Object)EngineOptsPanel.this._choiceEngineDistrib.getSelectedItem());
                    PluginCmdEngine.this._launcher.setOption(OPT_ENGINE_DISTRIB, PluginCmdEngine.this._engineDistrib.toString());
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ENGINE_LBL_CHOICE")));
            panel.add((Component)labelEngineLocal, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
            panel.add((Component)this._choiceEngineLocal, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 5, 3, 5), 0, 0));
            panel.add((Component)labelEngineDistrib, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
            panel.add((Component)this._choiceEngineDistrib, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 5, 3, 5), 0, 0));
            root.add((Component)panel, new GridBagConstraints(0, optLine++, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 30, 10), 0, 0));
            this._choiceComputeLocal = new JRadioButton(ResCompute.getString("DLG_ENGINE_TCOMPUTE_LOCAL"));
            this._choiceComputeAutomatic = new JRadioButton(ResCompute.getString("DLG_ENGINE_TCOMPUTE_AUTO"));
            this._choiceComputeDistrib = new JRadioButton(ResCompute.getString("DLG_ENGINE_TCOMPUTE_DISTRIB"));
            ActionListener actionSelectCompute = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EngineBDDConfig.ComputeType oldType = PluginCmdEngine.this._computeType;
                    if (EngineOptsPanel.this._choiceComputeLocal.isSelected()) {
                        PluginCmdEngine.this.setComputeType(EngineBDDConfig.ComputeType.LOCAL);
                    } else if (EngineOptsPanel.this._choiceComputeAutomatic.isSelected()) {
                        PluginCmdEngine.this.setComputeType(EngineBDDConfig.ComputeType.AUTOMATIC);
                    } else if (EngineOptsPanel.this._choiceComputeDistrib.isSelected()) {
                        PluginCmdEngine.this.setComputeType(EngineBDDConfig.ComputeType.DISTRIB);
                    } else {
                        PluginCmdEngine.this.setComputeType(oldType);
                    }
                    PluginCmdEngine.this._launcher.setOption(OPT_COMPUTE_TYPE, PluginCmdEngine.this._computeType.toString());
                }
            };
            this._choiceComputeLocal.addActionListener(actionSelectCompute);
            this._choiceComputeAutomatic.addActionListener(actionSelectCompute);
            this._choiceComputeDistrib.addActionListener(actionSelectCompute);
            JPanel panel2 = new JPanel(new GridLayout(3, 1, 3, 3));
            panel2.add(this._choiceComputeLocal);
            panel2.add(this._choiceComputeAutomatic);
            panel2.add(this._choiceComputeDistrib);
            ButtonGroup bGroup = new ButtonGroup();
            bGroup.add(this._choiceComputeLocal);
            bGroup.add(this._choiceComputeAutomatic);
            bGroup.add(this._choiceComputeDistrib);
            panel2.setBorder(BorderFactory.createTitledBorder(ResCompute.getString("DLG_ENGINE_TCOMPUTE_LBL")));
            root.add((Component)panel2, new GridBagConstraints(0, optLine++, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 30, 10), 0, 0));
            int nbrDisable = 0;
            if (!PluginCmdEngine.this._computeLocalIsValid) {
                this._choiceComputeLocal.setEnabled(false);
                ++nbrDisable;
            }
            if (!PluginCmdEngine.this._computeAutoIsValid) {
                this._choiceComputeAutomatic.setEnabled(false);
                ++nbrDisable;
            }
            if (!PluginCmdEngine.this._computeDistribIsValid) {
                this._choiceComputeDistrib.setEnabled(false);
                ++nbrDisable;
            }
            if (nbrDisable == 2) {
                if (PluginCmdEngine.this._computeLocalIsValid) {
                    this._choiceComputeLocal.setEnabled(false);
                } else if (PluginCmdEngine.this._computeAutoIsValid) {
                    this._choiceComputeAutomatic.setEnabled(false);
                } else if (PluginCmdEngine.this._computeDistribIsValid) {
                    this._choiceComputeDistrib.setEnabled(false);
                }
            }
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public Component getPanel() {
            return this;
        }

        @Override
        public void trash() {
        }

        @Override
        public String getInfo(String key) {
            return PluginCmdEngine.this.getInfo(key);
        }

        @Override
        public Icon getIcon(String key) {
            return null;
        }
    }

    static class EngineVerify
    implements EngineControl {
        boolean _withError = false;
        StringBuffer _errorBuffer = new StringBuffer();

        EngineVerify() {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void appendOut(String msg) {
        }

        @Override
        public void appendErr(String msg) {
            this._withError = true;
            if (this._errorBuffer.length() < 1024) {
                this._errorBuffer.append(msg);
            }
        }

        @Override
        public void appendUserMsg(String msg) {
        }
    }

    static class DP4CeciliaBDD {
        static final String PROP_BDDENGINE_PATH_CECILIABDD = "cecilia.ft.engine.define.PathCeciliaBDD";
        static final String PROP_BDDENGINE_EXEC_CECILIABDD = "cecilia.ft.engine.define.ExecCeciliaBDD";
        static final String PROP_BDDENGINE_CTRL_CECILIABDD = "cecilia.ft.engine.define.CtrlCeciliaBDD";
        static final String PROP_BDDENGINE_CTRL_OPTIONS_CECILIABDD = "cecilia.ft.engine.define.CtrlOptionsCeciliaBDD";
        static final String PROP_BDDENGINE_MEMORYMAX_CECILIABDD = "cecilia.ft.engine.memory.MaxCeciliaBDD";

        DP4CeciliaBDD() {
        }
    }

    static class DP4Aralia4 {
        static final String PROP_BDDENGINE_PATH_ARALIA4 = "cecilia.ft.engine.define.PathAralia4";
        static final String PROP_BDDENGINE_EXEC_ARALIA4 = "cecilia.ft.engine.define.ExecAralia4";
        static final String PROP_BDDENGINE_CTRL_ARALIA4 = "cecilia.ft.engine.define.CtrlAralia4";
        static final String PROP_BDDENGINE_CTRL_OPTIONS_ARALIA4 = "cecilia.ft.engine.define.CtrlOptionsAralia4";
        static final String PROP_BDDENGINE_MEMORYMAX_ARALIA4 = "cecilia.ft.engine.memory.MaxAralia4";

        DP4Aralia4() {
        }
    }
}

