/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMELSimple;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMELSimple;
import com.dassault.cecilia.plugin.faulttree.compute.pref.DisplayDefaultMCS;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainerWithMsg;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIStoreLoad;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class PluginCmdMELSimple
extends AbstractPluginModel
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginCmdMELSimple.class.getPackage().getName());
    private static final String LOG_NAME = PluginCmdMELSimple.class.getSimpleName();
    protected static final String KEY_DATUM = ComputeType.MCS.toString();

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        return null;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
    }

    @Override
    public boolean withParameters() {
        return false;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    @Override
    public IOParameters getIOParameters() {
        return null;
    }

    @Override
    public boolean withOption(Plugable plugable) {
        if (plugable != null) {
            if (plugable.getPreferencies(DisplayDefaultMCS.PREF_KEY) == null) {
                plugable.putPreferencies(new DisplayDefaultMCS());
            }
            if (plugable.getPreferencies(PrintExportMCS.PREF_KEY) == null) {
                plugable.putPreferencies(new PrintExportMCS());
            }
        }
        return false;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCompute.getString("PLUG_CMD_MEL2_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCompute.getString("PLUG_CMD_MEL2_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return ResMsgVoc.getString("VOC_ERROR");
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoCompute.getImageIcon("PLUGIN_DEBUG");
        }
        return super.getIcon(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSession(Plugable launcher, Object sessionParams) {
        _LOG.finer("Entering : " + LOG_NAME + ".createSession");
        PluginModel pluginEngine = launcher.getPlugin(PluginCmdEngine.class.getName());
        if (pluginEngine == null || !(pluginEngine instanceof EngineBDDConfig)) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No EngineBDDConfig");
            return;
        }
        EngineBDDConfig engineBDDCfg = (EngineBDDConfig)((Object)pluginEngine);
        InfoDatum idatum = launcher.getDatum("Tree.Compute." + KEY_DATUM + ".Abstract");
        if (idatum == null) {
            return;
        }
        String msgError = idatum.getParameters().get("tree.error");
        if (msgError != null && !msgError.isEmpty()) {
            JOptionCecilia.showMessageDialog(launcher.getWindow(), msgError, this.getInfo("plugin.name"), 0);
            return;
        }
        _LOG.finer("Tracing : " + LOG_NAME + ".createSession - getDatum");
        File dagFile = idatum.getInputFiles().get("ceciliabdd.file.dag");
        if (dagFile == null || !dagFile.exists() || dagFile.length() == 0L) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No inputFile('ceciliabdd.file.dag')");
            return;
        }
        File xmlFile = idatum.getInputFiles().get("ceciliabdd.file.xml");
        if (xmlFile == null || !xmlFile.exists() || xmlFile.length() == 0L) {
            _LOG.logp(Level.SEVERE, LOG_NAME, "createSession", "No inputFile('ceciliabdd.file.res')");
            return;
        }
        File paramFile = idatum.getInputFiles().get("result.abstract");
        if (paramFile == null || !paramFile.exists() || paramFile.length() == 0L) {
            _LOG.logp(Level.INFO, LOG_NAME, "createSession", "No inputFile('result.abstract')");
            JOptionCecilia.showMessageDialog(launcher.getWindow(), ResCompute.getString("PLUG_CMD_MEL2_ERROR1"), this.getInfo("plugin.name"), 0);
            return;
        }
        boolean bSuccess = false;
        StringBuffer pathTree = new StringBuffer();
        try {
            ParamComputeMCS iparameters;
            ParamComputeMELSimple parameters;
            BooleanStore store;
            block45: {
                store = new BooleanStore();
                parameters = new ParamComputeMELSimple();
                EngineBDDMCS engineBDD = new EngineBDDMCS(engineBDDCfg);
                TaskContainerWithMsg task = new TaskContainerWithMsg(launcher, this.getInfo("plugin.name"));
                TaskIStoreLoad bTask = new TaskIStoreLoad(task, store, xmlFile);
                bTask.run();
                if (!((TaskItem)bTask).continueWhenFinnished()) {
                    return;
                }
                _LOG.finer("Tracing : " + LOG_NAME + ".createSession - TaskIStoreLoad.run");
                pathTree.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
                pathTree.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
                pathTree.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
                pathTree.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
                if (!store.getInfo(BooleanStore.INFO_TREE).equals(store.getRoot().getName())) {
                    pathTree.append(" : ").append(store.getRoot().getName());
                }
                task.setTitle(ResCompute.getString("PLUG_CMD_MEL2_HEADER") + pathTree.toString() + " ");
                try {
                    engineBDD.defineComputeType(store);
                }
                catch (Throwable th) {
                    _LOG.log(Level.SEVERE, "Exception during initialise compute", th);
                    if (!bSuccess) {
                        if (dagFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !dagFile.delete())) {
                            dagFile.deleteOnExit();
                        }
                        if (xmlFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !xmlFile.delete())) {
                            xmlFile.deleteOnExit();
                        }
                    }
                    _LOG.finer("Exiting : " + LOG_NAME + ".createSession");
                    return;
                }
                iparameters = null;
                iparameters = new ParamComputeMCS();
                try {
                    iparameters.loadFromXML(new FileInputStream(paramFile));
                }
                catch (IOException e) {
                    _LOG.log(Level.WARNING, "Error during read 'result.abstract'", e);
                    iparameters = null;
                    break block45;
                }
                parameters.copy(iparameters);
            }
            if (store.oneOrMoreLeavesWithoutProbability()) {
                parameters.setDefaultTypeProbability(TypeProbability.NONE);
            } else {
                String latentProbability;
                if (iparameters == null) {
                    double missionTime = store.getAverageFlightDuration();
                    if (!Double.isNaN(missionTime)) {
                        parameters.setMissionTimeSec(missionTime);
                    } else {
                        missionTime = store.getDefaultMissionTime();
                        if (!Double.isNaN(missionTime)) {
                            parameters.setMissionTimeSec(missionTime);
                        }
                    }
                }
                if ((latentProbability = store.getInfo(BooleanStore.INFO_LATENT_PROBABILITY)) != null && latentProbability.length() > 0) {
                    try {
                        parameters.setDefaultTypeProbability(TypeProbability.valueOf(latentProbability.toUpperCase()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (parameters.getTypeProbability() == null) {
                    parameters.setTypeProbability(TypeProbability.MCS);
                }
            }
            parameters.setReferenceCompute(false, false);
            parameters.setReferenceIgnore(false, false);
            _LOG.finer("Tracing : " + LOG_NAME + ".createSession - Display parameters dialog - started");
            if (!parameters.displayDialog(store, launcher)) {
                return;
            }
            _LOG.finer("Tracing : " + LOG_NAME + ".createSession - Display parameters dialog - finalized");
            boolean bLaunchCompute = true;
            if (iparameters != null) {
                boolean bSameCRCXml = false;
                String keyCRCXmlEquals = idatum.getParameters().get("CRC.Xml.equals");
                if (keyCRCXmlEquals != null) {
                    bSameCRCXml = keyCRCXmlEquals.equals("true");
                }
                if (iparameters.isCompatible(parameters, bSameCRCXml)) {
                    bLaunchCompute = false;
                }
                if (_LOG.isLoggable(Level.FINER)) {
                    _LOG.finer(LOG_NAME + ".Action: Db[" + iparameters.getShortAbstract() + "] User[" + parameters.getShortAbstract() + "] Crc[" + (bSameCRCXml ? "1" : "0") + "] => " + (bLaunchCompute ? "C" : "R"));
                }
            } else if (_LOG.isLoggable(Level.FINER)) {
                _LOG.finer(LOG_NAME + ".Action: Db[null] User[" + parameters.getShortAbstract() + "] Crc[?] => C");
            }
            if (bLaunchCompute) {
                JOptionCecilia.showMessageDialog(launcher.getWindow(), ResCompute.getString("PLUG_CMD_MEL2_ERROR2"), this.getInfo("plugin.name"), 0);
            } else {
                InfoDatum iDatumMCS = this.recupInfoDatumMCS(idatum, launcher);
                if (iDatumMCS != null) {
                    BooleanMEL results = new BooleanMEL(store);
                    results.setSimplified(true);
                    ComputeMELSimple compute = new ComputeMELSimple(parameters, results);
                    compute.defineFiles(dagFile, xmlFile);
                    compute.launchDisplay(iDatumMCS, launcher, true, pathTree.toString());
                } else {
                    _LOG.log(Level.WARNING, "Error during load real MCS of " + pathTree.toString());
                }
            }
            bSuccess = true;
        }
        finally {
            if (!bSuccess) {
                if (dagFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !dagFile.delete())) {
                    dagFile.deleteOnExit();
                }
                if (xmlFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !xmlFile.delete())) {
                    xmlFile.deleteOnExit();
                }
            }
            _LOG.finer("Exiting : " + LOG_NAME + ".createSession");
        }
    }

    private InfoDatum recupInfoDatumMCS(InfoDatum iDatumAbstract, Plugable launcher) {
        String config = iDatumAbstract.getParameters().get("Config");
        String key = "Tree.Compute." + KEY_DATUM + "@" + config;
        return launcher.getDatum(key);
    }
}

