/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ProbabilityVerify
implements BooleanStore.ProbabilityControl {
    private static Logger _LOG = Logger.getLogger(ProbabilityVerify.class.getPackage().getName());
    private static final int LIMIT_LIST = 11;
    List<BooleanNode> _missings = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _errors = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _lesserPs = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _greaterEs = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _avgNoAttrs = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _avgNoMatrixs = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _avgDefInsps = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _avgNoInsps = new ArrayList<BooleanNode>(11);
    List<BooleanNode> _avgBadParams = new ArrayList<BooleanNode>(11);

    @Override
    public void appendMissingProbability(BooleanNode node) {
        _LOG.info("Missing probability for event : " + node.getEngineName());
        if (this._missings.size() < 11) {
            this._missings.add(node);
        }
    }

    @Override
    public void appendLesserPeriodicity(BooleanNode node) {
        _LOG.fine("Lesser periodicity for event : " + node.getEngineName());
        if (this._lesserPs.size() < 11) {
            this._lesserPs.add(node);
        }
    }

    @Override
    public void appendGreaterExposition(BooleanNode node) {
        _LOG.fine("Greater exposition for event : " + node.getEngineName());
        if (this._greaterEs.size() < 11) {
            this._greaterEs.add(node);
        }
    }

    @Override
    public void appendErrorProbability(BooleanNode node) {
        _LOG.info("Error probability for event : " + node.getEngineName());
        if (this._errors.size() < 11) {
            this._errors.add(node);
        }
    }

    @Override
    public void appendAvgNoAttribute(BooleanNode node) {
        _LOG.fine("No attribute average for inspected event : " + node.getEngineName());
        if (this._avgNoAttrs.size() < 11) {
            this._avgNoAttrs.add(node);
        }
    }

    @Override
    public void appendAvgNoMatrix(BooleanNode node) {
        _LOG.info("No check affect for average matrix for event : " + node.getEngineName());
        if (this._avgNoMatrixs.size() < 11) {
            this._avgNoMatrixs.add(node);
        }
    }

    @Override
    public void appendAvgDefInspected(BooleanNode node) {
        _LOG.info("Bad inspected event : " + node.getEngineName());
        if (this._avgDefInsps.size() < 11) {
            this._avgDefInsps.add(node);
        }
    }

    @Override
    public void appendAvgNoInspected(BooleanNode node) {
        _LOG.info("Bad uninspected event : " + node.getEngineName());
        if (this._avgNoInsps.size() < 11) {
            this._avgNoInsps.add(node);
        }
    }

    @Override
    public void appendAvgBadParameter(BooleanNode node) {
        _LOG.fine("Bad inspected parameter for event : " + node.getEngineName());
        if (this._avgBadParams.size() < 11) {
            this._avgBadParams.add(node);
        }
    }

    public boolean withError() {
        return this._errors.size() > 0 || this._missings.size() > 0 || this._avgNoMatrixs.size() > 0 || this._avgDefInsps.size() > 0 || this._avgNoInsps.size() > 0;
    }

    private void appendMsg(List<BooleanNode> list, String header, StringBuffer buffer) {
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append(header).append("\t");
        int len = Math.min(10, list.size());
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(list.get(i).getName());
        }
        if (list.size() == 11) {
            buffer.append(", ...\n");
        }
    }

    public String getMessage() {
        StringBuffer msgBuffer = new StringBuffer();
        if (this._errors.size() > 0) {
            this.appendMsg(this._errors, ResCompute.getString("MSG_COMPUTE_PROBABILITY_ERROR"), msgBuffer);
        }
        if (this._missings.size() > 0) {
            this.appendMsg(this._missings, ResCompute.getString("MSG_COMPUTE_PROBABILITY_WITHOUT"), msgBuffer);
        }
        if (this._lesserPs.size() > 0) {
            this.appendMsg(this._lesserPs, ResCompute.getString("MSG_COMPUTE_PERIODICITY_LOWER"), msgBuffer);
        }
        if (this._greaterEs.size() > 0) {
            this.appendMsg(this._greaterEs, ResCompute.getString("MSG_COMPUTE_EXPOSITION_HIGHER"), msgBuffer);
        }
        if (this._avgNoAttrs.size() > 0) {
            this.appendMsg(this._avgNoAttrs, ResCompute.getString("MSG_COMPUTE_AVG_NO_ATTRIBUTE"), msgBuffer);
        }
        if (this._avgNoMatrixs.size() > 0) {
            this.appendMsg(this._avgNoMatrixs, ResCompute.getString("MSG_COMPUTE_AVG_NO_CHECK"), msgBuffer);
        }
        if (this._avgNoInsps.size() > 0) {
            this.appendMsg(this._avgNoInsps, ResCompute.getString("MSG_COMPUTE_AVG_NO_INSPECTED"), msgBuffer);
        }
        if (this._avgDefInsps.size() > 0) {
            this.appendMsg(this._avgDefInsps, ResCompute.getString("MSG_COMPUTE_AVG_DEF_INSPECTED"), msgBuffer);
        }
        if (this._avgBadParams.size() > 0) {
            this.appendMsg(this._avgBadParams, ResCompute.getString("MSG_COMPUTE_AVG_BAD_PARAMETER"), msgBuffer);
        }
        if (msgBuffer.length() == 0) {
            return null;
        }
        return msgBuffer.toString();
    }
}

