/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchTableModel;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class BatchTableRenderer
extends DefaultTableCellRenderer {
    private Font plainFont = null;
    private Font boldFont = null;
    private Icon _iconError = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DBFolder folder;
        int colModel;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.plainFont == null) {
            this.plainFont = this.getFont();
            if (this.plainFont != null) {
                this.boldFont = this.plainFont.deriveFont(1);
            }
        }
        if (this._iconError == null) {
            this._iconError = ResIcoCore.getImageIcon("FOLDER_ERROR");
        }
        if (!(table.getModel() instanceof BatchTableModel)) {
            return this;
        }
        BatchTableModel model = (BatchTableModel)table.getModel();
        BatchItem item = model.getItem(table.convertRowIndexToModel(row));
        boolean error = item.withError(colModel = table.convertColumnIndexToModel(column));
        this.setFont(error ? this.boldFont : this.plainFont);
        if (error) {
            this.setToolTipText(item.getError(colModel));
        } else {
            this.setToolTipText(null);
        }
        DBFolder dBFolder = folder = item.getFTEquation() != null ? item.getFTEquation().getDBFolder() : null;
        if (error) {
            this.setIcon(this._iconError);
        } else if (column == 0) {
            if (folder != null) {
                this.setIcon(DBFolderResources.getIcon(folder, true, true, false, false));
            } else {
                this.setIcon(this._iconError);
            }
        } else {
            this.setIcon(null);
        }
        if (column == 0 && folder != null) {
            this.setText(FolderRenderer.convertFolderToText(folder, FolderRenderer.DBFolderName.REFPATH));
        }
        return this;
    }
}

