/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ExportTableModel
extends AbstractTableModel {
    String _computeKey;
    protected ArrayList<ExportItem> _array = new ArrayList();

    public void configureComputeKey(String value) {
        this._computeKey = "." + value.toLowerCase();
    }

    public void setExportList(List<ExportItem> exports) {
        this._array = new ArrayList();
        for (int i = 0; i < exports.size(); ++i) {
            this._array.add(exports.get(i).getCopy());
        }
        this.fireTableDataChanged();
    }

    public List<ExportItem> getExportList() {
        return this._array;
    }

    @Override
    public int getRowCount() {
        return this._array.size();
    }

    public ExportItem getItem(int idx) {
        return this._array.get(idx);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return ResMsgVoc.getString("VOC_FORMAT");
            }
            case 1: {
                return ResMsgVoc.getString("VOC_PATH");
            }
            case 2: {
                return ResCompute.getString("VOC_OPTS");
            }
        }
        return ResMsgVoc.getString("VOC_ERROR");
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return ExportItem.Format.class;
            }
            case 1: {
                return File.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int r, int c) {
        ExportItem item = this.getItem(r);
        switch (c) {
            case 0: {
                return item.getFormat();
            }
            case 1: {
                return item.getFile();
            }
            case 2: {
                return true;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c != 2;
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        ExportItem item = this.getItem(r);
        switch (c) {
            case 0: {
                ExportItem.Format oldFormat = item.getFormat();
                if (value == null || oldFormat.equals(value)) break;
                ExportItem.Format newFormat = (ExportItem.Format)((Object)value);
                item.setFormat(newFormat);
                File file = item.getFile();
                String oldName = file.getName();
                String extName = (oldFormat.withComputeExt() ? this._computeKey : "") + oldFormat._ext;
                if (oldName.endsWith(extName)) {
                    String newName = oldName.substring(0, oldName.length() - extName.length()) + (newFormat.withComputeExt() ? this._computeKey : "") + newFormat._ext;
                    item.setFile(new File(file.getParent(), newName));
                    this.fireTableRowsUpdated(r, r);
                    break;
                }
                this.fireTableCellUpdated(r, 2);
                break;
            }
            case 1: {
                item.setFile((File)value);
                break;
            }
        }
    }

    public void addData(ExportItem obj) {
        int idx = this._array.size();
        this._array.add(obj);
        this.fireTableRowsInserted(idx, idx);
    }

    public void insertData(ExportItem obj, int idx) {
        this._array.add(idx, obj);
        this.fireTableRowsInserted(idx, idx);
    }

    public void removeData(int idx) {
        this.fireTableRowsDeleted(idx, idx);
        this._array.remove(idx);
    }

    public void changeData(ExportItem obj) {
        int idx = this._array.indexOf(obj);
        if (idx >= 0) {
            this.fireTableRowsUpdated(idx, idx);
        }
    }

    public void down(int idxMin, int idxMax) {
        ExportItem obj = this._array.remove(idxMax + 1);
        this._array.add(idxMin, obj);
        this.fireTableRowsUpdated(idxMin, idxMax + 1);
    }

    public void up(int idxMin, int idxMax) {
        ExportItem obj = this._array.remove(idxMin - 1);
        this._array.add(idxMax, obj);
        this.fireTableRowsUpdated(idxMin - 1, idxMax);
    }
}

