/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;

public class OptionsWordView {
    public int _pageOrientation;
    public int _pageWidth;
    public int _pageHeight;
    public static double DEFAULT_MARGIN = 28.34645669291339;

    OptionsWordView() {
        this._pageOrientation = 1;
        this._pageWidth = 595;
        this._pageHeight = 841;
    }

    public OptionsWordView(OptionsWordView src) {
        this._pageOrientation = src._pageOrientation;
        this._pageWidth = src._pageWidth;
        this._pageHeight = src._pageHeight;
    }

    public PageFormat createPageFormat() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pageFormat = job.defaultPage();
        pageFormat.setOrientation(this._pageOrientation);
        Paper paper = pageFormat.getPaper();
        paper.setSize(this._pageWidth, this._pageHeight);
        paper.setImageableArea(DEFAULT_MARGIN, DEFAULT_MARGIN, paper.getWidth() - 2.0 * DEFAULT_MARGIN, paper.getHeight() - 2.0 * DEFAULT_MARGIN);
        return pageFormat;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptionsWordView)) {
            return false;
        }
        OptionsWordView treeView = (OptionsWordView)obj;
        if (treeView._pageHeight != this._pageHeight) {
            return false;
        }
        if (treeView._pageOrientation != this._pageOrientation) {
            return false;
        }
        return treeView._pageWidth == this._pageWidth;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = hashCode * 2 + this._pageOrientation;
        hashCode = hashCode * 3 + this._pageHeight;
        hashCode = hashCode * 5 + this._pageWidth;
        return hashCode;
    }

    public void appendAbstract(StringBuilder buffer) {
        buffer.append(ResCompute.msgFormat("BATCH_EXPORT_TREE_MSG_SETUP", ExportItem.formatToString(this._pageWidth, this._pageHeight, this._pageOrientation)));
        buffer.append("<br/>");
    }

    public static class OptionsTreeView
    extends OptionsWordView {
        public boolean _gsrAuto;
        public int _gsrLevel;

        public OptionsTreeView() {
            this._gsrAuto = true;
            this._gsrLevel = 3;
        }

        public OptionsTreeView(OptionsTreeView src) {
            super(src);
            this._gsrAuto = src._gsrAuto;
            this._gsrLevel = src._gsrLevel;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof OptionsTreeView)) {
                return false;
            }
            OptionsTreeView treeView = (OptionsTreeView)obj;
            if (treeView._gsrAuto != this._gsrAuto) {
                return false;
            }
            return treeView._gsrLevel == this._gsrLevel;
        }

        @Override
        public int hashCode() {
            int hashCode = super.hashCode();
            hashCode = hashCode * 7 + this._gsrLevel;
            hashCode = hashCode * 11 + (this._gsrAuto ? 1 : 0);
            return hashCode;
        }

        @Override
        public void appendAbstract(StringBuilder buffer) {
            super.appendAbstract(buffer);
            if (this._gsrAuto) {
                buffer.append(ResCompute.msgFormat("BATCH_EXPORT_TREE_MSG_GSR", this._gsrLevel));
            }
        }
    }
}

