/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.logging.Logger;

public class AverageRiskComputeMarkov {
    private static Logger _LOG = Logger.getLogger(AverageRiskComputeMarkov.class.getPackage().getName());
    static final int NBR_STATE = 8;
    static final int NBR_TRANS = 12;
    int[] _trFrom = new int[]{0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 5, 6};
    int[] _trTo = new int[]{1, 2, 3, 4, 5, 4, 6, 5, 6, 7, 7, 7};
    double[] _trRate;
    double[] _trProb = new double[12];
    static int[] _stComp = new int[]{0, 1, 4, 7};
    double[] _T;
    double[] _nextT;
    long[] _idxT;
    double[] _p = new double[8];
    double[] _st = new double[8];
    double _maxRate;
    private static final double EPSILON_RELATIF = 1.0E-13;
    double[] _PRB0 = new double[8];
    double[] _PRB1 = new double[8];
    double[] _MST0 = new double[8];
    double[] _MST1 = new double[8];
    double[] _CVG0 = new double[8];
    double[] _CVG1 = new double[8];
    private static final double MAX_COEF_TIME = 1000.0;
    double _sumAtTM = 0.0;
    int _nbrValueAtTM = 0;
    private static final boolean _TRACE = false;

    private boolean checkConvergence(double[] P0, double[] P1, double ratio) {
        boolean convergence = true;
        for (int i = 0; i < P0.length && convergence; ++i) {
            double p0 = P0[i];
            double p1 = P1[i];
            if (p0 == 0.0) {
                if (p1 == 0.0) continue;
                convergence = p1 < ratio;
                continue;
            }
            convergence = p1 == 0.0 ? p0 < ratio : (p0 < p1 ? (p1 - p0) / p1 < ratio : (p0 - p1) / p1 < ratio);
        }
        return convergence;
    }

    private boolean DoubleEquals(double x, double y) {
        double diff;
        double a;
        if (x < y) {
            a = Math.abs(x);
            diff = Math.abs(x - y);
        } else if (x > y) {
            a = Math.abs(y);
            diff = Math.abs(y - x);
        } else {
            return true;
        }
        return diff / a < 1.0E-13;
    }

    private void computeMarkov(double time, double dtRatio, double epsilon) {
        int i;
        double dt = dtRatio / this._maxRate;
        if (dt > time) {
            dt = time;
        } else {
            double n = Math.ceil(time / dt);
            dt = time / n;
        }
        for (i = 0; i < 12; ++i) {
            this._trProb[i] = this._trRate[i] * dt;
        }
        System.arraycopy(this._p, 0, this._PRB0, 0, 8);
        System.arraycopy(this._p, 0, this._CVG0, 0, 8);
        System.arraycopy(this._p, 0, this._MST0, 0, 8);
        Arrays.fill(this._CVG1, 0.0);
        boolean stop1 = false;
        double t = 0.0;
        while (!stop1) {
            if (t >= time) {
                stop1 = true;
                break;
            }
            if (t + dt > time) {
                dt = time - t;
                t = time;
                for (i = 0; i < 12; ++i) {
                    this._trProb[i] = this._trRate[i] * dt;
                }
            } else {
                t += dt;
            }
            boolean stop2 = false;
            int cpt = 1;
            while (!stop2) {
                Arrays.fill(this._CVG1, 0.0);
                for (i = 0; i < 12; ++i) {
                    if (this._CVG0[this._trFrom[i]] == 0.0) continue;
                    double pr = this._trProb[i] * this._CVG0[this._trFrom[i]];
                    if (this.DoubleEquals(this._CVG1[this._trFrom[i]], pr)) {
                        this._CVG1[this._trFrom[i]] = 0.0;
                    } else {
                        int n = this._trFrom[i];
                        this._CVG1[n] = this._CVG1[n] - pr;
                    }
                    int n = this._trTo[i];
                    this._CVG1[n] = this._CVG1[n] + pr;
                }
                for (int idx = 0; idx < 8; ++idx) {
                    int n = idx;
                    this._CVG1[n] = this._CVG1[n] / (double)cpt;
                    this._PRB1[idx] = this._PRB0[idx] + this._CVG1[idx];
                    this._MST1[idx] = this._MST0[idx] + this._CVG1[idx] / (double)(cpt + 1);
                }
                stop2 = this.checkConvergence(this._PRB0, this._PRB1, epsilon);
                if (!stop2) {
                    System.arraycopy(this._PRB1, 0, this._PRB0, 0, 8);
                    System.arraycopy(this._MST1, 0, this._MST0, 0, 8);
                    System.arraycopy(this._CVG1, 0, this._CVG0, 0, 8);
                }
                ++cpt;
            }
            for (i = 0; i < 8; ++i) {
                int n = i;
                this._st[n] = this._st[n] + dt * this._MST1[i];
            }
            stop1 = this.checkConvergence(this._p, this._PRB1, epsilon);
            System.arraycopy(this._PRB1, 0, this._p, 0, 8);
            System.arraycopy(this._PRB1, 0, this._PRB0, 0, 8);
            System.arraycopy(this._PRB1, 0, this._MST0, 0, 8);
            System.arraycopy(this._PRB1, 0, this._CVG0, 0, 8);
        }
        if (stop1 && (t != time || time == 0.0)) {
            for (i = 0; i < 8; ++i) {
                int n = i;
                this._st[n] = this._st[n] + (time - t) * this._p[i];
            }
        }
    }

    private AverageRiskComputeMarkov(double Tm, double l1, double T1, double l2, double T2, double l3, double T3) {
        this._trRate = new double[]{l1, l2, l3, l2, l3, l1, l3, l1, l2, l3, l2, l1};
        this._T = new double[]{Tm, T1, T2, T3};
        this._nextT = new double[]{0.0, 0.0, 0.0, 0.0};
        this._idxT = new long[]{0L, 0L, 0L, 0L};
        this._maxRate = l1 + l2 + l3;
        Arrays.fill(this._p, 0.0);
        this._p[0] = 1.0;
        Arrays.fill(this._st, 0.0);
    }

    private double nextTime(double curTime) {
        double time = Double.MAX_VALUE;
        for (int i = 0; i < this._T.length; ++i) {
            if (this.DoubleEquals(curTime, this._nextT[i])) {
                int n = i;
                this._idxT[n] = this._idxT[n] + 1L;
                this._nextT[i] = (double)this._idxT[i] * this._T[i];
            }
            if (!(this._nextT[i] < time)) continue;
            time = this._nextT[i];
        }
        if (time == Double.MAX_VALUE) {
            _LOG.severe("Markov isn't able to compute nextTime for time " + curTime);
        }
        return time;
    }

    private void printResult(double time, int nbrComp) {
        System.out.print(time);
        for (int idx = 0; idx < 8 && idx <= _stComp[nbrComp]; ++idx) {
            if (idx != _stComp[nbrComp] || nbrComp == 2 && idx == 3) continue;
            System.out.print(";");
            System.out.print(this._p[idx]);
            System.out.print(";");
            System.out.print(this._st[idx]);
        }
        System.out.println();
    }

    double computeMaxTime(int nbrComp) {
        double maxTime = 1000.0 * this._T[nbrComp];
        double result = this._T[nbrComp];
        for (int i = nbrComp - 1; i >= 0; --i) {
            if (!((result = AverageRiskComputeMarkov.ppcm(this._T[i], result)) > maxTime)) continue;
            return maxTime;
        }
        return result;
    }

    private double computeMean(int nbrComp) {
        double curTime = 0.0;
        double maxTime = this.computeMaxTime(nbrComp);
        while (curTime < maxTime) {
            double nextTime = this.nextTime(curTime);
            this.computeMarkov(nextTime - curTime, 1.0, 1.0E-12);
            int nbrEoT = 0;
            if (nextTime == this._nextT[0]) {
                this._sumAtTM += this._p[_stComp[nbrComp]];
                ++this._nbrValueAtTM;
                ++nbrEoT;
                this._p[0] = this._p[0] + this._p[_stComp[nbrComp]];
                this._p[AverageRiskComputeMarkov._stComp[nbrComp]] = 0.0;
            }
            if (nextTime == this._nextT[1]) {
                ++nbrEoT;
                this._p[0] = this._p[0] + this._p[1];
                this._p[1] = 0.0;
                this._p[2] = this._p[2] + this._p[4];
                this._p[4] = 0.0;
                this._p[3] = this._p[3] + this._p[5];
                this._p[5] = 0.0;
                this._p[6] = this._p[6] + this._p[7];
                this._p[7] = 0.0;
            }
            if (nextTime == this._nextT[2]) {
                ++nbrEoT;
                this._p[0] = this._p[0] + this._p[2];
                this._p[2] = 0.0;
                this._p[1] = this._p[1] + this._p[4];
                this._p[4] = 0.0;
                this._p[3] = this._p[3] + this._p[6];
                this._p[6] = 0.0;
                this._p[5] = this._p[5] + this._p[7];
                this._p[7] = 0.0;
            }
            if (nextTime == this._nextT[3]) {
                ++nbrEoT;
                this._p[0] = this._p[0] + this._p[3];
                this._p[3] = 0.0;
                this._p[1] = this._p[1] + this._p[5];
                this._p[5] = 0.0;
                this._p[2] = this._p[2] + this._p[6];
                this._p[6] = 0.0;
                this._p[4] = this._p[4] + this._p[7];
                this._p[7] = 0.0;
            }
            curTime = nextTime;
            if (nbrEoT != 4) continue;
            break;
        }
        return curTime;
    }

    public static double computeOneFailures(double l1, double T1) {
        AverageRiskComputeMarkov markov = new AverageRiskComputeMarkov(T1, l1, T1, 0.0, T1, 0.0, T1);
        double time = markov.computeMean(1);
        return markov._st[_stComp[1]] / time;
    }

    public static double computeTwoFailures(double l1, double T1, double l2, double T2) {
        assert (T1 <= T2);
        AverageRiskComputeMarkov markov = new AverageRiskComputeMarkov(T2, l1, T1, l2, T2, 0.0, T2);
        double time = markov.computeMean(2);
        return markov._st[_stComp[2]] / time;
    }

    public static double computeTwoFailuresTM(double tm, double l1, double T1, double l2, double T2, boolean standard) {
        assert (tm <= T1);
        assert (T1 <= T2);
        AverageRiskComputeMarkov markov = new AverageRiskComputeMarkov(tm, l1, T1, l2, T2, 0.0, T2);
        double time = markov.computeMean(2);
        if (standard) {
            return markov._st[_stComp[2]] / time;
        }
        return markov._sumAtTM / (double)markov._nbrValueAtTM;
    }

    public static double computeThreeFailures(double l1, double T1, double l2, double T2, double l3, double T3) {
        assert (T1 <= T2);
        assert (T2 <= T3);
        AverageRiskComputeMarkov markov = new AverageRiskComputeMarkov(T3, l1, T1, l2, T2, l3, T3);
        double time = markov.computeMean(3);
        return markov._st[_stComp[3]] / time;
    }

    public static double computeThreeFailuresTM(double tm, double l1, double T1, double l2, double T2, double l3, double T3, boolean standard) {
        assert (tm <= T1);
        assert (T1 <= T2);
        assert (T2 <= T3);
        AverageRiskComputeMarkov markov = new AverageRiskComputeMarkov(tm, l1, T1, l2, T2, l3, T3);
        double time = markov.computeMean(3);
        if (standard) {
            return markov._st[_stComp[3]] / time;
        }
        return markov._sumAtTM / (double)markov._nbrValueAtTM;
    }

    public static void main(String[] args) {
        System.out.println("ppcm(2.33, 8000.0) = " + AverageRiskComputeMarkov.ppcm(2.33, 8000.0));
        System.out.println("ppcm(2.1, 8000.0) = " + AverageRiskComputeMarkov.ppcm(2.1, 8000.0));
        System.out.println("ppcm(2.0, 8000.0) = " + AverageRiskComputeMarkov.ppcm(2.0, 8000.0));
        System.out.println("ppcm(2.5, 8000.0) = " + AverageRiskComputeMarkov.ppcm(2.5, 8000.0));
        System.out.println("ppcm(1000.0, 3000.0) = " + AverageRiskComputeMarkov.ppcm(1000.0, 3000.0));
        System.out.println("ppcm(1532.0, 3000.0) = " + AverageRiskComputeMarkov.ppcm(1532.0, 3000.0));
        System.out.println("ppcm(2700.0, 3000.0) = " + AverageRiskComputeMarkov.ppcm(2700.0, 3000.0));
        System.exit(1);
        try {
            System.setOut(new PrintStream("Markov.log"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        AverageRiskComputeMarkov markov = new AverageRiskComputeMarkov(10.0, 1.0E-5, 2.0001, 3.0E-7, 10.0, 0.0, 10.0);
        double time = markov.computeMean(2);
        System.err.println(markov._st[_stComp[2]] / time);
    }

    static double ppcm(double a, double b) {
        return a * b / AverageRiskComputeMarkov.pgcd(a, b);
    }

    static double pgcd(double a, double b) {
        if (a < b) {
            return AverageRiskComputeMarkov.pgcd(b, a);
        }
        if (b == 0.0) {
            return a;
        }
        return AverageRiskComputeMarkov.pgcd(b, a % b);
    }
}

