/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.ActionControl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineExecute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class EngineBDDMELSimple
implements EngineExecute {
    private static Logger _LOG = Logger.getLogger(EngineBDDMELSimple.class.getPackage().getName());
    Boolean _stopEngine = false;
    int _nbrTreated = 0;
    EngineBDDMEL.TargetsAccessor _targets;
    BooleanMEL _resultMEL;
    BooleanMCS _resultMCS;
    ParamComputeMEL _parameters;

    public void prepareCompute(EngineBDDMEL.TargetsAccessor targets, BooleanMEL resultMEL, BooleanMCS resultMCS, ParamComputeMEL parameters) {
        this._targets = targets;
        this._resultMEL = resultMEL;
        this._resultMCS = resultMCS;
        this._parameters = parameters;
    }

    @Override
    public EngineBDDConfig.ResultType execute(EngineControl ctrl) {
        BooleanMCS currentMCS;
        boolean result = true;
        HashMap<String, BooleanNode> mapNameToNode = new HashMap<String, BooleanNode>();
        Iterator<BooleanNode> iNode = this._resultMEL.getStore().iterate();
        while (iNode.hasNext()) {
            BooleanNode node = iNode.next();
            if (!node.isLeaf()) continue;
            mapNameToNode.put(node.getEngineName(), node);
        }
        int limitOrder = this._parameters.getLimitOrder();
        Iterator<String> iTgt = this._targets.iterate();
        while (!ctrl.isCanceled() && iTgt.hasNext() && result) {
            String tgt = iTgt.next();
            BooleanNode node = (BooleanNode)mapNameToNode.get(tgt);
            if (node == null) {
                _LOG.warning("MELSimple - Node unknown: " + tgt);
                continue;
            }
            _LOG.finest("Compute MELSimplified for: " + node.getName());
            ++this._nbrTreated;
            this._resultMCS.configureForMELStep(node, ctrl, limitOrder);
            if (ctrl.isCanceled()) {
                return EngineBDDConfig.ResultType.ErrCompute;
            }
            BooleanMCS currentMCS2 = this.postTreatResult(this._resultMCS, ctrl);
            if (currentMCS2 == null) {
                ctrl.appendUserMsg(node.getName() + " : " + ResCompute.getString("PTF_DORMANT_ERROR"));
                return EngineBDDConfig.ResultType.ErrCompute;
            }
            if (currentMCS2 == this._resultMCS) {
                this._resultMCS.prepareMELInfoOrder(limitOrder);
                double topPr = this._resultMCS.computeProbabilities(this._parameters.getTypeProbability(), this._parameters.getMissionTimeH(), ctrl);
                if (ctrl.isCanceled()) {
                    return EngineBDDConfig.ResultType.ErrCompute;
                }
                this._resultMEL.addItem(node, this._resultMCS, topPr, this._resultMCS.constructWarning());
                continue;
            }
            BooleanResult currentResult = new BooleanResult(currentMCS2, new ParamComputeMCS(this._parameters));
            currentResult.computeProbabilities(this._parameters.getTypeProbability(), this._parameters.getMissionTimeH(), ctrl);
            if (ctrl.isCanceled()) {
                return EngineBDDConfig.ResultType.ErrCompute;
            }
            this._resultMEL.addItem(node, currentResult);
        }
        ++this._nbrTreated;
        this._resultMCS.configureForMELStep(null, ctrl, limitOrder);
        if (limitOrder > 0) {
            this._resultMCS.limitAt(limitOrder);
        }
        if ((currentMCS = this.postTreatResult(this._resultMCS, ctrl)) == null) {
            ctrl.appendUserMsg("[Nominal] : " + ResCompute.getString("PTF_DORMANT_ERROR"));
            return EngineBDDConfig.ResultType.ErrCompute;
        }
        if (currentMCS == this._resultMCS) {
            double topPr = this._resultMCS.computeProbabilities(this._parameters.getTypeProbability(), this._parameters.getMissionTimeH(), ctrl);
            System.out.println(topPr);
            if (ctrl.isCanceled()) {
                return EngineBDDConfig.ResultType.ErrCompute;
            }
            this._resultMCS.prepare();
            this._resultMEL.addItem(null, this._resultMCS, topPr, this._resultMCS.constructWarning());
        } else {
            BooleanResult currentResult = new BooleanResult(currentMCS, new ParamComputeMCS(this._parameters));
            currentResult.computeProbabilities(this._parameters.getTypeProbability(), this._parameters.getMissionTimeH(), ctrl);
            if (ctrl.isCanceled()) {
                return EngineBDDConfig.ResultType.ErrCompute;
            }
            this._resultMEL.addItem(null, currentResult);
        }
        return EngineBDDConfig.ResultType.NoError;
    }

    @Override
    public int getMaxStep() {
        return this._targets.size() + 1;
    }

    @Override
    public int getCurStep() {
        return this._nbrTreated;
    }

    public BooleanMCS postTreatResult(BooleanMCS originMCS, ActionControl ctrl) {
        TypeProbability type;
        if ((this._parameters.getPostTreatmentDormant().booleanValue() || this._parameters.getPostTreatmentAtRisk().booleanValue()) && ((type = this._parameters.getTypeProbability()) == TypeProbability.ARP1 || type == TypeProbability.ARP3 || type == TypeProbability.MCS)) {
            BooleanMCS currentMCS = originMCS;
            if (this._parameters.getPostTreatmentDormant().booleanValue()) {
                currentMCS = currentMCS.postTreatmentHide(this._parameters.getMissionTimeH());
            }
            if (this._parameters.getPostTreatmentAtRisk().booleanValue()) {
                BooleanMCS endOfFlyMCS = currentMCS.postTreatmentRisk(this._parameters.getSpecificTimeH());
                if (endOfFlyMCS == null) {
                    return null;
                }
                currentMCS = endOfFlyMCS;
            }
            return currentMCS;
        }
        return originMCS;
    }

    String constructWarning(String warningOrigin, boolean appendPTFError) {
        Object warning = warningOrigin;
        if (appendPTFError) {
            warning = warning != null ? (String)warning + "\n" + ResCompute.getString("PTF_DORMANT_ERROR") : ResCompute.getString("PTF_DORMANT_ERROR");
        }
        return warning;
    }
}

