/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EngineProcess
extends Thread {
    private static Logger _LOG = Logger.getLogger(EngineProcess.class.getPackage().getName());
    private String[] _execute = null;
    private String _command = null;
    private Process _process = null;
    private EngineControl _ctrlEcho = null;
    private File _commandFile = null;

    public EngineProcess(String[] execute, File commandFile, String command, EngineControl ctrlEcho) {
        super("EngineBDD");
        this._ctrlEcho = ctrlEcho;
        this._execute = execute;
        this._commandFile = commandFile;
        this._command = command;
        if (_LOG.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(1024);
            sb.append("EngineProcess-Cmd : ");
            for (int i = 0; i < execute.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("{" + execute[i] + "}");
            }
            _LOG.fine(sb.toString());
        }
    }

    public Process getProcess() {
        return this._process;
    }

    protected void createProcess() {
        block6: {
            try {
                block5: {
                    this._process = Runtime.getRuntime().exec(this._execute);
                    if (this._command.length() > 0) {
                        OutputStream out = this._process.getOutputStream();
                        try {
                            out.write(this._command.toString().getBytes());
                            out.flush();
                        }
                        catch (IOException e) {
                            if (this._ctrlEcho.isCanceled()) break block5;
                            _LOG.log(Level.WARNING, "IOException in InputStream", e);
                        }
                    }
                }
                _LOG.finest("End of createProcess method");
            }
            catch (IOException e) {
                if (this._ctrlEcho.isCanceled()) break block6;
                _LOG.log(Level.WARNING, "IOException during create process", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.createProcess();
            Thread ouputThread = new Thread("EngineBDD-Out"){

                @Override
                public void run() {
                    block4: {
                        try {
                            int c;
                            InputStream in = EngineProcess.this._process.getInputStream();
                            Object retour = "";
                            while ((c = in.read()) != -1) {
                                retour = (String)retour + (char)c;
                                if ((char)c != '\n') continue;
                                EngineProcess.this._ctrlEcho.appendOut((String)retour);
                                retour = "";
                            }
                            if (!((String)retour).equals("")) {
                                EngineProcess.this._ctrlEcho.appendOut((String)retour);
                            }
                            in.close();
                        }
                        catch (IOException e) {
                            if (EngineProcess.this._ctrlEcho.isCanceled()) break block4;
                            _LOG.log(Level.WARNING, "IOException in OutputStream", e);
                        }
                    }
                }
            };
            Thread errorThread = new Thread("EngineBDD-Err"){

                @Override
                public void run() {
                    block4: {
                        try {
                            int c;
                            InputStream err = EngineProcess.this._process.getErrorStream();
                            Object retour = "";
                            while ((c = err.read()) != -1) {
                                retour = (String)retour + (char)c;
                                if ((char)c != '\n') continue;
                                EngineProcess.this._ctrlEcho.appendErr((String)retour);
                                retour = "";
                            }
                            if (!((String)retour).equals("")) {
                                EngineProcess.this._ctrlEcho.appendErr((String)retour);
                            }
                            err.close();
                        }
                        catch (IOException e) {
                            if (EngineProcess.this._ctrlEcho.isCanceled()) break block4;
                            _LOG.log(Level.WARNING, "IOException in ErrorStream", e);
                        }
                    }
                }
            };
            ouputThread.start();
            errorThread.start();
            try {
                int result = this._process.waitFor();
                if (result != 0) {
                    this._ctrlEcho.appendErr(ResCompute.msgFormat("MSG_ENGINE_LOCAL_ERROR", result));
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (!this._ctrlEcho.isCanceled()) {
                    _LOG.log(Level.WARNING, "InterruptedException in waitFor", e);
                }
            }
        }
        finally {
            if (this._commandFile != null && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !this._commandFile.delete())) {
                this._commandFile.deleteOnExit();
            }
        }
    }
}

