/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MCSOutputStream
extends FilterOutputStream {
    int _maxIndex;
    int _nbrBits;
    int _maxValue;
    byte _buffer;
    short _pos;
    private static final byte ONE = 1;

    public MCSOutputStream(OutputStream stream, int maxIndex) {
        super(stream);
        this._maxIndex = maxIndex++;
        this._buffer = 0;
        this._pos = 0;
        this._nbrBits = 1;
        this._maxValue = 1;
        maxIndex >>= 1;
        while (this._maxValue < maxIndex) {
            this._maxValue <<= 1;
            ++this._nbrBits;
        }
    }

    public final void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    public void writeIndex(int idx) throws IOException {
        if (idx >= this._maxIndex) {
            throw new IOException("Write index greater or equal indexMax : " + idx);
        }
        int curLimit = this._maxValue;
        while (curLimit > 0) {
            this._buffer = (byte)(this._buffer << 1);
            if (curLimit <= idx) {
                this._buffer = (byte)(this._buffer | 1);
                idx -= curLimit;
            }
            curLimit >>= 1;
            this._pos = (short)(this._pos + 1);
            if (this._pos != 8) continue;
            this.write(this._buffer);
            this._buffer = 0;
            this._pos = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        while (this._pos < 8) {
            this._buffer = (byte)(this._buffer << 1);
            this._pos = (short)(this._pos + 1);
        }
        this.write(this._buffer);
        this._buffer = 0;
        this._pos = 0;
        super.flush();
    }
}

