/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMELAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.export.Export;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import java.io.IOException;
import java.util.ArrayList;

public class ExportMEL
extends ExportAbstract {
    BooleanMEL _result;

    public ExportMEL(BooleanStore store, ParamCompute parameters, BooleanMEL results, PrintExportMCS prefs) {
        super(store, parameters, prefs);
        this._result = results;
    }

    public ExportMEL(ComputeMELAbstract compute, PrintExportMCS prefs) {
        super(compute.getStore(), compute.getParameters(), prefs);
        this._result = compute.getResults();
    }

    private String rendererLong(long value, long limit) {
        if (value > limit) {
            return "> " + limit;
        }
        return Long.toString(value);
    }

    @Override
    protected void exportScribeProbabilityRoot(SrbInputStream outScribe, BooleanNode root) {
        double prb = this._result.getNominalItem().getProbability();
        this.exportScribeProbability(outScribe, prb);
    }

    @Override
    protected void exportScribeComputeInformations(SrbInputStream outScribe) {
        int limit = this._parameters.getLimitOrder();
        outScribe.concat(".br \n");
        outScribe.concat(ResCompute.getString("KEY_0690") + "@:@<HP2>" + (limit <= 0 ? "-" : Integer.toString(limit)) + "<EHP2>\n");
        outScribe.concat(".br \n");
        String complete = !((ParamComputeMEL)this._parameters).withListMEL() ? "VOC_YES" : "VOC_NO";
        outScribe.concat(ResCompute.getString("KEY_1448") + " : <HP2>" + ResMsgVoc.getString(complete) + "<EHP2>\n");
        outScribe.concat(".br \n");
        if (this._result.isSimplified()) {
            outScribe.concat(ResCompute.getString("MEL_SIMPLIFIED") + " : <HP2>" + ResMsgVoc.getString("VOC_YES") + "<EHP2>\n");
            outScribe.concat(".br \n");
        } else {
            String pessApprox = ((ParamComputeMEL)this._parameters).withPessimistCompute() ? "VOC_YES" : "VOC_NO";
            outScribe.concat(ResCompute.getString("KEY_1364") + " : <HP2>" + ResMsgVoc.getString(pessApprox) + "<EHP2>\n");
            outScribe.concat(".br \n");
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentDormant().booleanValue()) {
            outScribe.concat(".br \n");
            outScribe.concat(ResCompute.getString("VOC_DORMANT") + "@:@<HP2>" + ResMsgVoc.getString("VOC_YES") + "<EHP2>\n");
            outScribe.concat(".br \n");
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue()) {
            outScribe.concat(".br \n");
            outScribe.concat(ResCompute.getString("VOC_ENDOFFLY") + "@:@<HP2>" + this._renderer.formatMissionTime(((ParamComputeAbstract)this._parameters).getSpecificTime()) + "<EHP2>\n");
            outScribe.concat(".br \n");
        }
    }

    @Override
    public void exportFormatScribe(SrbInputStream outScribe) {
        outScribe.concat("<GDOC SEC=''>\n");
        outScribe.concat("<TITLE>" + ResCompute.getString("KEY_0704") + "\n");
        outScribe.concat("<DOCNUM>\n");
        outScribe.concat("<DATE>" + ExportMEL.getCurrentDateAsDDMMYYYY() + "\n");
        outScribe.concat(".ti @\n");
        outScribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        outScribe.concat("<BODY>\n");
        this.exportScribeBegining(outScribe);
        outScribe.concat("<EUL>\n");
        outScribe.concat(".sk 1\n");
        this.exportScribeDSFConfiguration(outScribe);
        this.exportScribeMCSSummary(outScribe);
        this.exportScribeMELList(outScribe);
        this.exportScribeMELMessages(outScribe);
        if (this._prefs.getBooleanValue("Content.TableOfContents")) {
            outScribe.concat("<EGDOC>1\n");
        } else {
            outScribe.concat("<EGDOC>0\n");
        }
    }

    private void exportScribeMCSSummary(SrbInputStream outScribe) {
        boolean withProbability = this._parameters.getTypeProbability() != TypeProbability.NONE;
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0706") + "\n");
        outScribe.concat("<TABLEAU>\n");
        outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_0747") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_ORDER") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_QUANTITY") + "\n");
        if (withProbability) {
            outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_OCCURRENCE") + "\n");
            outScribe.concat("<TABDEF CWIDTH = '10 12 12'   ALIGN = 'C C C'>\n");
        } else {
            outScribe.concat("<TABDEF CWIDTH = '10 12'   ALIGN = 'C C'>\n");
        }
        for (int c = 1; c <= 4; ++c) {
            outScribe.concat("<C>" + c + "\n");
            outScribe.concat("<C>" + this.rendererLong(this._result.getNominalItem().getOrderNumber(c), 1000000000L) + "\n");
            if (!withProbability) continue;
            outScribe.concat("<C>" + this._renderer.formatProbability(this._result.getNominalItem().getOrderProbability(c)) + "\n");
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    private void exportScribeMELList(SrbInputStream outScribe) {
        boolean withProbability = this._parameters.getTypeProbability() != TypeProbability.NONE;
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0702") + "\n");
        outScribe.concat("<TABLEAU>\n");
        outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_0704") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_EVENT") + "\n");
        if (withProbability) {
            outScribe.concat("<TABCOL>" + ResCompute.getString("MEL_PROBABILITY") + "\n");
            outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_FACTOR") + "\n");
        }
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_ORDER") + " 1\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_ORDER") + " 2\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_ORDER") + " 3\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_ORDER") + " 4\n");
        if (withProbability) {
            outScribe.concat("<TABDEF CWIDTH = '33 25 10 9 9 9 9'   ALIGN = 'L C C C C C C'>\n");
        } else {
            outScribe.concat("<TABDEF CWIDTH = '33 9 9 9 9'   ALIGN = 'L C C C C'>\n");
        }
        for (int i = 0; i < this._result.getNbrItems(); ++i) {
            BooleanMEL.Item item = this._result.getItemAt(i);
            outScribe.concat("<C>" + this.convertName(item.getNode().getName()) + "\n");
            if (withProbability) {
                double proba = item.getProbability();
                outScribe.concat("<C>" + this._renderer.formatProbability(proba) + "\n");
                outScribe.concat("<C>" + this._renderer.formatNumber(proba /= this._result.getNominalItem().getProbability()) + "\n");
            }
            for (int c = 1; c <= 4; ++c) {
                outScribe.concat("<C>" + this.rendererLong(item.getOrderNumber(c), 1000000L) + "\n");
            }
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    private void exportScribeMELMessages(SrbInputStream outScribe) {
        boolean bHeader = false;
        BooleanMEL.Item item = this._result.getNominalItem();
        String msg = item.getWarning();
        if (msg != null) {
            if (!bHeader) {
                outScribe.concat("<H1>" + ResCompute.getString("KEY_0703") + "\n");
                outScribe.concat("<TABLEAU>\n");
                outScribe.concat("<TABTIT>" + ResMsgVoc.getString("VOC_MESSAGES") + "\n");
                outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_EVENT") + "\n");
                outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_WARNING") + "\n");
                outScribe.concat("<TABDEF CWIDTH = '34 70'   ALIGN = 'L L'>\n");
                bHeader = true;
            }
            outScribe.concat("<C>[Nominal]\n");
            outScribe.concat("<C>" + msg + "\n");
        }
        for (int i = 0; i < this._result.getNbrItems(); ++i) {
            BooleanMEL.Item item2 = this._result.getItemAt(i);
            String msg2 = item2.getWarning();
            if (msg2 == null) continue;
            if (!bHeader) {
                outScribe.concat("<H1>" + ResCompute.getString("KEY_0703") + "\n");
                outScribe.concat("<TABLEAU>\n");
                outScribe.concat("<TABTIT>" + ResMsgVoc.getString("VOC_MESSAGES") + "\n");
                outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_EVENT") + "\n");
                outScribe.concat("<TABCOL>" + ResMsgVoc.getString("VOC_WARNING") + "\n");
                outScribe.concat("<TABDEF CWIDTH = '34 70'   ALIGN = 'L L'>\n");
                bHeader = true;
            }
            outScribe.concat("<C>" + this.convertName(item2.getNode().getName()) + "\n");
            outScribe.concat("<C>" + msg2 + "\n");
        }
        if (bHeader) {
            outScribe.concat("<ETABLEAU>\n");
        }
    }

    @Override
    protected void exportDocBookProbabilityRoot(DBKOutput xmlWriter, BooleanNode root) throws IOException {
        double prb = this._result.getNominalItem().getProbability();
        this.exportDocBookProbability(xmlWriter, prb);
    }

    @Override
    protected void exportDocBookComputeInformations(DBKOutput xmlWriter) throws IOException {
        int limit = this._parameters.getLimitOrder();
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("KEY_0690") + " : " + (limit <= 0 ? "-" : Integer.toString(limit)), true);
        xmlWriter.write("</para>\n", false);
        String complete = !((ParamComputeMEL)this._parameters).withListMEL() ? "VOC_YES" : "VOC_NO";
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("KEY_1448") + " : " + ResMsgVoc.getString(complete), true);
        xmlWriter.write("</para>\n", false);
        if (this._result.isSimplified()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("MEL_SIMPLIFIED") + " : " + ResMsgVoc.getString("VOC_YES"), true);
            xmlWriter.write("</para>\n", false);
        } else {
            String pessApprox = ((ParamComputeMEL)this._parameters).withPessimistCompute() ? "VOC_YES" : "VOC_NO";
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("KEY_1364") + " : " + ResMsgVoc.getString(pessApprox), true);
            xmlWriter.write("</para>\n", false);
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentDormant().booleanValue()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("PTD_TITLE"), true);
            xmlWriter.write("</para>\n", false);
        }
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("PTF_TITLE") + " : " + this._renderer.formatMissionTime(((ParamComputeAbstract)this._parameters).getSpecificTime()), true);
            xmlWriter.write("</para>\n", false);
        }
    }

    @Override
    public void exportFormatDocBook(DBKOutput xmlWriter) throws IOException {
        if (xmlWriter.getXmlOutputFile() == null) {
            return;
        }
        xmlWriter.printHeadXML();
        xmlWriter.write("<info>\n", false);
        xmlWriter.write("  <title>", false);
        xmlWriter.write(ResCompute.getString("PLUG_CMD_MEL_NAME"), true);
        xmlWriter.write("</title>\n", false);
        xmlWriter.write("  <para>", false);
        xmlWriter.write(ResMsgArbor.msgFormat("IO_PRINT_PRODUCTOR", "Cecilia WorkShop", "6.3.1"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("</info>\n", false);
        this.exportDocBookBegining(xmlWriter);
        this.exportDocBookDSFConfiguration(xmlWriter);
        this.exportDocBookMCSSummary(xmlWriter);
        this.exportDocBookMELList(xmlWriter);
        this.exportDocBookMELMessages(xmlWriter);
        xmlWriter.printFootXML();
    }

    private void exportDocBookMCSSummary(DBKOutput xmlWriter) throws IOException {
        ArrayList rows = new ArrayList();
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0706"));
        for (int c = 1; c <= 4; ++c) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(Integer.toString(c));
            row.add(this.rendererLong(this._result.getNominalItem().getOrderNumber(c), 1000000000L));
            if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
                row.add(this._renderer.formatProbability(this._result.getNominalItem().getOrderProbability(c)));
            }
            rows.add(row);
        }
        ArrayList<String> header = new ArrayList<String>();
        header.add(ResMsgVoc.getString("VOC_ORDER"));
        header.add(ResMsgVoc.getString("VOC_QUANTITY"));
        if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
            header.add(ResMsgVoc.getString("VOC_OCCURRENCE"));
        }
        DBKTableModel tableModel = new DBKTableModel(rows, header, DBKTableModel.DataType.OBJECTS);
        xmlWriter.insertTable(tableModel);
        xmlWriter.writeEndSection(1);
    }

    private void exportDocBookMELList(DBKOutput xmlWriter) throws IOException {
        ArrayList rows = new ArrayList();
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0702"));
        for (int i = 0; i < this._result.getNbrItems(); ++i) {
            BooleanMEL.Item item = this._result.getItemAt(i);
            ArrayList<String> row = new ArrayList<String>();
            row.add(this.convertName(item.getNode().getName()));
            if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
                double proba = item.getProbability();
                row.add(this._renderer.formatProbability(proba));
                row.add(this._renderer.formatNumber(proba /= this._result.getNominalItem().getProbability()));
            }
            for (int c = 1; c <= 4; ++c) {
                row.add(this.rendererLong(item.getOrderNumber(c), 1000000L));
            }
            rows.add(row);
        }
        ArrayList<String> header = new ArrayList<String>();
        header.add(ResMsgVoc.getString("VOC_EVENT"));
        if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
            header.add(ResCompute.getString("MEL_PROBABILITY"));
            header.add(ResMsgVoc.getString("VOC_FACTOR"));
        }
        header.add(ResMsgVoc.getString("VOC_ORDER") + " 1");
        header.add(ResMsgVoc.getString("VOC_ORDER") + " 2");
        header.add(ResMsgVoc.getString("VOC_ORDER") + " 3");
        header.add(ResMsgVoc.getString("VOC_ORDER") + " 4");
        DBKTableModel tableModel = new DBKTableModel(rows, header, DBKTableModel.DataType.OBJECTS);
        xmlWriter.insertTable(tableModel);
        xmlWriter.writeEndSection(1);
    }

    private void exportDocBookMELMessages(DBKOutput xmlWriter) throws IOException {
        ArrayList rows = new ArrayList();
        BooleanMEL.Item item = this._result.getNominalItem();
        String warning = item.getWarning();
        if (warning != null) {
            ArrayList<String> row = new ArrayList<String>();
            row.add("[Nominal]");
            row.add(warning);
            rows.add(row);
        }
        for (int i = 0; i < this._result.getNbrItems(); ++i) {
            BooleanMEL.Item item2 = this._result.getItemAt(i);
            String warning2 = item2.getWarning();
            if (warning2 == null) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add(this.convertName(item2.getNode().getName()));
            row.add(warning2);
            rows.add(row);
        }
        if (rows.size() > 0) {
            xmlWriter.writeSection(1, ResCompute.getString("KEY_0703"));
            ArrayList<String> header = new ArrayList<String>();
            header.add(ResMsgVoc.getString("VOC_EVENT"));
            header.add(ResMsgVoc.getString("VOC_WARNING"));
            DBKTableModel tableModel = new DBKTableModel(rows, header, DBKTableModel.DataType.OBJECTS);
            xmlWriter.insertTable(tableModel);
            xmlWriter.writeEndSection(1);
        }
    }

    @Override
    public void exportFormatXML(Appendable writer) throws IOException {
        Export.Helper.exportXMLDtd(writer);
        writer.append("<EXPORT VERSION='5.1'>\n");
        writer.append("\t<MEL>\n");
        this.exportXMLIdentificationProject(writer, true, "\t\t");
        writer.append("\t\t</PROJECT>\n");
        this.exportXMLIdentificationSystem(writer, true, "\t\t");
        writer.append("\t\t</SYSTEM>\n");
        this.exportXMLIdentificationTree(writer, true, true, "\t\t");
        writer.append("\t\t</TREE>\n");
        this.exportXMLFailureCondition(writer);
        this.exportXMLCutListSummary(writer);
        this.exportXMLMelList(writer);
        writer.append("\t</MEL>\n");
        writer.append("</EXPORT>\n");
    }

    private void exportXMLFailureCondition(Appendable writer) throws IOException {
        int order = Integer.MAX_VALUE;
        BooleanNode root = this._store.getRoot();
        writer.append("\t\t<EVENT ");
        writer.append(" NAME=\"").append(Util.formatStringForXml(root.getName())).append("\"");
        writer.append(" COMMENT=\"").append(Util.formatStringForXml((String)root.getInfo(Evt.KeyInfo.COMMENT, this._renderer)).toString()).append("\"");
        if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
            writer.append(" PROBABILITY=\"").append(this._renderer.formatProbability(this._result.getNominalItem().getProbability())).append("\"");
        }
        writer.append(" ORDER_MIN=\"").append(Integer.toString(order)).append("\"");
        writer.append("></EVENT>").append("\n");
    }

    private void exportXMLCutListSummary(Appendable writer) throws IOException {
        writer.append("\t\t<CUT_LIST>\n");
        for (int c = 1; c <= 4; ++c) {
            writer.append("\t\t\t<CUT");
            if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
                writer.append(" PROBABILITY=\"").append(this._renderer.formatProbability(this._result.getNominalItem().getOrderProbability(c))).append("\"");
            }
            writer.append(" ORDER=\"").append(Integer.toString(c)).append("\"");
            writer.append(" COUNT=\"").append(this.rendererLong(this._result.getNominalItem().getOrderNumber(c), 1000000000L)).append("\"");
            writer.append("></CUT>").append("\n");
        }
        writer.append("\t\t</CUT_LIST>\n");
    }

    private void exportXMLMelList(Appendable writer) throws IOException {
        writer.append("\t\t<MEL_LIST>\n");
        for (int i = 0; i < this._result.getNbrItems(); ++i) {
            BooleanMEL.Item item = this._result.getItemAt(i);
            writer.append("\t\t\t<MEL_LINE");
            if (this._parameters.getTypeProbability() != TypeProbability.NONE) {
                double proba = item.getProbability();
                writer.append(" PROBABILITY=\"").append(this._renderer.formatProbability(proba)).append("\"");
                writer.append(" FACTOR=\"").append(this._renderer.formatNumber(proba /= this._result.getNominalItem().getProbability())).append("\"");
            }
            writer.append(">\n");
            writer.append("\t\t\t\t<EVENT NAME=\"").append(Util.formatStringForXml(item.getNode().getName())).append("\"");
            writer.append("></EVENT>").append("\n");
            for (int c = 1; c <= 4; ++c) {
                writer.append("\t\t\t\t<MEL_QUANTITY");
                writer.append(" ORDER=\"").append(Integer.toString(c)).append("\"");
                writer.append(" COUNT=\"").append(this.rendererLong(item.getOrderNumber(c), 1000000L)).append("\"");
                writer.append("></MEL_QUANTITY>").append("\n");
            }
            writer.append("\t\t\t</MEL_LINE>").append("\n");
        }
        writer.append("\t\t</MEL_LIST>").append("\n");
    }
}

